/*

*************************************************************************

server.cpp - Iron Army server routines
Copyright (C) 2002 Mike Farrell (gccdragoonkain@yahoo.com)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************************/

//Includes///////////////////////////////////////////////////////////////////
#include <allegro.h>
#include <stdio.h>
#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include <libnet.h>
#include "net.h"
#include "main.h"

//Globals/////////////////////////////////////////////////////////////////////
NET_CONN *listen_conn = NULL;
NET_CONN *client_conn = NULL;


//init_server()
//start server and wait for player
char init_server()
{
  listen_conn = net_openconn(net_driver, "");
  if(!listen_conn)
    return FALSE;

  if(net_listen(listen_conn))
    return FALSE;

  return TRUE;
}

//shutdown_server()
//close all connections and quit
void shutdown_server()
{

  if(client_conn) 
    net_closeconn(client_conn);

  if(listen_conn)
    net_closeconn(listen_conn);
  listen_conn = NULL;
}

//server_listen
//returns TRUE if a new connection is ready
int server_listen()
{
  NET_CONN *new_conn;

  new_conn = net_poll_listen(listen_conn);

  if(new_conn == NULL)
    return FALSE;

  client_conn = new_conn;

  return TRUE;
}

//server_receive
//receive data from client and store in data
int server_receive(char *data) 
{
  int len = 0, n;

  if(client_conn)
  {
    len = net_receive_rdm(client_conn, data, PACKET_SIZE);

    if(len > 0)
      return len;
  }

  return 0;
}

//server_send
//send data to client
void server_send(char *data, int len)
{
  net_send_rdm(client_conn, data, len);
}






