//Defines////////////////////////////////////////////////////////////////////
//packet size
#define PACKET_SIZE           1024

//command flags
#define NDF_MOVE          1
#define NDF_FIGHT         2
#define NDF_AUTHORIZE     4
#define NDF_GOODBYE       8
#define NDF_OK            16
#define NDF_CHAT          32
#define NDF_STARTGAME     64
#define NDF_PSET          128
#define NDF_OPTSET        256
#define NDF_MISC          512
#define NDF_ENDTURN       1024

//status flags
#define NDF_INGAME        0x10000

//Classes////////////////////////////////////////////////////////////////////
class PACKET
{
  private:
    int size, pos;
    char buffer[PACKET_SIZE];

  public:
    void set(char *id);
    void add_byte(char b);
    int read(char *id);
    char get_byte();
    void build_chat_string(char *id, char *str);
    void send_server();
    void send_client();
    void rec_server();
    void rec_client();
};


//Prototypes/////////////////////////////////////////////////////////////////
char network_init();
void network_shutdown();

//Externs////////////////////////////////////////////////////////////////////
extern char online, is_server, waiting_response;
extern int net_driver;
extern PACKET net_packet;
