/*

*************************************************************************

server.cpp - Iron Army client routines
Copyright (C) 2002 Mike Farrell (gccdragoonkain@yahoo.com)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************************/

//Includes///////////////////////////////////////////////////////////////////
#include <allegro.h>
#include <stdio.h>
#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include <libnet.h>
#include "net.h"
#include "main.h"

//Globals/////////////////////////////////////////////////////////////////////
NET_CONN *server_conn = NULL;

//init_client
//start a connection to a server
char init_client(char *addr)
{
  server_conn = net_openconn(net_driver, NULL);

  if(!server_conn)
    return FALSE;

  if(net_connect(server_conn, addr)) 
  {
    net_closeconn(server_conn);
    return FALSE;
  }

  return TRUE;
}

//shutdown_client()
//close connection to server
void shutdown_client()
{
  if(server_conn) 
    net_closeconn(server_conn);
  server_conn = NULL;
}

//client_server_response
//returns TRUE on server response, 2 on failure, FALSE on nothing
char client_server_response()
{
  int x;

  x = net_poll_connect(server_conn);
  if(x == 0)
    return FALSE;

  if(x < 0)
  {
    net_closeconn(server_conn);

    return 2;
  }

  return TRUE;
}

//client_receiver
//get data from server
int client_receive(char *data)
{
  return net_receive_rdm(server_conn, data, PACKET_SIZE);
}

//client_send
//send data to server
void client_send(char *data, int len)
{
  net_send_rdm(server_conn, data, len);
}