/*

*************************************************************************

unit.cpp - Iron Army "unit" (game piece) object routines
Copyright (C) 2002 Mike Farrell (gccdragoonkain@yahoo.com)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************************/

/* This file is largely undocumented for now :( */

//Includes///////////////////////////////////////////////////////////////////
#include <allegro.h>
#include <fblend.h>
#include <iostream.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "main.h"
#include "loop.h"
#include "irondat.h"
#include "ranges.h"
#include "lightmap.h"
#include "unit.h"
#include "menu.h"
#include "effects.h"
#include "ai.h"
#include "net.h"

//Externs////////////////////////////////////////////////////////////////////
//extern LIGHTMAP *redfire;

//If loop is currently inside of UNIT::move func
char moving_one_unit = FALSE;

//Preset unit stats
const UNIT
// Dfp, atp, m_dfp, spr  ..... hp_preset, mp_preset
  red_archer  (1,  3,  0, r_archer, short_box, w_archer, "Archer", 4),
  red_mage    (0,  5,  4, r_mage, short_box, w_mage, "Mage", 4, 5),
  red_knight  (3,  7,  0, r_soldier, long_cross, w_short_cross, "Knight", 5),
  red_jester  (0,  4,  0, r_jester, long_box, w_short_cross, "Jester", 2),
  red_trapper (0,  0,  0, r_trapper, long_cross2, w_short_cross, "Trapper", 2),
  red_hero    (4,  10, 3, r_hero, long_cross, w_short_cross, "Hero", 10),
  red_sorc    (2,  6,  4, r_sorc, short_cross, w_mage, "Sorcerer", 10, 10),
  red_jug     (4,  11, 0, r_jug, short_cross, w_short_cross, "Juggernaut", 5),
  red_wmage   (0,  5,  2, r_wmage, short_box, w_mage, "WhiteMage", 3, 6),

  blue_archer (1,  3,  0, b_archer, short_box, w_archer, "Archer", 4),
  blue_mage   (0,  5,  4, b_mage, short_box, w_mage, "Mage", 4, 5),
  blue_knight (3,  7,  0, b_soldier, long_cross, w_short_cross, "Knight", 5),
  blue_jester (0,  4,  0, b_jester, long_box, w_short_cross, "Jester", 2),
  blue_trapper(0,  0,  0, b_trapper, long_cross2, w_short_cross, "Trapper", 2),
  blue_hero   (4,  10, 3, b_hero, long_cross, w_short_cross, "Hero", 10),
  blue_sorc   (2,  6,  4, b_sorc, short_cross, w_mage, "Sorcerer", 10, 10),
  blue_jug    (4,  11, 0, b_jug, short_cross, w_short_cross, "Juggernaut", 5),
  blue_wmage  (0,  5,  2, b_wmage, short_box, w_mage, "WhiteMage", 3, 6);

UNIT units[MAX_UNITS];
const UNIT *blue_type_list[9] =
{
  &blue_archer, &blue_mage, &blue_knight, &blue_jester,
  &blue_trapper, &blue_hero, &blue_sorc, &blue_jug, &blue_wmage
},
*red_type_list[9] =
{
  &red_archer, &red_mage, &red_knight, &red_jester,
  &red_trapper, &red_hero, &red_sorc, &red_jug, &red_wmage
};

char unit_at(int x, int y)
{
  char ret = FALSE;
  int i;

  for(i = 0; i < MAX_UNITS; i++) if(units[i].alive)
    if(units[i].x == x && units[i].y == y) { ret = TRUE; break; }

  return ret;
}

char add_unit(short x, short y, UNIT *type, char side)
{
  int i;

  //someone already on that spot?
  for(i = 0; i < MAX_UNITS; i++) if(units[i].alive)
  {
    if(x == units[i].x && y == units[i].y)
      return FALSE;
  }

  //see if we have any pieces left
  for(i = 0; i < MAX_UNITS; i++) if(!units[i].alive)
  {
    units[i].set(type, x, y, -1, side);
    return i+1;
  }
  return FALSE;
}


UNIT::UNIT(short dfp, short atp, short m_dfp, short id, char m_range[5][5], char a_range[21][21], char *name, int hp_preset, int mp_preset)
{
  is_leader = long_range = FALSE;
  turnflags = 0;

  //misc flag stuff
  if(name)
  {
    if(strstr(name, "Hero") || strstr(name, "Sorcerer"))
    {
      is_leader = TRUE;
      risk = 10;
    }
    else if(strstr(name, "Trapper"))
      risk = 9;
    else if(strstr(name, "Archer") || strstr(name, "Mage"))
      risk = 8;
    else if(strstr(name, "Knight"))
      risk = 7;
    else if(strstr(name, "Juggernaut"))
      risk = 7;
    else risk = 0;

    if(strstr(name, "Archer") || (strcmp(name, "Mage") == 0) || strstr(name, "Sorcerer"))
      long_range = TRUE;
  }

  this->atp = atp;
  this->dfp = dfp;
  this->m_dfp = m_dfp;
  this->id = id;
  this->hp_preset = hp_preset;
  this->mp_preset = mp_preset;

  if(m_range)
    memcpy(move_range, m_range, 25);
  if(a_range)
    memcpy(attack_range, a_range, 441);
  this->name = name;

}

void UNIT::set(const UNIT *type, short x, short y, short hp, char side)
{
  unit_type = (void *)type;
  risk = type->risk;
  long_range = type->long_range;
  hp_preset = type->hp_preset;
  mp_preset = type->mp_preset;
  is_leader = type->is_leader;
  atp = type->atp;
  dfp = type->dfp;
  m_dfp = type->m_dfp;
  id = type->id;
  turnflags = 0;
  name = type->name;
  memcpy(this->move_range, type->move_range, 25);
  memcpy(this->attack_range, type->attack_range, 441);
  this->x = x;
  this->y = y;
  if(hp != -1)
    this->hp = maxhp = hp;
  else
  {
    this->hp = maxhp = hp_preset;
    mp = maxmp = mp_preset;
  }
  this->side = side;
  alive = TRUE;
  tx = ty = -1;
}

void UNIT::draw()
{
  if(tx != -1)
    draw_sprite(buffer, (BITMAP *)data[id].dat, (int)(tx), (int)(ty)-my);
  else
  {
    char draw_red = FALSE;

    if(attacking != -1 && this != &units[attacking])
    {
      int t, u;

      for(u = 0; u < map_h; u++) for(t = 0; t < map_w; t++)
        if(map_data[t][u] & 4 && t == x && u == y)
        { draw_red = TRUE; break; }
    }
    
    if(frozen)
    {
      set_trans_blender(50, 200, 255, 0);
      draw_lit_sprite(buffer, (BITMAP *)data[id].dat, (x*32), (y*32)-my, 96);
    }
    else if(turnflags == 3)
    {
      set_trans_blender(0, 0, 0, 0);
      draw_lit_sprite(buffer, (BITMAP *)data[id].dat, (x*32), (y*32)-my, 64);
    }
    else if(draw_red)
    {
      set_trans_blender(255, 0, 0, 128);
      draw_lit_sprite(buffer, (BITMAP *)data[id].dat, (x*32), (y*32)-my, 64);
    }
    else draw_sprite(buffer, (BITMAP *)data[id].dat, (x*32), (y*32)-my);
  }
}

void UNIT::move(short dx, short dy)
{
  float dtx, dty;

  if(online && current_side == local_side)
  {
    int i = -1;

    for(i = 0; i < MAX_UNITS; i++) if(this == &units[i])
      break;

    if(is_server)
      net_packet.set("MOVE");
    else
      net_packet.set("reMO");

    net_packet.add_byte(i);
    net_packet.add_byte((map_w-1)-dx);
    net_packet.add_byte((map_h-1)-dy);

    if(is_server)
      net_packet.send_server();
    else
    {
      net_packet.send_client();
      waiting_response = TRUE;

      //wait for ok from server
      while(loop_go == TRUE && waiting_response)
        single_loop();
    }
  }

  moving = moving_one_unit = TRUE;

  dx *= 32;
  dy *= 32;
  tx = (float)x*32;
  ty = (float)y*32;

  if(ty-dy)
  {
    dty = fabs(ty-dy)/fabs(tx-dx);
    if(ty > dy) dty *= -4;
    else dty *= 4;
  }
  else dty = 0;

  if(tx-dx)
  {
    dtx = (tx < dx) ? 4 : -4;
  }
  else
  {
    dtx = 0;
    dty = (ty < dy) ? 4 : -4;
  }

  while((int)dx != (int)tx || (int)dy != (int)ty)
  {
    tx += dtx;
    ty += dty;

    processing();
    if(fpscounter >= fps) draw_screen();
    while(fpscounter > fps) ;
  }

  x = (int)(tx/32);
  y = (int)(ty/32);
  tx = ty = -1;

  turnflags |= TF_MOVED;

  if(game_type == GT_CPU && side == 1)
  {
    int x, y;

    for(y = this->y-1; y <= this->y+1; y++) for(x = this->x-1; x <= this->x+1; x++)
    {
      if(x >= 0 && x < map_w && y >= 0 && y < map_h)
        if(ai_map_data[x][y] & 1)
          ai_map_data[x][y] &= ~1;
    }
  }

  if(!moved_one) moved_one = TRUE;
  moving = moving_one_unit = FALSE;
}

void UNIT::draw_stats(char right)
{
  if(in_menu == 4) return;

  int x = right ? 490 : 5, wt = (id != b_sorc && id != r_sorc) ? 140 : 175, ht = (id != r_mage && id != r_wmage && id != b_wmage && id != b_mage && id != b_sorc && id != r_sorc) ? 18 : 28;

  if(id == b_jug || id == r_jug || id == b_wmage || id == r_wmage)
    wt = 175;

  st_wt = wt;

  window(x, 5, wt, ht, (!right) ? makecol(0, 0, 255) : makecol(255, 0, 0));
  textprintf(buffer, font, x+7, 12, makecol(220, 220, 220), "%s - (%d/%d)", name, hp, maxhp);
  if(ht == 28)
    textprintf(buffer, font, x+7, 22, makecol(220, 220, 220), "Magic - (%d/%d)", mp, maxmp);
  if(!right)
  {
    vbutton_x = x+wt-12;
    draw_sprite(buffer, (BITMAP *)data[s_info].dat, x+wt-12, 10);
  }

  if(!right && moved_one && turn_type == TT_LONG)
  {
    draw_sprite(buffer, (BITMAP *)data[s_done].dat, x+wt+5, 10);
  }
}

void UNIT::fight(UNIT *u)
{
  short i;

  for(i = 0; i < MAX_UNITS; i++)
  {
    if(u == &units[i])
    {
      fight(i);
      return;
    }
  }
}

void UNIT::fight(int id, int ax, int ay)
{
  float dtx = 0, dty = 0, a_x, a_y, a_r, a_s, da_r = 0.0;
  short a_a, timer = 400;
  char flipped = FALSE, dmg = 0, type = 0, flash = 0, max_shift = 0,
       cancel_attack = FALSE;
  int i;

  struct fire
  {
    float x, y, dx, dy;
    short a, c, ang, ang_delay;
  } fire[50];

  {
    int x, y;

    for(y = 0; y < map_h; y++) for(x = 0; x < map_w; x++) if(map_data[x][y] & 4)
      map_data[x][y] &= ~4;
  }

  if(online && current_side == local_side)
  {
    int i = -1;

    for(i = 0; i < MAX_UNITS; i++) if(this == &units[i])
      break;

    if(is_server)
      net_packet.set("FIGH");
    else
      net_packet.set("reFI");


    if(id != -1)
    {
      net_packet.add_byte(i);
      net_packet.add_byte((map_w-1)-units[id].x);
      net_packet.add_byte((map_h-1)-units[id].y);
      net_packet.add_byte(spelltype);
    }
    else
    {
      net_packet.add_byte(i);
      net_packet.add_byte((map_w-1)-ax);
      net_packet.add_byte((map_h-1)-ay);
      net_packet.add_byte(spelltype);
    }

    if(is_server)
      net_packet.send_server();
    else
    {
      net_packet.send_client();
      waiting_response = TRUE;

      //wait for ok from server
      while(loop_go == TRUE && waiting_response)
        single_loop();
    }
  }

  if(id != -1)
  {
    tx = (float)x*32;
    ty = (float)y*32;
    if(tx > units[id].x*32)
      dtx = -4;
    if(tx < units[id].x*32)
      dtx = 4;
    if(ty > units[id].y*32)
      dty = -4;
    if(ty < units[id].y*32)
      dty = 4;
    draw_other_stats = id;
  }
  else
  {
    if(map_data[ax][ay] & 1)
      map_data[ax][ay] &= ~1;
  }

  switch(this->id)
  {
    case r_archer: case b_archer:
      type = 1;
      a_x = x*32+8;
      a_y = y*32;
      a_r = (atan2(a_x-(units[id].x*32+16), a_y-(units[id].y*32+16))/0.0174532925)*0.7111111;
    break;
    case r_sorc: case b_sorc:
      if(game_type == GT_CPU && side == 1)
        spelltype = 50 + (random()%2);
      else spelltype += 50;
    case r_mage: case b_mage:
      type = 2;

      //Fire
      if(spelltype == 0)
      {
        if(mp-3 < 0) return;
        mp -= 3;
        for(i = 0; i < 50; i++)
        {
          fire[i].a = 255;
          if(id != -1)
          {
            fire[i].x = units[id].x*32+8;
            fire[i].y = units[id].y*32+8;
          }
          else
          {
            fire[i].x = ax*32+8;
            fire[i].y = ay*32+8;
          }
          fire[i].dx = (float)(random()%50)/10;
          fire[i].dy = (float)(random()%50)/10;
          if(random()%2) fire[i].dx *= -1;
          if(random()%2) fire[i].dy *= -1;

          fire[i].c = makecol(255, 0, 0);
        }
      }
      //Freeze
      else if(spelltype == 1)
      {
        if(mp-4 < 0) return;
        mp -= 4;

        if(id != -1)
        {
          a_x = units[id].x*32+16;
          a_y = units[id].y*32+16;
        }
        else
        {
          a_x = ax*32+16;
          a_y = ay*32+16;
        }
        a_r = 0;
        a_s = 0;
        a_a = 128;
      }
      //lit
      else if(spelltype == 50)
      {
        if(mp-6 < 0) return;
        mp -= 6;
        a_a = 10;
        if(id != -1)
        {
          a_x = units[id].x*32;
          a_y = units[id].y*32;
        }
        else
        {
          a_x = ax*32-12;
          a_y = ay*32-12;
        }
      }
      //quake
      else if(spelltype == 51)
      {
        //prepare.....for an earthquake!
        if(mp-4 < 0) return;
        mp -= 4;

        if(id != -1)
        {
          a_x = units[id].x*32-34;
          a_y = units[id].y*32-34;
        }
        else
        {
          a_x = ax*32-34;
          a_y = ay*32-34;
        }

        quake_id = quake_a;
        max_shift = 1;
        quake_x = (int)a_x;
        quake_y = (int)a_y;

        play_sample((SAMPLE *)data[blast].dat, 255, 128, 120, 0);
      }
    break;
    case r_wmage: case b_wmage:
      type = 3;

      //hp\mp restore (just re-use fire struct)
      if(spelltype == 0)
      {
        if(mp-2 < 0) return;
        mp -= 2;
      }
      else if(spelltype == 1)
      {
        if(mp-5 < 0) return;
        mp -= 5;
      }

      for(i = 0; i < 10; i++)
      {
        fire[i].a = 255;
        if(id != -1)
        {
          fire[i].x = units[id].x*32+8;
          fire[i].y = units[id].y*32+8;
        }
        else
        {
          fire[i].x = ax*32+8;
          fire[i].y = ay*32+8;
        }

        fire[i].ang = 0;
        fire[i].ang_delay = i*6;

        fire[i].c = (spelltype == 0) ? makecol(255, 255, 255) : makecol(100, 150, 255);
      }
    break;
    default:
      play_sample((SAMPLE *)data[punch].dat, 255, 128, 1000, 0);
  }

  while(1)
  {
    //arrow attack
    if(type == 1)
    {
      int map_x = (int)a_x/32, map_y = (int)a_y/32;

      a_x -= sin((a_r/0.7111)*0.0174532925)*5;
      a_y -= cos((a_r/0.7111)*0.0174532925)*5;


      //don't let arrow fly through most non-passable areas
      /********************************************************
      (more specifically don't let arrow fly through a
      any non passable block that is in the middle of a straight
      line of 3
      ********************************************************/

      if(map_x > 0 && map_x < 20 && map_y > 0 && map_y < 20)
      {
        int x, y;
        char vertical_line = TRUE, horizontal_line = TRUE;

        y = map_y;
        for(x = map_x-1; x <= map_x+1; x++)
        {
          if(x < 0 || x >= 20 || y < 0 || y >= 20)
            continue;

          if(!(map_data[x][y] & 8))
          {
            horizontal_line = FALSE;
            break;
          }
        }

        x = map_x;
        for(y = map_y-1; y <= map_y+1; y++)
        {
          if(x < 0 || x >= 20 || y < 0 || y >= 20)
            continue;

          if(!(map_data[x][y] & 8))
          {
            vertical_line = FALSE;
            break;
          }
        }
        
        cancel_attack = (horizontal_line || vertical_line);
      }

      if(cancel_attack)
        break;

      if((int)a_x > units[id].x*32 && (int)a_x < units[id].x*32+32 && (int)a_y > units[id].y*32 && (int)a_y < units[id].y*32+32)
        break;
    }
    //magic attack
    else if(type == 2)
    {
      if(spelltype == 0)
      {
        char going = FALSE;

        for(i = 0; i < 50; i++) if(fire[i].a)
        {
          going = TRUE;
          fire[i].x += fire[i].dx;
          fire[i].y += fire[i].dy;
          fire[i].a -= 4;
          if(fire[i].a < 0)
            fire[i].a = 0;
        }
        if(!going) break;
      }
      else if(spelltype == 1)
      {
        if(a_s != -1)
        {
          if(a_s < 2.5)
          {
            a_s += 0.04;
            a_x -= 0.95;
            a_y -= 0.95;
          }
          else da_r += 0.5;

          a_r += da_r;
          if(da_r >= 40)
          {
            units[id].frozen = 2;
            flash = 3;
            a_s = -1;
            a_x = units[id].x*32-12;
            a_y = units[id].y*32-12;
          }
        }
        else
        {
          a_y += 0.5;
          a_a -= 1;
          if(a_a < 0) break;
        }

        if(flash) flash--;
      }
      else if(spelltype == 50)
      {
        if(fpscounter % 10 == 0)
          a_a--;
        if(!a_a) break;
      }
      else if(spelltype == 51)
      {
        timer--;
        if(timer <= 0) break;

        if(timer > 100)
        {
          if((201-timer) % 40 == 0 && quake_id < quake_c)
            quake_id++;
        }

        if(timer == 100) quake_id = quake_b;
        if(timer == 50) quake_id = quake_a;

        if(max_shift)
        {
          s_dx = random()%max_shift;
          if(random()%2) s_dx *= -1;
          s_dy = random()%max_shift;
          if(random()%2) s_dy *= -1;
        }

        if(fpscounter % 15 == 0)
          max_shift += (timer > 200) ? 1 : -1;
      }
    }
    //healing
    else if(type == 3)
    {
      char going = FALSE;

      for(i = 0; i < 10; i++) if(fire[i].a)
      {
        if(fire[i].ang_delay)
          fire[i].ang_delay--;
        else if(fire[i].ang < 360)
          fire[i].ang += 4;

        if(fire[i].ang == 360)
          fire[i].a -= 6;

        going = TRUE;
        if(fire[i].a < 0)
          fire[i].a = 0;
      }
      if(!going) break;
    }
    //normal attack
    else
    {
      tx += dtx;
      ty += dty;

      if(flipped && (int)tx == x*32 && (int)ty == y*32)
        break;

      if((int)tx == units[id].x*32 && (int)ty == units[id].y*32)
      {
        dtx *= -1;
        dty *= -1;
        flipped = TRUE;
      }
    }


    processing();
    if(fpscounter >= fps)
    {
      if(flash)
        clear_to_color(buffer, 0xffff);
      else
      {
        draw_screen(TRUE);
        if(type == 1)
          rotate_sprite(buffer, (BITMAP *)data[arrow].dat, (int)(a_x+0.5), (int)(a_y+0.5)-my, ftofix(255-a_r));
        if(type == 2)
        {
          if(spelltype == 0)
          {
            for(i = 0; i < 50; i++) if(fire[i].a)
              monocrome_draw_lightmap_ex(buffer, (BITMAP *)data[red_fire].dat, (int)(fire[i].x+0.5), (int)(fire[i].y+0.5)-my, fire[i].c, fire[i].a-255);
          }
          else if(spelltype == 1)
          {
            set_trans_blender(0, 0, 0, a_a);
            if(a_s != -1)
               rotate_scaled_sprite_trans(buffer, (BITMAP *)data[ice].dat, (int)a_x, (int)a_y-my, a_r, a_s);
             else
               fblend_trans((BITMAP *)data[ice_2].dat, buffer, (int)a_x, (int)a_y-my, a_a);
          }
          else if(spelltype == 50)
          {
            electric_line(buffer, x*32+6, y*32+4-my, (int)a_x+(random()%32), (int)a_y+(random()%32)-my, a_a, 15);
            electric_line(buffer, x*32+6, y*32+4-my, (int)a_x+(random()%32), (int)a_y+(random()%32)-my, a_a, 15);
            electric_line(buffer, x*32+6, y*32+4-my, (int)a_x+(random()%32), (int)a_y+(random()%32)-my, a_a, 15);
          }
        }
        else if(type == 3)
        {
          for(i = 0; i < 10; i++) if(fire[i].a)
            monocrome_draw_lightmap_ex(buffer, (BITMAP *)data[red_fire].dat, (int)((fire[i].x+0.5)+sin(fire[i].ang*(M_PI/180))*25), (int)((fire[i].y+0.5)-my-cos(fire[i].ang*(M_PI/180))*25), fire[i].c, fire[i].a-255);
        }
      }
      draw_stats();
      blit(buffer, screen, 0, 0, 0, 0, 640, 480);
    }
    while(fpscounter > fps) ;
  }

  if(!cancel_attack)
  {
    if(type != 2 || spelltype != 1)
    {
      if(type == 2)
      {
        if(spelltype == 51)
          dmg = 2-units[id].m_dfp;
        else dmg = atp-units[id].m_dfp;
        if(dmg < 0) dmg = 0;
      }
      else if(type == 3)
      {
        dmg = -atp;

        //don't let white mages heal their own mp or any other white mages' mp
        if(id != -1 && spelltype == 1 && (units[id].id == r_wmage || units[id].id == b_wmage))
          dmg = 0;
      }
      else
      {
        dmg = atp-units[id].dfp;
        if(dmg < 0) dmg = 0;
      }

      for(i = 0; i < MAX_UNITS; i++)
      {
        if(units[i].alive && ax == units[i].x && ay == units[i].y)
        {
          id = i;
          break;
        }
      }

      if(id != -1)
      {
        if(strcmp(name, "Trapper") == 0 && units[id].is_leader)
          dmg = 10;

        set_dmg(units[id].x*32+8, units[id].y*32, dmg);

        if(type == 3 && spelltype == 1)
          units[id].mp -= dmg;
        else
          units[id].hp -= dmg;
          
        if(units[id].hp > units[id].maxhp)
          units[id].hp = units[id].maxhp;
        if(units[id].mp > units[id].maxmp)
          units[id].mp = units[id].maxmp;

        if(units[id].hp <= 0)
        {
          units[id].hp = 0;
          units[id].die();
        }
        else
        {
          if(game_type == GT_CPU)
          {
            if(units[id].side)
              ai_favor += 0.3;
            else ai_favor -= 0.3;

            if(ai_favor < 0)
              ai_favor = 0.0;
            else if(ai_favor > 1)
              ai_favor = 1.0;
          }
        }
      }
    }
    else draw_other_stats = -1;
  }

  selected = attacking = moving = -1;
  tx = ty = -1;

  if(type == 2 && spelltype == 51)
  {
    int x, y;

    for(y = (int)(a_y/32+1); y <= (int)(a_y/32)+3; y++) for(x = (int)(a_x/32+1); x <= (int)(a_x/32)+3; x++) if(x >= 0 && x < map_w && y >= 0 && y < map_h)
    {
      for(i = 0; i < MAX_UNITS; i++) if(units[i].alive && units[i].x == x && units[i].y == y && i != id)
      {
        dmg = 2-units[i].m_dfp;
        if(dmg < 0) dmg = 0;

        set_dmg(units[i].x*32+8, units[i].y*32, dmg);

        units[i].hp -= dmg;
        if(units[i].hp <= 0)
        {
          units[i].hp = 0;
          units[i].die();
        }
      }
    }

    quake_id = -1;
    s_dx = s_dy = 0;
    stop_sample((SAMPLE *)data[blast].dat);
  }

  if(side == 0 || game_type == GT_2PLOCAL) no_selection = TRUE;

  turnflags |= TF_ATTACKED;
  turnflags |= TF_MOVED;

  if(!moved_one) moved_one = TRUE;

  if(game_type == GT_CPU && side == 0 && long_range)
  {
    int x, y;

    for(y = this->y-1; y <= this->y+1; y++) for(x = this->x-1; x <= this->x+1; x++)
    {
      if(x >= 0 && x < map_w && y >= 0 && y < map_h)
        if(ai_map_data[x][y] & 1)
          ai_map_data[x][y] &= ~1;
    }
  }

  //inefficient below, but this game starting
  //to really piss me off

  if(game_type == GT_2PINET)
  {
    if(turn_type == TT_SHORT && (side == local_side))
      flip_map();

    return;
  }

  if(turn_type == TT_SHORT && (side == 0 || game_type == GT_2PLOCAL))
    flip_map();
}

void UNIT::die()
{
  BITMAP *tmp = (BITMAP *)data[id].dat;
  int bx = 0, by = 0;

  alive = FALSE;

  if(is_leader)
  {
    leader_died = side;
    clear_keybuf();
  }
  play_sample((SAMPLE *)data[die_scream].dat, 255, 128, 1000, 0);

  while(bx > -640)
  {
    bx -= 10;
    by -= 10;  

    processing();
    if(fpscounter >= fps)
    {
      draw_screen(TRUE);
      blit(tmp, buffer, 0, 0, x*32+bx, y*32+by-my, 16, 16);
      blit(tmp, buffer, 0, 16, x*32+bx, y*32+16-by-my, 16, 16);
      blit(tmp, buffer, 16, 0, x*32+16-bx, y*32+by-my, 16, 16);
      blit(tmp, buffer, 16, 16, x*32+16-bx, y*32+16-by-my, 16, 16);
      blit(buffer, screen, 0, 0, 0, 0, 640, 480);
    }
    while(fpscounter > fps) ;
  }

  if(game_type == GT_CPU)
  {
    if(side)
      ai_favor += 0.0125;
    else ai_favor -= 0.0125;

    if(ai_favor < 0)
      ai_favor = 0.0;
    else if(ai_favor > 1)
      ai_favor = 1.0;
  }
}
