/*

*************************************************************************

title.cpp - Iron Army title and main menu routines
Copyright (C) 2002 Mike Farrell (gccdragoonkain@yahoo.com)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************************/

//Includes///////////////////////////////////////////////////////////////////
#include <allegro.h>
#include <fblend.h>
#include <ctype.h>
#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include <libnet.h>
//#include <iostream.h>
#include "net.h"
#include "server.h"
#include "client.h"
#include "main.h"
#include "title.h"
#include "console.h"
#include "loop.h"
#include "irondat.h"

//Defines////////////////////////////////////////////////////////////////////
#define NUM_CHOICES    6

//Globals////////////////////////////////////////////////////////////////////
char menu_id, show_mcoords = FALSE;
float w = 4096, dy = 0;
char timer = 64, stop = FALSE, to_stop = 0, option_lit = FALSE;
short menu_alpha = 0, screen_alpha = 255, outgame_c = 0;
menu_input input_box;

//Structs////////////////////////////////////////////////////////////////////
struct menu_choice
{
  int x, y, w, h;
  const char *text;
  char enabled, centered;

  void set(int x, int y, const char *text, char cent=FALSE);
  char mouse_over();
} choices[NUM_CHOICES];



//title_msg()
//shows a message and waits for click/keypress
void title_msg(char *msg)
{
  set_menu(-1);
  title_output();
  textout_centre(screen, font, msg, 320, 240, 0xffff);
  clear_keybuf();

  while(!keypressed() && !mouse_b) ;
  set_menu(0);
}

//set_menu()
//loads a preset menu screen
void set_menu(int id)
{
  int i;
  const char *diffs[3] = { "CPU Level: Easy", "CPU Level: Normal", "CPU Level: Hard" };

  //disconnect if connected
  if(online && id == 0)
  {
    net_packet.set("ENDG");

    if(is_server)
    {
      net_packet.send_server();
      shutdown_server();
    }
    else
    {
      net_packet.send_client();
      shutdown_client();
    }

    online = FALSE;
  }

  for(i = 0; i < NUM_CHOICES; i++)
    choices[i].enabled = FALSE;
  input_box.enabled = FALSE;
  if(id != 5)
    console.clear();

  menu_id = id;
  switch(id)
  {
    //main
    case 0:
      choices[0].set(50, 420, "1 Player (COM)");
      choices[1].set(250, 420, "2 Player (Local)");
      choices[2].set(450, 420, "2 Player (Multiplayer)");
      choices[3].set(180, 445, "Options");
      choices[4].set(400, 445, "Quit");
    break;
    //options
    case 1:
      choices[0].set(100, 80, (turn_type == TT_SHORT) ? "Game Mode: Long" : "Game Mode: Short");
      choices[1].set(100, 95, diffs[c_diff]);
      choices[2].set(100, 110, (show_shroud) ? "Shroud: On" : "Shroud: Off");
      choices[5].set(100, 125, (!battlefield) ? "Battlefield: Plains" : "Battlefield: Rocky Pass");
      choices[3].set(100, 140, (full_screen) ? "Fullscreen: On" : "Fullscreen: Off");
      choices[4].set(306, 200, "Done");
    break;
    //multiplayer
    case 2:
      choices[0].set(120, 445, "Start server", TRUE);
      choices[1].set(320, 445, "Join game", TRUE);
      choices[2].set(520, 445, "Cancel", TRUE);
    break;
    //join game
    case 3:
      input_box.set(220, 270, 200);
      choices[0].set(270, 300, "Ok", TRUE);
      choices[1].set(370, 300, "Cancel", TRUE);
    break;
    //lobby
    case 4:
      show_shroud = TRUE;
      turn_type = TT_LONG;
      battlefield = 0;
    case 5:
      input_box.set(50, 420, 420);
      choices[0].set(480, 424, "Send");
      if(is_server)
        choices[1].set(50, 450, "Start game");
      if(id == 5)
      {
        choices[1].set(50, 450, "Resume game");
        id = menu_id = 4;
      }
      else
      {
        choices[3].set(500, 260, (turn_type == TT_SHORT) ? "Game Mode: Long" : "Game Mode: Short");
        choices[4].set(500, 275, (show_shroud) ? "Shroud: On" : "Shroud: Off");
        choices[5].set(500, 290, (!battlefield) ? "Battlefield: Plains" : "Battlefield: R.Pass");
      }
      choices[2].set(150, 450, "Disconnect");
    break;
  }
  while(mouse_b) title_output();
}

//title_input()
//reads input during title event loop
void title_input()
{
  int i;
  static char enter_down = FALSE;          //For enter key

  if(menu_alpha)
  {
    if(mouse_b & 1 && screen_alpha == 255)
    {
      for(i = 0; i < NUM_CHOICES; i++) if(choices[i].enabled && choices[i].mouse_over())
      {
        if(!menu_id)
        {
          switch(i)
          {
            case 0:
              screen_alpha = 254;
              to_stop = 2;
              game_type = GT_CPU;
            break;
            case 1:
              screen_alpha = 254;
              to_stop = 3;
              game_type = GT_2PLOCAL;
            break;
            case 2:
              if(!network_working)
                title_msg("Network was never initialized properly!");
              else set_menu(2);
            break;
            case 3: set_menu(1); break;
            case 4: stop = 1; break;
          }
        }
        else if(menu_id == 1)
        {
          char *diffs[3] = { "CPU Level: Easy", "CPU Level: Normal", "CPU Level: Hard" };

          switch(i)
          {
            case 0:
              if(turn_type == TT_LONG) turn_type = TT_SHORT;
              else turn_type = TT_LONG;
              choices[0].text = (turn_type == TT_SHORT) ? "Game Mode: Long" : "Game Mode: Short";
            break;
            case 1:
              c_diff++;
              if(c_diff >= 3) c_diff = 0;
              choices[1].text = diffs[c_diff];
            break;
            case 2:
              show_shroud = !show_shroud;
              choices[2].text = (show_shroud) ? "Shroud: On" : "Shroud: Off";
            break;
            case 3:
              full_screen = !full_screen;
              if(set_gfx_mode(full_screen ? GFX_AUTODETECT_FULLSCREEN : GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0)
                failure();
              choices[3].text = (full_screen) ? "Fullscreen: On" : "Fullscreen: Off";
            break;
            case 4: set_menu(0); break;
            case 5:
              battlefield = !battlefield;
              choices[5].text = (!battlefield) ? "Battlefield: Plains" : "Battlefield: Rocky Pass";
            break;
          }
          while(mouse_b) title_output();
        }
        else if(menu_id == 2)
        {
          if(i == 0)
          {
            set_menu(-1);
            textout_centre(screen, font, "Waiting for player..", 320, 240, 0xffff);

            if(!init_server())
            {
              title_msg("Error starting server!");
              set_menu(2);
              return;
            }

            while(!key[KEY_ESC])
            {
              if(server_listen())
              {
                online = is_server = TRUE;
                strcpy(local_name, "Player1");
                break;
              }
            }

            while(!key[KEY_ESC])
            {
              net_packet.rec_server();

              if(net_packet.read("reCO"))
              {
                char version = net_packet.get_byte();

                if(version != VERSION_INT)
                {
                  net_packet.set("WRONG");
                  net_packet.send_server();
                  shutdown_server();

                  title_msg("Client refused: Versions don't match!!!");
                  online = FALSE;
                  break;
                }
                else
                {
                  net_packet.set("CONN");
                  net_packet.send_server();
                  break;
                }
              }
            }

            if(!online || key[KEY_ESC])
            {
              set_menu(2);
              return;
            }

            set_menu(4);
          }
          else if(i == 1)
            set_menu(3);
          else if(i == 2)
            set_menu(0);
        }
        else if(menu_id == 3)
        {
          if(i == 0)
          {
            set_menu(-1);

            textout_centre(screen, font, "Trying to connect..", 320, 240, 0xffff);
            if(!init_client(input_box.text))
            {
              title_msg("Error starting client!");
              set_menu(2);
              return;
            }

            while(!key[KEY_ESC])
            {
              if(client_server_response())
              {
                online = TRUE;
                is_server = FALSE;
                strcpy(local_name, "Player2");
                break;
              }
            }

            net_packet.set("reCO");
            net_packet.add_byte(VERSION_INT);
            net_packet.send_client();

            while(!key[KEY_ESC])
            {
              net_packet.rec_client();

              if(net_packet.read("CONN"))
                break;
              if(net_packet.read("WRONG"))
              {
                shutdown_client();
                title_msg("Connection refused: Versions don't match!!!");
                online = FALSE;
                break;
              }
            }

            if(!online || key[KEY_ESC])
            {
              set_menu(2);
              return;
            }

            set_menu(4);
          }
          else if(i == 1)
            set_menu(2);
        }
        else if(menu_id == 4)
        {
          if(i == 0)
          {
            input_box.send_chat();
            while(mouse_b & 1)
            {
              title_processing();

              if(fpscounter >= fps)
                title_output();
              while(fpscounter > fps) ;
            }
          }
          else if(i == 1)
          {
            net_packet.set("STAR");
            net_packet.send_server();

            screen_alpha = 254;
            to_stop = 4;
            game_type = GT_2PINET;
          }
          else if(i == 2)
          {
            set_menu(0);
            while(mouse_b & 1)
            {
              title_processing();

              if(fpscounter >= fps)
                title_output();
              while(fpscounter > fps) ;
            }
          }
          else if(i == 4 && is_server)
          {
            show_shroud = !show_shroud;

            choices[4].text = (show_shroud) ? "Shroud: On" : "Shroud: Off";

            net_packet.set("SHRO");
            net_packet.add_byte(show_shroud);
            net_packet.send_server();
          }
          else if(i == 3 && is_server)
          {
            if(turn_type == TT_LONG) turn_type = TT_SHORT;
            else turn_type = TT_LONG;
            choices[3].text = (turn_type == TT_SHORT) ? "Game Mode: Long" : "Game Mode: Short";

            net_packet.set("MODE");
            net_packet.add_byte((char)turn_type);
            net_packet.send_server();
          }
          else if(i == 5 && is_server)
          {
            battlefield = !battlefield;
            choices[5].text = (!battlefield) ? "Battlefield: Plains" : "Battlefield: R.Pass";

            net_packet.set("BATT");
            net_packet.add_byte(battlefield);
            net_packet.send_server();
          }

          while(mouse_b) title_output();
        }
      }
    }
  }

  if(key[KEY_ESC])
  {
    if(menu_id)
      set_menu(0);
    else stop = 1;

    clear_keybuf();
  }
  if(key[KEY_ENTER])
  {
    if(!enter_down && menu_id == 4)
    {
      enter_down = TRUE;
      input_box.send_chat();
    }
  }
  else enter_down = FALSE;

  if(input_box.enabled && keypressed())
  {
    int k = readkey();
    input_box.type(k);
    clear_keybuf();
  }

  if(dy > -48 && (keypressed() || mouse_b))
  {
    dy = -48;
    w = 512;
    timer = 0;
  }
}

//title_processing()
//misc title processing
void title_processing()
{
  fpscounter++;

  if(yield_os)
    yield_timeslice();

  if(w > 512)
  {
    w -= 40;
    if(w <= 512)
    {
      w = 512;
      play(blast);
    }
  }
  if(w == 512 && timer <= 0 && dy > -48)
    dy--;
  if(dy == -48 && menu_alpha < 255)
  {
    menu_alpha += 5;
    if(menu_alpha > 255) menu_alpha = 255;
  }
  if(screen_alpha < 255)
  {
    screen_alpha -= 2;
    if(screen_alpha <= 0) stop = to_stop;
  }
  if(w == 512 && timer > 0)
    timer--;

  //connected to another player
  if(online)
  {
    if(is_server)
    {
      net_packet.rec_server();

      if(net_packet.read("reCH"))
      {
        char buf[PACKET_SIZE];
        int i = 0;

        while((buf[i]=net_packet.get_byte()))
          i++;

        console.print(buf);

        net_packet.build_chat_string("CHAT", buf);
        net_packet.send_server();
      }
      else if(net_packet.read("ENDG"))
      {
        shutdown_server();
        online = FALSE;

        title_msg("Other player left the game!");
      }
    }
    else
    {
      net_packet.rec_client();

      if(net_packet.read("CHAT"))
      {
        char buf[PACKET_SIZE];
        int i = 0;

        while((buf[i]=net_packet.get_byte()))
          i++;

        if(strstr(buf, "Player2"))
        {
          console.print(buf, makecol(75, 255, 255));
          waiting_response = FALSE;
          input_box.reset();
        }
        else
          console.print(buf);
      }
      else if(net_packet.read("SHRO"))
      {
        show_shroud = net_packet.get_byte();
        choices[4].text = (show_shroud) ? "Shroud: On" : "Shroud: Off";
      }
      else if(net_packet.read("MODE"))
      {
        turn_type = (TURNTYPE)net_packet.get_byte();
        choices[3].text = (turn_type == TT_SHORT) ? "Game Mode: Long" : "Game Mode: Short";
      }
      else if(net_packet.read("BATT"))
      {
        battlefield = net_packet.get_byte();
        choices[5].text = (!battlefield) ? "Battlefield: Plains" : "Battlefield: R.Pass";
      }
      else if(net_packet.read("STAR"))
      {
        screen_alpha = 254;
        to_stop = 4;
        game_type = GT_2PINET;
      }
      else if(net_packet.read("ENDG"))
      {
        shutdown_client();
        online = FALSE;

        title_msg("Other player left the game!");
      }
    }

/*
    if(check_fd_sets(net_player) == 1)
    {
      unsigned int flags = 0;
      char args[128] = "";

      if(!read_data(&flags, args))
      {
        title_msg("Other player disconnected..");
        return;
      }
      //do commands
      if(flags & NDF_CHAT)
        console.print(args);
      if(flags & NDF_STARTGAME)
      {
        screen_alpha = 254;
        to_stop = 4;
        game_type = GT_2PINET;
      }
      if(flags & NDF_OPTSET)
      {
        if(strstr(args, "show_shroud"))
        {
          int i;
          sscanf(args, "show_shroud %d", &i);
          show_shroud = i;
          choices[4].text = (show_shroud) ? "Shroud: On" : "Shroud: Off";
        }
        if(strstr(args, "turn_type"))
        {
          int i;
          sscanf(args, "turn_type %d", &i);
          turn_type = (TURNTYPE) i;
          choices[3].text = (turn_type == TT_SHORT) ? "Game Mode: Long" : "Game Mode: Short";
        }
      }
      //make sure other player gets in...
      if(flags & NDF_INGAME)
      {
        outgame_c++;
        if(outgame_c > 180)
        {
          title_msg("Other player is in game without you!");
          return;
        }
      }
    }
    if(fpscounter % 30 == 0)
      send_data();

    if(abs(fpscounter-fps) >= 60)
      fpscounter = fps = 0;*/
  }
}

//title_output()
//draw the title screen
void title_output()
{
  const float h = w*0.75;
  char sx = 0, sy = 0;
  int i;

  if(w == 512 && timer > 0)
  {
    sx = random()%5;
    sy = random()%5;
    if(random()%2) sx *= -1;
    if(random()%2) sy *= -1;
  }

  acquire_bitmap(buffer);
  clear(buffer);
  if(!dy)
    stretch_sprite(buffer, (BITMAP *)data[title_bmp].dat, (int)((320.0-w/2)+0.5), (int)((240.0-h/2)+0.5+dy), (int)(w+0.5), (int)(h+0.5));
  else draw_sprite(buffer, (BITMAP *)data[title_bmp].dat, 64, 48+(int)dy);

  if(menu_id)
  {
    fblend_rect_trans(buffer, 0, 0, 640, 480, 0, 128);

    if(menu_id == 1)
      textout_centre(buffer, font, "-Options-", 320, 50, 0xffff);
    else if(menu_id == 3)
      textout_centre(buffer, font, "Enter address", 320, 250, 0xffff);
    else if(menu_id == 4)
    {
      console.draw(50, 300);
      textout_centre(buffer, font, "-Game Settings-", 560, 234, 0xffff);
    }
  }

  char lit = FALSE;
  if(menu_alpha) for(i = 0; i < NUM_CHOICES; i++) if(choices[i].enabled)
  {
    if(choices[i].mouse_over())
    {
      lit = i+1;
      if(!option_lit)
      {
        play(click);
        option_lit = i+1;
      }

      if(choices[i].centered) textout_centre(buffer, font, choices[i].text, choices[i].x, choices[i].y, makecol(menu_alpha, menu_alpha, 0));
      else textout(buffer, font, choices[i].text, choices[i].x, choices[i].y, makecol(menu_alpha, menu_alpha, 0));
    }
    else
    {
      if(choices[i].centered) textout_centre(buffer, font, choices[i].text, choices[i].x, choices[i].y, makecol(menu_alpha, menu_alpha, menu_alpha));
      else textout(buffer, font, choices[i].text, choices[i].x, choices[i].y, makecol(menu_alpha, menu_alpha, menu_alpha));
    }
  }
  if(lit != option_lit)
    option_lit = FALSE;

  textprintf_right(buffer, font, 640, 0, makecol(menu_alpha/2, menu_alpha/2, menu_alpha/2), "Version %s", VERSION_STRING);

  if(input_box.enabled)
    input_box.draw();

  if(menu_alpha < 255)
    fblend_trans((BITMAP *)data[cursor].dat, buffer, mouse_x, mouse_y, menu_alpha);
  else
  {
    draw_sprite(buffer, (BITMAP *)data[cursor].dat, mouse_x, mouse_y);
    if(show_mcoords)
      textprintf(buffer, font, mouse_x, mouse_y, 0xffff, "(%d,%d)", mouse_x, mouse_y);
  }

  if(screen_alpha < 255)
    fblend_rect_trans(buffer, 0, 0, 640, 480, 0, 255-screen_alpha);

  release_bitmap(buffer);
  blit(buffer, screen, 0, 0, sx, sy, 640, 480);
}

//title()
//main title routine, executes title screen and quits
char title(int id)
{
  //debug crap, get rid of later
//  show_shroud = TRUE;
//  turn_type = TT_LONG;
//  return 2;
//  game_type = GT_2PLOCAL;
//  return 3;

  if(!id && loop_go == TRUE)
    rest(1000);
  outgame_c = 0;
  set_menu(id);

  stop = to_stop = FALSE;
  menu_alpha = 0;
  screen_alpha = 255;

  console.set_disappear_timer(-1);
  console.show();

  if(id)
  {
    dy = -48;
    w = 512;
    timer = 0;
  }

  while(!stop)
  {
    title_input();
    title_processing();

    if(fpscounter >= fps)
      title_output();
    while(fpscounter > fps) ;
  }

  fps = fpscounter = 0;
  return stop;
}

//menu_choice::set()
//add a menu_choice (like a button) to the menu
void menu_choice::set(int x, int y, const char *text, char cent)
{
  this->x = x;
  this->y = y;
  this->text = text;
  centered = cent;

  w = text_length(font, text);
  h = 12;

  enabled = TRUE;
}

//menu_choice::mouse_over()
//is mouse hovered over the choice
char menu_choice::mouse_over()
{
  int x = this->x;

  if(centered) x -= w/2;
  return (mouse_x > x && mouse_x < x+w && mouse_y > y && mouse_y < y+h);
}

//menu_input::set()
//add a menu_input to the menu
void menu_input::set(int x, int y, int w)
{
  this->x = x;
  this->y = y;
  this->w = w;
  h = text_height(font)+4;
  pos = 0;
  strcpy(text, "");

  enabled = TRUE;
}

//menu_input::type()
//add letter k to the input_box's text
void menu_input::type(int k)
{
//  cerr << "**Key pressed for chat, it is '" << (char)(k & 0xff) << '\'' << endl;
  if(isprint(k & 0xFF) && (pos < 255))
  {
    if(2+text_length(font, text)+16 > w)
      return;
    text[pos] = k;
    pos++;
    text[pos] = '\0';
  }
  else if(k >> 8 == KEY_BACKSPACE && pos >= 1)
  {
    pos--;
    text[pos] = '\0';
  }
}

//menu_input::draw()
//draw a menu_input
void menu_input::draw()
{
  hline(buffer, x, y, x+w, makecol(100, 100, 100));
  vline(buffer, x, y, y+h, makecol(100, 100, 100));
  hline(buffer, x, y+h, x+w, makecol(200, 200, 200));
  vline(buffer, x+w, y, y+h, makecol(200, 200, 200));
  hline(buffer, x+2+text_length(font, text), y+h-2, x+2+text_length(font, text)+8, 0xffff);
  textout(buffer, font, text, x+2, y+2, 0xffff);
}

//menu_input::reset()
//reset input box to empty
void menu_input::reset()
{
  pos = 0;
  text[0] = 0;
}

//menu_input::send_chat()
//send box's text over the net as chat text
void menu_input::send_chat()
{
  if(!is_server && waiting_response)
    return;

  char buf[256];

  sprintf(buf, "%s: %s", local_name, text);

  if(is_server)
  {
    net_packet.build_chat_string("CHAT", buf);
    net_packet.send_server();

    console.print(buf, makecol(75, 255, 255));
    reset();
  }
  else
  {
    net_packet.build_chat_string("reCH", buf);
    net_packet.send_client();
    waiting_response = TRUE;
  }
}
