/*

*************************************************************************

net.cpp - Iron Army basic network routines
Copyright (C) 2002 Mike Farrell (gccdragoonkain@yahoo.com)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************************/

//Includes///////////////////////////////////////////////////////////////////
#include <allegro.h>
#include <stdio.h>
#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include <libnet.h>
#include "net.h"
#include "server.h"
#include "client.h"
#include "loop.h"
#include "main.h"

extern ofstream inlog, outlog;

//Globals////////////////////////////////////////////////////////////////////
const short net_port = 7845;
char online = FALSE, is_server = FALSE, waiting_response = FALSE;
int net_driver = -1;
PACKET net_packet;
ofstream inlog("inlog.txt");
ofstream outlog("outlog.txt");

//PACKET::set()
//create a new packet
void PACKET::set(char *id)
{
  strncpy(buffer, id, 4);
  size = 4;
  buffer[4] = 0;
}

//PACKET::add_byte
//add a new byte to packet
void PACKET::add_byte(char b)
{
  buffer[size] = b;
  size++;

  if(size >= PACKET_SIZE)
    failure("Packet overflow!!!");
}

//PACKET::read()
//see if packet is readable
int PACKET::read(char *id)
{
  if(size >= 4 && !strncmp(buffer, id, 4))
  {
    inlog << buffer << endl;

    pos = 4;
    return 1;
  }
  return 0;
}

//PACKET::build_chat_string()
//build a chat string packet
void PACKET::build_chat_string(char *id, char *str)
{
  int i;

  set(id);
  for(i = 0; str[i]; i++)
    add_byte(str[i]);

  //trail the strings with NULL
  add_byte(0);
}

//PACKET::get_byte()
//read one byte off the packet
char PACKET::get_byte()
{
  char b = buffer[pos];

  pos++;
  return b;
}

//PACKET::send_server()
//send packet from server to client
void PACKET::send_server()
{
  server_send(buffer, size);

  outlog << buffer << endl;
}

//PACKET::send_client()
//send packet from client to server
void PACKET::send_client()
{
  client_send(buffer, size);

  outlog << buffer << endl;
}

//PACKET::rec_server()
//receive data from client
void PACKET::rec_server()
{
  size = server_receive(buffer);

  if(size == -1)
    game_msg("Lost connection to client!");
}

//PACKET::rec_client()
//receive data from server
void PACKET::rec_client()
{
  size = client_receive(buffer);

  if(size == -1)
    game_msg("Lost connection to server!");
}


//net_init()
//initialize networking (if needed)
char network_init()
{
  NET_DRIVERLIST drivers;
  NET_DRIVERNAME *drivernames;

  net_init();

  net_loadconfig(NULL);

  drivers = net_detectdrivers(net_classes[NET_CLASS_INET].drivers);
  drivernames = net_getdrivernames(drivers);

  net_driver = drivernames[0].num;

  free(drivernames);

  if(net_driver >= 0)
  {
    if(net_initdriver(net_driver))
      return TRUE;
    else
      return FALSE;
  }
  else
    return FALSE;
}

//net_shutdown()
//shutdown networking (if needed)
void network_shutdown()
{
  if(inlog)
    inlog.close();
  if(outlog)
    outlog.close();

  net_shutdown();
}

