/*

*************************************************************************

console.cpp - Iron Army chat console object routines
Copyright (C) 2002 Mike Farrell (gccdragoonkain@yahoo.com)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************************/

//Includes///////////////////////////////////////////////////////////////////
#include <allegro.h>
#include "main.h"
#include "console.h"

//Globals////////////////////////////////////////////////////////////////////
CONSOLE console;

//CONSOLE constructor
CONSOLE::CONSOLE()
{
  timer = -1;
  visible = TRUE;
}

//CONSOLE::print()
//print a line to the console
void CONSOLE::print(char *line, int c)
{
  if(lpos == NUM_CONSOLE_LINES-1)
    scroll();

  strcpy(lines[lpos], line);
  colors[lpos] = c;

  lpos++;
}

//CONSOLE::clear()
//clear all lines of the console
void CONSOLE::clear()
{
  char i;

  lpos = 0;

  for(i = 0; i < NUM_CONSOLE_LINES; i++)
    lines[i][0] = 0;
}

//CONSOLE::scroll()
//scroll up one line (buggy)
void CONSOLE::scroll()
{
  char i;

  for(i = 0; i < NUM_CONSOLE_LINES-1; i++)
  {
    strcpy(lines[i], lines[i+1]);
    colors[i] = colors[i+1];
  }
  lpos = NUM_CONSOLE_LINES-2;
}

//CONSOLE::set_dissapear_timer
//Set time remaining before console hides itself
void CONSOLE::set_disappear_timer(int timer)
{
  this->timer = timer;
}

//CONSOLE::processing()
//handle processing for console
void CONSOLE::processing()
{
  if(timer != -1)
  {
    timer--;

    if(timer <= -1)
    {
      hide();
      timer = -1;
    }
  }
}

//CONSOLE::draw()
//draw the console to the buffer
void CONSOLE::draw(int x, int y, char shadow)
{
  int i;
  const int h = text_height(font);

  for(i = 0; i < NUM_CONSOLE_LINES; i++)
  {
    if(shadow)
      textout(buffer, font, lines[i], x+1, (y+h*i)+1, 0);
    textout(buffer, font, lines[i], x, y+h*i, colors[i]);
  }
}

//CONSOLE::show()
//show a console
void CONSOLE::show()
{
  visible = TRUE;
}

//CONSOLE::show()
//hide a console
void CONSOLE::hide()
{
  visible = FALSE;
}

