/*

*************************************************************************

ai.cpp - Iron Army AI opponent routines.
Copyright (C) 2002 Mike Farrell (gccdragoonkain@yahoo.com)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************************/

//Includes///////////////////////////////////////////////////////////////////
#include <allegro.h>
#include <iostream.h>
#include <string.h>
#include <math.h>
#include "irondat.h"
#include "main.h"
#include "loop.h"
#include "unit.h"
#include "ai.h"

//Globals////////////////////////////////////////////////////////////////////
AI_STRATEGY ai_strategy;
char ai_map_data[20][20], used_one_unit = FALSE, unitfind_failed = FALSE,
     times_failed = 0, use_others = FALSE, map_looking = FALSE;
//ai_favor is a float between 0 (cpu) and 1 (player), that serves to how
//the battle is going (who is going to win).
float ai_favor = 0.5;
int loops;

//row_coords()
//lazy routine to get row coordinates
//for unit placement (as if view was from bottom)
short row_coords(short y)
{
  return 1-y;
}

//wait_on_hitnumber()
//wait for the damage number to disappear so it doesn't
//get skipped
inline void wait_on_hitnumber()
{
  char keep_going = TRUE;
  int i;

  while(keep_going)
  {
    keep_going = FALSE;
    for(i = 0; i < 10; i++) if(dmg[i].num != -1)
      keep_going = TRUE;

    processing();
    if(fpscounter >= fps)
      draw_screen();
    while(fpscounter > fps) ;
  }
}

//ai_place_window()
//like an init routine for ai's game plan
void ai_place_units()
{
  const UNIT *red_leader;

  //Set up virtual ai "shroud"
  if(show_shroud)
  {
    short x, y;

    for(y = 5; y < map_h; y++) for(x = 0; x < map_w; x++)
      ai_map_data[x][y] = (show_shroud && game_type != GT_2PLOCAL) ? 1 : 0;
  }

  //Randomly pick a strategy and a leader
  ai_strategy = (AI_STRATEGY)(random()%NUM_AI_STRATEGIES);
  red_leader = (random()%2) ? &red_hero : &red_sorc;

//  ai_strategy = AI_OFFENSE1;
//  red_leader = &red_sorc;

  //set up pieces according to strategy/game-plan type
  switch(ai_strategy)
  {
    case AI_DEFENSE1:
      add_unit(0, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(1, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(2, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(3, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(4, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(5, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(6, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(7, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(8, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(9, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(10, row_coords(0), (UNIT *)&red_mage, 1);
      add_unit(11, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(12, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(13, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(14, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(15, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(16, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(17, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(18, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(19, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(0, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(1, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(2, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(3, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(4, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(5, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(6, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(7, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(8, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(9, row_coords(1), (UNIT *)red_leader, 1);
      add_unit(10, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(11, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(12, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(13, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(14, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(15, row_coords(1), (UNIT *)&red_jester, 1);
      add_unit(16, row_coords(1), (UNIT *)&red_jester, 1);
      add_unit(17, row_coords(1), (UNIT *)&red_trapper, 1);
      add_unit(18, row_coords(1), (UNIT *)&red_trapper, 1);
      add_unit(19, row_coords(1), (UNIT *)&red_trapper, 1);
    break;
    case AI_DEFENSE2:
      add_unit(0, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(1, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(2, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(3, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(4, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(5, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(6, row_coords(0), (UNIT *)&red_mage, 1);
      add_unit(7, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(8, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(9, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(10, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(11, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(12, row_coords(0), (UNIT *)&red_mage, 1);
      add_unit(13, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(14, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(15, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(16, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(17, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(18, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(19, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(0, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(1, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(2, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(3, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(4, row_coords(1), (UNIT *)&red_trapper, 1);
      add_unit(5, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(6, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(7, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(8, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(9, row_coords(1), (UNIT *)red_leader, 1);
      add_unit(10, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(11, row_coords(1), (UNIT *)&red_jester, 1);
      add_unit(12, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(13, row_coords(1), (UNIT *)&red_trapper, 1);
      add_unit(14, row_coords(1), (UNIT *)&red_trapper, 1);
      add_unit(15, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(16, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(17, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(18, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(19, row_coords(1), (UNIT *)&red_knight, 1);
    break;
    case AI_OFFENSE1:
      add_unit(0, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(1, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(2, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(3, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(4, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(5, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(6, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(7, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(8, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(9, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(10, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(11, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(12, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(13, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(14, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(15, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(16, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(17, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(18, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(19, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(0, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(1, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(2, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(3, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(4, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(5, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(6, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(7, row_coords(1), (UNIT *)&red_trapper, 1);
      add_unit(8, row_coords(1), (UNIT *)&red_jester, 1);
      add_unit(9, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(10, row_coords(1), (UNIT *)&red_trapper, 1);
      add_unit(11, row_coords(1), (UNIT *)&red_trapper, 1);
      add_unit(12, row_coords(1), (UNIT *)red_leader, 1);
      add_unit(13, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(14, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(15, row_coords(1), (UNIT *)&red_jester, 1);
      add_unit(16, row_coords(1), (UNIT *)&red_jester, 1);
      add_unit(17, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(18, row_coords(1), (UNIT *)&red_jester, 1);
      add_unit(19, row_coords(1), (UNIT *)&red_jester, 1);
    break;
    case AI_OFFENSE2:
      add_unit(0, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(1, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(2, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(3, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(4, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(5, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(6, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(7, row_coords(0), (UNIT *)&red_trapper, 1);
      add_unit(8, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(9, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(10, row_coords(0), (UNIT *)&red_mage, 1);
      add_unit(11, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(12, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(13, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(14, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(15, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(16, row_coords(0), (UNIT *)&red_archer, 1);
      add_unit(17, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(18, row_coords(0), (UNIT *)&red_jester, 1);
      add_unit(19, row_coords(0), (UNIT *)&red_knight, 1);
      add_unit(0, row_coords(1), (UNIT *)red_leader, 1);
      add_unit(1, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(2, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(3, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(4, row_coords(1), (UNIT *)&red_trapper, 1);
      add_unit(5, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(6, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(7, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(8, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(9, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(10, row_coords(1), (UNIT *)&red_trapper, 1);
      add_unit(11, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(12, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(13, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(14, row_coords(1), (UNIT *)&red_mage, 1);
      add_unit(15, row_coords(1), (UNIT *)&red_jester, 1);
      add_unit(16, row_coords(1), (UNIT *)&red_jester, 1);
      add_unit(17, row_coords(1), (UNIT *)&red_archer, 1);
      add_unit(18, row_coords(1), (UNIT *)&red_knight, 1);
      add_unit(19, row_coords(1), (UNIT *)&red_knight, 1);
    break;

    default:
      cerr << "AI Warning: strategy not defined yet..\n";
  }

  cout << "*AI: Using strategy #" << (int)ai_strategy << endl;

//  int i;
//  for(i = 0; i < MAX_UNITS; i++) if(units[i].side && !units[i].is_leader)
//    units[i].alive = FALSE;
}

//ai_take_turn()
//ai takes a turn based off of strategy plan..
//NOTES: Make 5.0 a variable, random attacks on same risks,
//       Make a stupitidiy level to reduce some elite processing
void ai_take_turn()
{
  int i, j, lrisk_id = -1, lrisk_attacker = -1, lfight_id, lfight_attacker;
  char highest_risk = -1, highest_fight_risk = -1;

  used_one_unit = unitfind_failed = use_others = FALSE;
  loops = times_failed = 0;
  for(i = 0; i < MAX_UNITS; i++) if(units[i].alive && units[i].side == 1)
    units[i].flag = FALSE;

  while(1)
  {
    lrisk_id = -1;
    lfight_id = -1;
    highest_risk = -1;
    highest_fight_risk = -1;

    //check for good attack chances
    for(i = 0; i < MAX_UNITS; i++) if(units[i].alive && units[i].side == 1 && !units[i].frozen && !(units[i].turnflags & TF_MOVED))
    {
      for(j = 0; j < MAX_UNITS; j++) if(units[j].alive && units[j].side == 0)
      {
        //Is this person under shroud?
        if(show_shroud && ai_map_data[units[j].x][units[j].y])
          continue;

        //Archers should not be shooting knights, heros, or juggernauts
        if(units[i].unit_type == &red_archer)
        {
          if(units[j].unit_type == &blue_knight || units[j].unit_type == &blue_hero || units[j].unit_type == &blue_jug)
            continue;
        }

        if(!units[i].long_range)
        {
          if((ABS(units[i].x-units[j].x) == 1 && ABS(units[i].y-units[j].y) == 0) || (ABS(units[i].y-units[j].y) == 1 && ABS(units[i].x-units[j].x) == 0))
          {
            if(units[j].risk > highest_fight_risk && units[i].atp-units[j].dfp > 0 && !(units[i].turnflags & TF_ATTACKED))
            {
              highest_fight_risk = units[j].risk;
              lfight_id = j;
              lfight_attacker = i;
            }
          }
        }
        else
        {
          int x, y;
          float dist = pow(units[j].x-units[i].x, 2) + pow(units[j].y-units[i].y, 2);

          if(dist < 10.0*10.0) for(y = units[i].y-10; y <= units[i].y+10; y++) for(x = units[i].x-10; x <= units[i].x+10; x++) if(units[i].attack_range[x-units[i].x+10][y-units[i].y+10])
          {
            if(units[j].risk > highest_fight_risk && !ai_map_data[x][y] && units[j].x == x && units[j].y == y && !(units[i].turnflags & TF_ATTACKED))
            {
              highest_fight_risk = units[j].risk;
              lfight_id = j;
              lfight_attacker = i;
            }
          }
        }

        //determine who gets to.....mmmmdie
        float dist = pow(units[j].x-units[i].x, 2) + pow(units[j].y-units[i].y, 2);
        if(dist < 5.0*5.0)
        {
          if(units[j].risk > highest_risk && (units[i].maxmp != -1 || units[i].atp-units[j].dfp > 0))
          {
            highest_risk = units[j].risk;
            lrisk_attacker = i;
            lrisk_id = j;
          }
        }
      }
    }

    if(lfight_id != -1 && !(units[lfight_attacker].turnflags & TF_ATTACKED))
    {
      if(units[lfight_attacker].long_range)
        map_look(&units[lfight_id]);
      else map_look(&units[lfight_attacker]);
      if(units[lfight_attacker].long_range)
      {
        int x, y;

        for(y = units[lfight_attacker].y-1; y <= units[lfight_attacker].y+1; y++) for(x = units[lfight_attacker].x-1; x <= units[lfight_attacker].x+1; x++)
        {
          if(x >= 0 && x < map_w && y >= 0 && y < map_h && map_data[x][y] & 1)
            map_data[x][y] ^= 1;
        }
      }

      units[lfight_attacker].fight(lfight_id);
      if(!used_one_unit)
        used_one_unit = TRUE;


      if(turn_type == TT_SHORT)
      {
        wait_on_hitnumber();
        break;
      }
    }
    if(lrisk_id != -1)// && (lfight_id == -1 || lfight_id != lrisk_id))
    {
      ai_move_unit(&units[lrisk_attacker], &units[lrisk_id]);
      if(turn_type == TT_SHORT && used_one_unit)
      {
        wait_on_hitnumber();
        break;
      }
    }

    if(!ai_move_unit() && turn_type == TT_LONG)
    {
      times_failed++;
      if(used_one_unit)
      {
        if(times_failed >= 100)
          break;
      }
      else
      {
        if(times_failed >= 50)
          use_others = TRUE;
      }
    }

    if(used_one_unit && turn_type == TT_SHORT)
      unitfind_failed = FALSE;

    //don't let the game freeze due to algor. error
    loops++;
    if(loops > 1000)
      failure("AI.cpp: endless loop error!\nReport this to me ( gccdragoonkain@yahoo.com ) as a bug report");


    if(used_one_unit && turn_type == TT_SHORT)
    {
      wait_on_hitnumber();
      break;
    }
  }

  //for slower processors
  if(abs(fps-fpscounter) > 30)
    fps = fpscounter = 0;

  flip_map();
}

//get_movedata()
//acquire a 5x5 matrix of places a
//unit can and cannot move (buggy code)
char get_movedata(UNIT *u, char data[5][5])
{
  char diagonals[4] = { 0, 0, 0, 0 }, sides[4] = { 0, 0, 0, 0 },
       one_spot = FALSE;
  int i, x, y;

  memset(data, 0, 25);

  for(i = 0; i < MAX_UNITS; i++) if(&units[i] != u && units[i].alive)
  {
    if(units[i].x == u->x && units[i].y == u->y-1)
      sides[0] = TRUE;
    if(units[i].x == u->x+1 && units[i].y == u->y)
      sides[1] = TRUE;
    if(units[i].x == u->x && units[i].y == u->y+1)
      sides[2] = TRUE;
    if(units[i].x == u->x-1 && units[i].y == u->y)
      sides[3] = TRUE;
  }

  if(sides[0] && sides[3])
    diagonals[0] = TRUE;
  if(sides[0] && sides[1])
    diagonals[1] = TRUE;
  if(sides[1] && sides[2])
    diagonals[2] = TRUE;
  if(sides[2] && sides[3])
    diagonals[3] = TRUE;

  int _x = -1, _y = 0;

  for(y = u->y-2; y <= u->y+2; y++) for(x = u->x-2; x <= u->x+2; x++)
  {
    char found = FALSE;

    _x++;
    if(_x > 4)
    {
      _x = 0;
      _y++;
    }
    if(x < 0 || y < 0 || x >= map_w || y >= map_h)
      continue;

    for(i = 0; i < MAX_UNITS; i++) if(&units[i] != u && units[i].alive)
    {
      if(units[i].x == x && units[i].y == y)
        { found = TRUE; break; }
    }

    if(!found && u->move_range[_x][_y])
    {
      if(x == u->x && y < u->y && sides[0])
        continue;
      if(y == u->y && x > u->x && sides[1])
        continue;
      if(x == u->x && y > u->y && sides[2])
        continue;
      if(y == u->y && x < u->x && sides[3])
        continue;
      if(x < u->x && y < u->y && diagonals[0])
        continue;
      if(x > u->x && y < u->y && diagonals[1])
        continue;
      if(x > u->x && y > u->y && diagonals[2])
        continue;
      if(x < u->x && y > u->y && diagonals[3])
        continue;
      if(map_data[x][y] & 8)
        continue;

      data[_x][_y] = 1;
      if(!one_spot)
        one_spot = TRUE;
    }
  }

  return one_spot;
}

//map_look()
//scroll map to a unit
void map_look(UNIT *u)
{
  if(map_data[u->x][u->y] & 1 || map_looking)
    return;

  map_looking = TRUE;

  while(1)
  {
    //debug key to escape never ending loop
    if(debug && key[KEY_ESC]) exit(1);

    processing();

    if(my < u->y*32-240) my += 10;
    if(my > u->y*32-240) my -= 10;
    if(my < 0)
    {
      my = 0;
      break;
    }
    if(my > map_h*32-480)
    {
      my = map_h*32-480;
      break;
    }
    if(my > (u->y*32-240)-11 && my < (u->y*32-240)+11)
    {
      my = u->y*32-240;
      break;
    }

    if(fpscounter >= fps)
      draw_screen();
    while(fpscounter > fps) ;
  }

  map_looking = FALSE;
}

//ai_move_unit()
//search for a unit to move and do it
char ai_move_unit(UNIT *attacker, UNIT *target)
{
  UNIT *u;
  char data[5][5], passed_end = FALSE;
  int i, to_move = -1, move_dx = 0, move_dy = 0, start;

  //pick an attack strategy for moving
  if(attacker)
  {
    char longrange = FALSE, diag = FALSE, box = FALSE;

    u = attacker;
    if(!get_movedata(u, data)) 
      return FALSE;

    if(data[3][3]) diag = TRUE;
    if(data[4][2]) longrange = TRUE;
    if(data[4][4]) box = TRUE;

    if(u->x < target->x) move_dx = (longrange && ABS(u->x-target->x) >= 2) ? 2 : 1;
    else if(u->x > target->x) move_dx = (longrange && ABS(u->x-target->x) >= 2) ? -2 : -1;

    if(!move_dx || diag)
    {
      if(move_dx)
      {
        if(u->y < target->y) move_dy = box ? 2 : 1;
        else if(u->y > target->y) move_dy = box ? -2 : -1;
      }
      else
      {
        if(u->y < target->y) move_dy = (longrange && ABS(u->y-target->y) >= 2) ? 2 : 1;
        else if(u->y > target->y) move_dy = (longrange && ABS(u->y-target->y) >= 2) ? -2 : -1;
      }
    }
  }


  start = random()%MAX_UNITS;

  //setup move preferences
  if(!attacker) for(i = start; (i < start || !passed_end); i++)
  {
    if(i == MAX_UNITS)
    {
      passed_end = TRUE;
      i = 0;
    }
    if(!units[i].alive || units[i].frozen || units[i].side == 0 || units[i].turnflags & TF_MOVED)
      continue;

    char special_case_done = FALSE;

    //special cases in all modes
    if((c_diff == 1 && ai_favor > 0.75) || (c_diff == 2 && ai_favor > 0.4))
    {
      to_move = find_leader();
      if(to_move != -1 && !(units[to_move].flag & 1) && units[to_move].y != 0)
      {
        special_case_done = TRUE;
        move_dy = -1;
      }
      else to_move = -1;
    }

    if(!special_case_done) switch(ai_strategy)
    {
      case AI_DEFENSE1:
      case AI_DEFENSE2:
        if(units[i].unit_type == &red_jester && ((!(units[i].flag & 1) && loops < 2) || turn_type == TT_LONG))
        {
          to_move = i;
//          if(units[i].flag & 1 && random()%5)
//            move_dy = -2;
//          else move_dy = 2;
          move_dy = 2;
          move_dx = random()%3;
          if(move_dx && random()%2)
            move_dx *= -1;
          break;
        }
        //didn't get the preffered units
        else if(unitfind_failed || use_others)
        {
          if(units[i].unit_type == &red_archer || units[i].unit_type == &red_mage)
          {
            to_move = i;
            move_dy = 1;
/*            move_dx = random()%2;
            if(move_dx && random()%2)
              move_dx *= -1;*/
          }
          else if(units[i].unit_type == &red_trapper)
          {
            to_move = i;
            move_dy = 2;
            move_dx = random()%2;
            if(move_dx && random()%2)
              move_dx *= -1;
          }
          else if(random()%5 && units[i].unit_type == &red_knight)
          {
            to_move = i;
            move_dy = 1;
            if(units[i].flag & 1)
              move_dy = -1;
          }
          else if(random()%30 && units[i].is_leader)
          {
            to_move = i;
            if(random()%2)
              move_dy = 1;
            else
              move_dx = (random()%2) ? -1 : 1;
          }
        }
      break;

      case AI_OFFENSE1:
      case AI_OFFENSE2:
        move_dx = move_dy = 0;

        if(units[i].unit_type == &red_knight)
        {
          to_move = i;
          if(random()%6)
            move_dx = (random()%2) ? 2 : -2;
          else move_dy = 2;

/*          if(units[i].flag & 1)
          {
            move_dx = 0;
            move_dy = -1;
          }*/
        }
        else if(units[i].unit_type == &red_archer || units[i].unit_type == &red_mage)
        {
          to_move = i;
          move_dy = 1;
        }
        else if(units[i].unit_type == &red_trapper)
        {
          to_move = i;
          move_dy = 2;
          move_dx = random()%2;
          if(move_dx && random()%2)
            move_dx *= -1;
        }
        else if(units[i].unit_type == &red_jester)
        {
          to_move = i;
          move_dy = 2;
          move_dx = random()%3;
          if(move_dx && random()%2)
            move_dx *= -1;
        }
        else if(random()%30 && units[i].is_leader)
        {
          to_move = i;
          if(random()%2)
            move_dy = 1;
          else
            move_dx = (random()%2) ? -1 : 1;
        }

      break;

      default:
      ;
    }
  }
  if(to_move == -1 && !attacker)
  {
    unitfind_failed = TRUE;
    return FALSE;
  }

  //this should never be true
  if(!move_dx && !move_dy)
  {
    cerr << "AI screwed up:  Decision to move nowhere...\n";
    return FALSE;
  }

  //do the move
  if(!attacker)
    u = &units[to_move];

  u->flag |= 1;
  if(!get_movedata(u, data) || u->turnflags & TF_MOVED) 
    return FALSE;

  //pick the spot closest to the preference
  int dest_x, dest_y;

  if(move_dy && !move_dx)
  {
    dest_x = u->x;
    if(data[2][2+move_dy])
    {
      dest_y = u->y+move_dy;
    }
    else if(data[1][2+move_dy])
    {
      dest_x = u->x-1;
      dest_y = u->y+move_dy;
    }
    else if(data[3][2+move_dy])
    {
      dest_x = u->x+1;
      dest_y = u->y+move_dy;
    }
    else if(ABS(move_dy) > 1 && data[2][2+move_dy])
    {
      dest_y = u->y+(move_dy+(move_dy*-1));
    }
    else if(ABS(move_dy) > 1 && data[1][2+move_dy])
    {
      dest_x = u->x-1;
      dest_y = u->y+(move_dy+(move_dy*-1));
    }
    else if(ABS(move_dy) > 1 && data[3][2+move_dy])
    {
      dest_x = u->x+1;
      dest_y = u->y+(move_dy+(move_dy*-1));
    }
    else return FALSE;

    if(!used_one_unit)
      used_one_unit = TRUE;

    map_look(u);
    u->move(dest_x, dest_y);
  }
  else if(move_dx && !move_dy)
  {
    dest_y = u->y;
    if(data[2+move_dx][2])
      dest_x = u->x+move_dx;
    else if(data[2+move_dx][1])
    {
      dest_y = u->y-1;
      dest_x = u->x+move_dx;
    }
    else if(data[2+move_dx][3])
    {
      dest_y = u->y+1;
      dest_x = u->x+move_dx;
    }
    else if(ABS(move_dx) > 1 && data[2+move_dx][2])
    {
      dest_x = u->x+(move_dx+(move_dx*-1));
    }
    else if(ABS(move_dx) > 1 && data[2+move_dx][1])
    {
      dest_y = u->y-1;
      dest_x = u->x+(move_dx+(move_dx*-1));
    }
    else if(ABS(move_dx) > 1 && data[2+move_dx][3])
    {
      dest_y = u->y+1;
      dest_x = u->x+(move_dx+(move_dx*-1));
    }
    else return FALSE;

    if(!used_one_unit)
      used_one_unit = TRUE;

    map_look(u);
    u->move(dest_x, dest_y);
  }
  //x and y dy
  else
  {
    if(data[2+move_dx][2+move_dy])
    {
      dest_x = u->x+move_dx;
      dest_y = u->y+move_dy;
    }
    //make more elseif's later
    else return FALSE;

    if(!used_one_unit)
      used_one_unit = TRUE;

    map_look(u);
    u->move(dest_x, dest_y);
  }

  if(attacker && !(u->turnflags & TF_ATTACKED))
  {
    if((ABS(u->x-target->x) == 1 && ABS(u->y-target->y) == 0) || (ABS(u->y-target->y) == 1 && ABS(u->x-target->x) == 0))
      u->fight(target);
    else for(i = 0; i < MAX_UNITS; i++) if(units[i].alive && units[i].side == 0)
    {
      target = &units[i];
      if((ABS(u->x-target->x) == 1 && ABS(u->y-target->y) == 0) || (ABS(u->y-target->y) == 1 && ABS(u->x-target->x) == 0))
        u->fight(target);
    }
  }

  return TRUE;
}

//find_leader()
//lazy helper routine to find the id of the ai leader
int find_leader()
{
  int i, ret = -1;
  for(i = 0; i < MAX_UNITS; i++) if(units[i].alive && units[i].side == 1 && !units[i].frozen && units[i].is_leader)
  {
    ret = i;
    break;
  }
  return ret;
}
