/*

*************************************************************************

menu.cpp - Iron Army in-game menu routines
Copyright (C) 2002 Mike Farrell (gccdragoonkain@yahoo.com)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************************/

//Includes///////////////////////////////////////////////////////////////////
#include <iostream.h>
#include <stdio.h>
#include <allegro.h>
#include <fblend.h>
#include "main.h"
#include "loop.h"
#include "menu.h"
#include "irondat.h"
#include "unit.h"

//Globals////////////////////////////////////////////////////////////////////
U_MENU menu;
char leader_placed = FALSE, in_menu = FALSE;

//remove_unit()
//remove the unit at the mouse_cursor
inline void remove_unit()
{
  int i, j;

  for(i = 0; i < MAX_UNITS; i++) if(units[i].alive)
  {
    if((mouse_x+8)/32 == units[i].x && (mouse_y+8+my)/32 == units[i].y)
    {
      units[i].alive = FALSE;

      for(j = 0; j < 15; j++) if(menu.options[j].enabled)
      {
        if(menu.options[j].data && (void *)menu.options[j].data == units[i].unit_type)
          break;
      }
      if(j < 15)
      {
        if(!units[i].is_leader)
          menu.options[j].left++;
        else leader_placed = FALSE;
      }
    }
  }
}

//window()
//draw a GUI window
void window(int x, int y, int w, int h, int col)
{
  int i;

  w = (w+8)/16;
  h = (h+8)/16;
  w--;
  if(h > 1) h--;

  draw_sprite(buffer, (BITMAP *)data[menu_ul].dat, x, y);
  draw_sprite(buffer, (BITMAP *)data[menu_ur].dat, x+w*16, y);
  draw_sprite(buffer, (BITMAP *)data[menu_dl].dat, x, y+h*16);
  draw_sprite(buffer, (BITMAP *)data[menu_dr].dat, x+w*16, y+h*16);
  for(i = 1; i < w; i++)
    draw_sprite(buffer, (BITMAP *)data[menu_up].dat, x+i*16, y);
  for(i = 1; i < w; i++)
    draw_sprite(buffer, (BITMAP *)data[menu_down].dat, x+i*16, y+h*16);
  for(i = 1; i < h; i++)
    draw_sprite(buffer, (BITMAP *)data[menu_left].dat, x, y+i*16);
  for(i = 1; i < h; i++)
    draw_sprite(buffer, (BITMAP *)data[menu_right].dat, x+w*16, y+i*16);

  fblend_rect_trans(buffer, x+4, y+4, (w+1)*16-8, (h+1)*16-8, col, 64);
}

//open_menu()
//open and run a preset menu window
int open_menu(char *title, int x, int y, int w, int h, int menu_id)
{
  char menu_quit = 0;
  int i;

  menu.title = title;
  menu.x = x;
  menu.y = y;
  menu.w = w;
  menu.h = h;
  leader_placed = FALSE;
  for(i = 0; i < 5; i++)
    menu.choices[i].enabled = FALSE;
  for(i = 0; i < 6; i++)
    menu.labels[i].enabled = FALSE;
  for(i = 0; i < 15; i++)
    menu.options[i].enabled = FALSE;

  in_menu = menu_id+1;


  //preset menus
  switch(menu_id)
  {
    //mage magic menu
    case 0:
      if(units[selected].mp >= 3)
        menu.choices[0].set(sm_fire, "FireBlast (3 MP)");
      if(units[selected].mp >= 4)
        menu.choices[1].set(sm_ice, "Freeze (4 MP)");
      if(units[selected].mp < 3)
      {
        menu.labels[0].set("Not enough MP", 31, 38);
      }
    break;
    //sorcerer magic menu
    case 1:
      if(units[selected].mp >= 6)
        menu.choices[0].set(sm_lit, "Lightning (6 MP)");
      if(units[selected].mp >= 4)
        menu.choices[1].set(sm_quake, "Quake (4 MP)");
      if(units[selected].mp < 4)
        menu.labels[0].set("Not enough MP", 31, 38);
    break;
    //white mage magic menu
    case 4:
      if(units[selected].mp >= 2)
        menu.choices[0].set(sm_hprestore, "HP Restore (2 MP)");
      if(units[selected].mp >= 5)
        menu.choices[1].set(sm_mprestore, "MP Restore (5 MP)");
      if(units[selected].mp < 2)
      {
        menu.labels[0].set("Not enough MP", 31, 38);
      }
    break;
    //pick units menu
    case 2:
      menu.options[5].set(s_plus, "", 335, 8, 1, TRUE);
      menu.options[6].set(s_minus, "", 335, 38, 1, FALSE);
      menu.labels[0].set("Pick a Leader", 200, 60);
      menu.choices[0].set(s_check, "", 335, 210);

      switch(current_side)
      {
        case BLUE:
          menu.options[0].set(b_archer, "", 10, 30, 0, FALSE, 10);
          menu.options[0].data = (int)&blue_archer;
          menu.options[1].set(b_mage, "", 10, 70, 0, FALSE, 5);
          menu.options[1].data = (int)&blue_mage;
          menu.options[2].set(b_soldier, "", 10, 110, 0, FALSE, 15);
          menu.options[2].data = (int)&blue_knight;
          menu.options[3].set(b_jester, "", 10, 150, 0, FALSE, 6);
          menu.options[3].data = (int)&blue_jester;
          menu.options[4].set(b_trapper, "", 10, 190, 0, FALSE, 3);
          menu.options[4].data = (int)&blue_trapper;
          menu.options[9].set(b_jug, "", 100, 30, 0, FALSE, 4);
          menu.options[9].data = (int)&blue_jug;
          menu.options[10].set(b_wmage, "", 100, 70, 0, FALSE, 3);
          menu.options[10].data = (int)&blue_wmage;
          menu.options[7].set(b_hero, "- Hero", 230, 90, 0, FALSE);
          menu.options[7].data = (int)&blue_hero;
          menu.options[8].set(b_sorc, "- Sorcerer", 230, 130, 0, FALSE);
          menu.options[8].data = (int)&blue_sorc;
        break;
        case RED:
          menu.options[0].set(r_archer, "", 10, 30, 0, FALSE, 10);
          menu.options[0].data = (int)&red_archer;
          menu.options[1].set(r_mage, "", 10, 70, 0, FALSE, 5);
          menu.options[1].data = (int)&red_mage;
          menu.options[2].set(r_soldier, "", 10, 110, 0, FALSE, 15);
          menu.options[2].data = (int)&red_knight;
          menu.options[3].set(r_jester, "", 10, 150, 0, FALSE, 6);
          menu.options[3].data = (int)&red_jester;
          menu.options[4].set(r_trapper, "", 10, 190, 0, FALSE, 3);
          menu.options[4].data = (int)&red_trapper;
          menu.options[9].set(r_jug, "", 100, 30, 0, FALSE, 4);
          menu.options[9].data = (int)&red_jug;
          menu.options[10].set(r_wmage, "", 100, 70, 0, FALSE, 3);
          menu.options[10].data = (int)&red_wmage;
          menu.options[7].set(r_hero, "- Hero", 230, 90, 0, FALSE);
          menu.options[7].data = (int)&red_hero;
          menu.options[8].set(r_sorc, "- Sorcerer", 230, 130, 0, FALSE);
          menu.options[8].data = (int)&red_sorc;
        break;
      }
    break;
    //Unit info menu
    case 3:
      menu.choices[0].set(s_check, "", menu.w-25, menu.h-25);
      menu.labels[0].set("Hp - ", 8, 30);
      menu.labels[1].set("Mp - ", 8, 42);
      menu.labels[2].set("Dfp - ", 8, 54);
      menu.labels[5].set("Mg. Dfp - ", 8, 66);
      menu.labels[3].set("Atp - ", 8, 78);
      menu.labels[4].set("Abl. - None", 8, 90);
      sprintf(menu.labels[0].text, "Hp - %d/%d", units[selected].hp, units[selected].maxhp);
      if(units[selected].maxmp != -1)
        sprintf(menu.labels[1].text, "Mp - %d/%d", units[selected].mp, units[selected].maxmp);
      else strcpy(menu.labels[1].text, "Mp - --");
      sprintf(menu.labels[2].text, "Dfp - %d", units[selected].dfp);
      sprintf(menu.labels[5].text, "Mg. Dfp - %d", units[selected].m_dfp);
      sprintf(menu.labels[3].text, "Atp - %d", units[selected].atp);

      if(strcmp(units[selected].name, "Trapper") == 0)
        strcpy(menu.labels[4].text, "Abl. - Capture leader");
      else if(strcmp(units[selected].name, "Mage") == 0)
        strcpy(menu.labels[4].text, "Abl. - Magic");
      else if(strcmp(units[selected].name, "Sorcerer") == 0)
        strcpy(menu.labels[4].text, "Abl. - Strong magic");
      else if(strcmp(units[selected].name, "Archer") == 0)
        strcpy(menu.labels[4].text, "Abl. - Bow");
      else if(strcmp(units[selected].name, "Jester") == 0)
        strcpy(menu.labels[4].text, "Abl. - Fast runner");
      else if(strcmp(units[selected].name, "Juggernaut") == 0)
        strcpy(menu.labels[4].text, "Abl. - Strong attack");
      else if(strcmp(units[selected].name, "White Mage") == 0)
        strcpy(menu.labels[4].text, "Abl. - Recovery magic");
    break;
  }

  while(!menu_quit)
  {
    if(key[KEY_ESC] && menu_id == 2)
    {
      menu_quit = TRUE;
      loop_go = 1;
    }
    if(mouse_b & 1)
    {
      for(i = 0; i < 5; i++) if(menu.choices[i].enabled)
      {
        if(menu.choices[i].x == -1)
        {
          if(mouse_x > x+12 && mouse_x < x+36 && mouse_y > y+22+i*30 && mouse_y < y+46+i*30)
          {
            menu_quit = i+1;
            break;
          }
        }
        else
        {
          if(mouse_x > menu.x+menu.choices[i].x && mouse_x < menu.x+menu.choices[i].x+menu.choices[i].icon->w && mouse_y > menu.y+menu.choices[i].y && mouse_y < menu.y+menu.choices[i].y+menu.choices[i].icon->h)
          {
            //make sure all units are placed and at least one is the leader
            if(i == 0 && menu_id == 2)
            {
              char num = 0, leader_set = FALSE;

              for(i = 0; i < MAX_UNITS; i++) if(units[i].alive && units[i].side == current_side)
              {
                num++;
                
                if(units[i].is_leader)
                  leader_set = TRUE;
              }


              if(!debug && (num < 40 || !leader_set))
              {
                if(num < 40 && !leader_set)
                  game_msg("You must fill the button two rows and place a leader!");
                else if(num < 40)
                  game_msg("You must fill the button two rows!");
                else
                  game_msg("You did not place a leader piece!");

                continue;
              }
            }


            menu_quit = i+1;
            break;
          }
        }
      }
      for(i = 0; i < 15; i++) if(menu.options[i].enabled)
        menu.options[i].test_click(menu.x, menu.y);

      if(menu_id == 2)
      {
        UNIT *type = NULL;

        if(curs_bmp == (BITMAP *)data[cursor].dat && mouse_y > 416)
        {
          for(i = 0; i < 15; i++) if(menu.options[i].group == 0 && menu.options[i].enabled && menu.options[i].flag)
          {
            type = (UNIT *)menu.options[i].data;
            break;
          }
          if(i < 15)
          {
            if(menu.options[i].left > 0)
            {
              if(add_unit(mouse_x/32, (mouse_y+my)/32, type, current_side))
                menu.options[i].left--;
            }
            else if(type->is_leader && !leader_placed)
            {
              if(add_unit(mouse_x/32, (mouse_y+my)/32, type, current_side))
                leader_placed = TRUE;
            }
          }
        }
        else if(curs_bmp == (BITMAP *)data[cursor_x].dat)
          remove_unit();
      }
    }
    if(mouse_b & 2)
    {
      if(menu_id == 2) remove_unit();
      else menu_quit = -1;
    }

    processing();

    if(menu_id == 2)
    {
      //mouse cursor hovering
      if(mouse_y > 416)
      {
        if(menu.options[6].flag)
          curs_bmp = (BITMAP *)data[cursor_x].dat;
        else
          curs_bmp = (BITMAP *)data[cursor].dat;

      }
      else
        curs_bmp = (BITMAP *)data[cursor_no].dat;

      if(mouse_x > menu.x && mouse_x < menu.x+menu.w && mouse_y > menu.y && mouse_y < menu.y+menu.h)
        curs_bmp = (BITMAP *)data[cursor].dat;
    }

    if(fpscounter >= fps)
    {
      acquire_bitmap(buffer);
      draw_screen(TRUE);
      if(menu_id == 2)
      {
        //help window for unit placement
        window(x-155, y+80, 145, 100, makecol(0, 0, 255));
        textout(buffer, font, " Select a unit", x-155+10, y+95, 0xffff);
        textout(buffer, font, "type with the", x-155+10, y+105, 0xffff);
        textout(buffer, font, "mouse and place", x-155+10, y+115, 0xffff);
        textout(buffer, font, "units below in", x-155+10, y+125, 0xffff);
        textout(buffer, font, "the bottom two", x-155+10, y+135, 0xffff);
        textout(buffer, font, "rows....", x-155+10, y+145, 0xffff);
        hline(buffer, 0, 480-64, 640, makecol(255, 255, 0));        
      }

      menu.draw();
      //abit wasteful drawing it twice but I'm tired..
      draw_sprite(buffer, curs_bmp, mouse_x, mouse_y);
      release_bitmap(buffer);
      blit(buffer, screen, 0, 0, 0, 0, 640, 480);
    }
    while(fpscounter > fps) ;
  }

  curs_bmp = (BITMAP *)data[cursor].dat;

  in_menu = FALSE;

  return menu_quit-1;
}

//U_MENU::draw()
//draw a U_MENU
void U_MENU::draw()
{
  int i;

  window(x, y, w, h, makecol(0, 0, 255));
  textout_centre(buffer, font, title, x+w/2, y+10, 0xffff);
  for(i = 0; i < 5; i++) if(choices[i].enabled)
  {
    if(choices[i].x == -1)
    {
      draw_sprite(buffer, choices[i].icon, x+12, y+22+i*30);
      textout(buffer, font, choices[i].label, x+40, y+30+i*30, 0xffff);
    }
    else
    {
      draw_sprite(buffer, choices[i].icon, x+choices[i].x, y+choices[i].y);
      textout(buffer, font, choices[i].label, x+choices[i].x+28, y+choices[i].y+8, 0xffff);
    }
  }
  for(i = 0; i < 6; i++) if(labels[i].enabled)
    textout(buffer, font, labels[i].text, x+labels[i].x, y+labels[i].y, 0xffff);
  for(i = 0; i < 15; i++) if(options[i].enabled)
  {
    if(options[i].icon)
    {
      if(!options[i].flag)
      {
        set_trans_blender(0, 0, 0, 0);
        draw_lit_sprite(buffer, options[i].icon, x+options[i].x, y+options[i].y, 64);
      }
      else
        draw_sprite(buffer, options[i].icon, x+options[i].x, y+options[i].y);

      if(options[i].left != -1)
        textprintf(buffer, font, x+options[i].x+options[i].icon->w+6, y+options[i].y+options[i].icon->h/2-4, 0xffff, "x %d", options[i].left);
      else
        textout(buffer, font, options[i].label, x+options[i].x+options[i].icon->w+6, y+options[i].y+options[i].icon->h/2-4, 0xffff);
    }
    else
      textout(buffer, font, options[i].label, x+options[i].x, y+options[i].y, 0xffff);
  }
}

//U_MENU_CHOICE::set()
//add a choice to the menu window
void U_MENU_CHOICE::set(int icon, char *label, short x, short y)
{
  this->icon = (BITMAP *)data[icon].dat;
  this->label = label;
  this->x = x;
  this->y = y;
  enabled = TRUE;
}

//U_MENU_LABEL::set()
//add a label to the menu window
void U_MENU_LABEL::set(char *text, short x, short y)
{
  strcpy(this->text, text);
  this->x = x;
  this->y = y;
  enabled = TRUE;
}

//U_MENU_OPTION::set()
//add an option to the menu window
void U_MENU_OPTION::set(int icon, char *label, short x, short y, char group, char flag, char left)
{
  if(icon != -1)
    this->icon = (BITMAP *)::data[icon].dat;
  else this->icon = NULL;

  this->label = label;
  this->flag = flag;
  this->left = left;
  this->group = group;
  this->x = x;
  this->y = y;
  data = 0;
  enabled = TRUE;
}

//U_MENU_OPTION::test_click()
//test mouse to be within option and toggle it if so
void U_MENU_OPTION::test_click(short mx, short my)
{
  int i;
  short wt, ht;

  if(icon)
  {
    wt = icon->w;
    ht = icon->h;
  }

  if(mouse_x > x+mx && mouse_x < x+wt+mx && mouse_y > my+y && mouse_y < my+y+ht)
  {
    //clicking a unit automatically switches out of unit delete mode
    if(in_menu == 3 && group == 0)
    {
      menu.options[6].flag = FALSE;
      menu.options[5].flag = TRUE;
    }

    //toggle the option
    flag = TRUE;
    for(i = 0; i < 15; i++) if(&menu.options[i] != this && group == menu.options[i].group)
      menu.options[i].flag = FALSE;
  }
}


