//Prototypes/////////////////////////////////////////////////////////////////
void init();
void shutdown();
void failure(char *msg=NULL);
void load_config_data();
void save_config_data();

//Enums//////////////////////////////////////////////////////////////////////
enum TURNTYPE { TT_LONG, TT_SHORT };
enum GAMETYPE { GT_CPU, GT_2PLOCAL, GT_2PINET };


//Externs////////////////////////////////////////////////////////////////////
extern BITMAP *buffer;
extern DATAFILE *data;
extern volatile int fps;
extern int fpscounter;
extern char show_shroud, current_side, debug, map_w, map_h, c_diff, local_name[8],
            full_screen, network_working;
extern TURNTYPE turn_type;
extern GAMETYPE game_type;

//Defines////////////////////////////////////////////////////////////////////
//Portability
#ifndef random
  #define srandom(x)  srand(x)
  #define random()    rand()
#endif

#ifndef M_PI
  #define M_PI		3.14159265358979323846
#endif

//Library version checks
#ifdef INCLUDE_FBLEND_H_GUARD
  #if (FBLEND_MINOR_VERSION != 4 || FBLEND_VERSION != 0)
    #warning Compiling using untested version of Fblend
  #endif
#endif

#if (ALLEGRO_VERSION != 4)
  #error Allegro version 4.x required!
#endif

//Sides
#define BLUE    0
#define RED     1

//Turnflags
#define TF_MOVED       1
#define TF_ATTACKED    2

//Lazy stuff
#define play(x)    play_sample((SAMPLE *)data[x].dat, 255, 128, 1000, FALSE)

//Version
#define VERSION_STRING   "0.7b"
#define VERSION_INT      70



