/*

*************************************************************************

main.cpp - Iron Army main program structure routines.
Copyright (C) 2002 Mike Farrell (gccdragoonkain@yahoo.com)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************************/

//TODO
//*Try to get AI working with new units (using)
/////////////////////////////////////////////////////////////////

//Includes///////////////////////////////////////////////////////////////////
#include <allegro.h>
#include <time.h>
#include <iostream.h>
#include "main.h"
#include "loop.h"
#include "title.h"
#include "lightmap.h"
#include "irondat.h"
#include "net.h"

//Globals////////////////////////////////////////////////////////////////////
DATAFILE *data;
BITMAP *buffer;
volatile int fps;
int fpscounter;

//Global data and flag (options and other stuff)/////////////////////////////
char show_shroud = TRUE, current_side = BLUE, debug = FALSE, map_w = 20, map_h = 20,
     mute = FALSE, c_diff = 1, full_screen = TRUE, local_name[8] = "Player1",
     use_esd = FALSE, yield_os = FALSE, network_working;
TURNTYPE turn_type = TT_LONG;
GAMETYPE game_type = GT_CPU;

//failure()
//show fatal error message and exit
void failure(char *msg)
{
//  #ifdef ALLEGRO_DOS
    set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
//  #endif
  allegro_message("Fatal Error:  %s\n", msg ? msg : allegro_error);
  allegro_exit();
  exit(1);
}

//fps_proc()
//fps timer callback function
void fps_proc()
{
  fps++;
}
END_OF_FUNCTION(fps_proc);

//main()
//multiplatform main entrypoint routine
int main(int argc, char *argv[])
{
  char ret, i;

  for(i = 1; i < argc; i++)
  {
    if(strcmp(argv[i], "-mute") == 0)
      mute = TRUE;
    else if(strcmp(argv[i], "-debug") == 0)
      debug = TRUE;
    else if(strcmp(argv[i], "-showmousecoords") == 0)
      show_mcoords = TRUE;
    else if(strcmp(argv[i], "-esd") == 0)
      use_esd = TRUE;
    else if(strcmp(argv[i], "-win") == 0)
      full_screen = -2;
    else
    {
      cerr << "Bad command line arg: " << argv[i] << endl;
      return 1;
    }
  }

  init();
  while(1)
  {
    if(keypressed())
      clear_keybuf();

    ret = title(online ? 4 : 0);
    if(ret != 1)
    {
      if(!loop())
        break;
    }
    else break;
  }

  shutdown();

  return 0;
}
END_OF_MAIN();

//init()
//initialize game engine
void init()
{
  //Allegro init
  allegro_init();
  
  //parse config
  load_config_data();

  if(exists("debug.code"))
    debug = TRUE;

  set_window_title("Iron Army");
  set_color_depth(16);
  if(set_gfx_mode(full_screen ? GFX_AUTODETECT_FULLSCREEN : GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0)
    failure();
  install_timer();
  if(install_mouse() == -1)
    failure("Mouse not found.");
  install_keyboard();
  if(!mute)
  {
    #ifdef linux
      if(install_sound((use_esd) ? DIGI_ESD : DIGI_AUTODETECT, MIDI_NONE, NULL) != 0)
//      if(install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) != 0)
        failure();
    #else
      if(install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) != 0)
        failure();
    #endif
    set_volume(255, 128);
  }

  //load data
  text_mode(-1);
  textout_centre(screen, font, "Loading...", 320, 240, 0xffff);
  data = load_datafile("iron.dat");
  if(!data) failure("Error reading iron.dat");

  //memory allocation
  buffer = create_bitmap(640, 480);
  if(!buffer) failure("Out of memory!");
//  redfire = create_lightmap((BITMAP *)data[red_fire].dat);
//  if(!redfire) failure("Out of memory!");

  //misc
  LOCK_VARIABLE(fps);
  LOCK_FUNCTION(fps_proc);
  install_int_ex(fps_proc, BPS_TO_TIMER(60));
  srandom(time(NULL));

  short i;
  for(i = 255; i > 1; i -= 25)
  {
    fpscounter++;
    textout_centre(screen, font, "Loading...", 320, 240, makecol(i, i ,i));
    while(fpscounter > fps) ;
  }
  fps = fpscounter = 0;

  font = (FONT *)data[mainfont].dat;

  online = FALSE;

  network_working = network_init();
  if(!network_working)
    cerr << "Network Warning: Unable to start network!!!\n";
}

//shutdown()
//shutdown game engine
void shutdown()
{
  network_shutdown();

  destroy_bitmap(buffer);
  unload_datafile(data);
  remove_int(fps_proc);
  
  //save config
  save_config_data();

  allegro_exit();
}

//load_config_data()
//load options from the config file
void load_config_data()
{
  set_config_file("user_options.cfg");

  turn_type = (TURNTYPE)get_config_int("OPTIONS", "MODE", (int)TT_LONG);
  c_diff = get_config_int("OPTIONS", "CPULVL", 1);
  show_shroud = get_config_int("OPTIONS", "SHROUD", TRUE);
  battlefield = get_config_int("OPTIONS", "BATTLEFIELD", 0);
  
  //linux has problems switching back to fullscreen
  #ifndef ALLEGRO_LINUX
    if(full_screen != -2)
      full_screen = get_config_int("OPTIONS", "FULLSCREEN", TRUE);
    else
      full_screen = FALSE;
  #else
    if(full_screen == -2)
      full_screen = FALSE;
  #endif
}

//save_config_data()
//save options to the config file
void save_config_data()
{
  set_config_int("OPTIONS", "MODE", (int)turn_type);
  set_config_int("OPTIONS", "CPULVL", (int)c_diff);
  set_config_int("OPTIONS", "SHROUD", (int)show_shroud);
  set_config_int("OPTIONS", "BATTLEFIELD", (int)battlefield);
  set_config_int("OPTIONS", "FULLSCREEN", (int)full_screen);
}

