/*

*************************************************************************

main.cpp - Iron Army main game loop routines
Copyright (C) 2002 Mike Farrell (gccdragoonkain@yahoo.com)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************************/

//Includes///////////////////////////////////////////////////////////////////
#include <allegro.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <stdio.h>
#include <fblend.h>
#include <libnet.h>
#include <ctype.h>
#include "net.h"
#include "server.h"
#include "client.h"
#include "main.h"
#include "loop.h"
#include "irondat.h"
#include "menu.h"
#include "unit.h"
#include "effects.h"
#include "ai.h"
#include "title.h"
#include "console.h"

//Globals////////////////////////////////////////////////////////////////////
BITMAP *curs_bmp, *battlefield_bmp;
DAMAGE_NUM dmg[10];
menu_input game_input_box;
char loop_go = TRUE, mouse_down = FALSE, moving = -1, attacking = -1,
     no_selection = FALSE, moved_one = FALSE, fading_in = FALSE,
     leader_died = -1, gonna_chat = FALSE, dummy_state = FALSE,
     *show_msg = NULL, local_side = BLUE, unit_set[2], received_other = FALSE,
     last_unit = -1, battlefield = 0;
char map_data[20][20];
short my = 0, menu_a, selected, draw_other_stats = -1,
      screen_a = 255, vbutton_x, temp_my = -1,
      s_dx, s_dy, quake_x, quake_y, quake_id = -1;
float ldied_ang = 0.0, ldied_scale = 0.0;


//single_loop
//execute one loop of game logic
void single_loop()
{
  input();
  processing();
  if(fpscounter >= fps)
    draw_screen();
  while(fpscounter > fps) ;
}

//num()
//return a BITMAP of the number passed
BITMAP *num(char number)
{
  if(number == -5)
    return (BITMAP *)data[dplus5].dat;

  return (BITMAP *)data[d0+(int)number].dat;
}

//set_dmg()
//add a damage indicator at (x,y)
void set_dmg(int x, int y, int num)
{
  int i;

  for(i = 0; i < 10; i++) if(dmg[i].num == -1)
    break;

  if(i < 10)
    dmg[i].set(x, y, num);
}

//wait_for_numbers()
//loop until dmg numbers fade out before returning
void wait_for_numbers()
{
  char keep_going = TRUE, i;

  while(keep_going)
  {
    keep_going = FALSE;
    for(i = 0; i < 10; i++) if(dmg[i].num != -1)
      keep_going = TRUE;

    processing();
    if(fpscounter >= fps)
      draw_screen();
    while(fpscounter > fps) ;
  }
}

//flip_map()
//changes turns in all game modes
void flip_map(char no_send)
{
  short x, y, j = map_h-1, z;

  if(game_type == GT_2PLOCAL)
  {
    e_fade_out(15);
    if(temp_my != -1)
    {
      short misc = my;
      my = temp_my;
      temp_my = misc;
    }
    else temp_my = my;
  }
  else if(online)
  {
    if(current_side == local_side)
    {
      if(!no_send)
      {
        if(is_server)
        {
          net_packet.set("ENDT");
          net_packet.add_byte(local_side);
          net_packet.send_server();
        }
        else
        {
          net_packet.set("reEN");
          net_packet.add_byte(local_side);
          net_packet.send_client();
          waiting_response = TRUE;

          //wait for ok from server
          while(loop_go == TRUE && waiting_response)
            single_loop();
        }
      }
    }
    else if(last_unit != -1)
      map_look(&units[last_unit]);
  }

  wait_for_numbers();

  for(z = 0; z < 10; z++)
    dmg[z].num = -1;
  draw_other_stats = selected = moving = attacking = -1;
  moved_one = FALSE;
  clear_map_highlights();

  for(z = 0; z < MAX_UNITS; z++) if(units[z].alive)
  {
    units[z].flag = units[z].turnflags = FALSE;
    if(units[z].side == current_side && units[z].maxmp != -1 && units[z].mp < units[z].maxmp)
      units[z].mp++;
    if(units[z].side != current_side && units[z].frozen)
      units[z].frozen--;
  }

  current_side = !current_side;

  if(game_type == GT_CPU && current_side == 1)
    ai_take_turn();

  if(game_type != GT_2PLOCAL)
    return;

  //physically flip map data for 2-player local games.
  char map_data_temp[20][20];

  if(battlefield == 1)
  {
    BITMAP *temp = create_bitmap(640, 640);

    if(!temp)
      failure();

    draw_sprite_h_flip(temp, battlefield_bmp, 0, 0);
    blit(temp, battlefield_bmp, 0, 0, 0, 0, 640, 640);
    draw_sprite_v_flip(temp, battlefield_bmp, 0, 0);
    blit(temp, battlefield_bmp, 0, 0, 0, 0, 640, 640);

    destroy_bitmap(temp);
  }

  for(y = 0; y < map_h; y++) for(x = 0; x < map_w; x++)
  {
    for(z = 0; z < MAX_UNITS; z++) if(units[z].alive && !units[z].flag && units[z].x == x && units[z].y == j)
    {
      units[z].y = y;
      units[z].x = (map_w-1)-units[z].x;
      units[z].flag = TRUE;
    }

    map_data_temp[x][y] = map_data[(map_w-1)-x][(map_h-1)-y];

    if(x >= map_h-1)
    {
      j--;
    }
  }

  memcpy(map_data, map_data_temp, 400);

  e_fade_in(15);
}

//clear_map_highlights()
//removes any red attacking or blue moving possible squares
//(to prevent cheating and bugs)
void clear_map_highlights()
{
  int x, y;

  for(y = 0; y < map_h; y++) for(x = 0; x < map_w; x++)
  {
    if(map_data[x][y] & 2)
      map_data[x][y] &= ~2;
    if(map_data[x][y] & 4)
      map_data[x][y] &= ~4;
  }
}

//loop()
//execute the main game loop and return status
char loop()
{
  int x, y;

  //variable initialization
  fps = fpscounter = 0;
  dummy_state = received_other = FALSE;
  current_side = BLUE;
  my = map_h*32-480;
  temp_my = -1;
  ldied_ang = 0.0, ldied_scale = 0.0;
  console.hide();
  console.clear();

  screen_a = 0;
  fading_in = TRUE;

  s_dx = s_dy = 0;
  quake_id = -1;

  //allocate and setup battlefield bitmap
  battlefield_bmp = create_bitmap(640, 640);
  if(!battlefield_bmp)
    failure();
  blit((BITMAP *)data[field0+battlefield].dat, battlefield_bmp, 0, 0, 0, 0, 640, 640);

  //flip game data if player is client (red) in online game
  if(battlefield == 1 && game_type == GT_2PINET && !is_server)
  {
    char map_data_temp[20][20];
    BITMAP *temp = create_bitmap(640, 640);

    if(!temp)
      failure();

    draw_sprite_h_flip(temp, battlefield_bmp, 0, 0);
    blit(temp, battlefield_bmp, 0, 0, 0, 0, 640, 640);
    draw_sprite_v_flip(temp, battlefield_bmp, 0, 0);
    blit(temp, battlefield_bmp, 0, 0, 0, 0, 640, 640);
    destroy_bitmap(temp);

    memcpy(map_data, map_data_temp, 400);
  }

  //set shroud if necessary
  for(y = 0; y < map_h-5; y++) for(x = 0; x < map_w; x++)
    map_data[x][y] = (show_shroud && game_type != GT_2PLOCAL) ? 1 : 0;
  for(y = map_h-5; y < map_h; y++) for(x = 0; x < map_w; x++)
    map_data[x][y] = 0;

  //remove shroud from any from non-passable tiles
  //and set the map data for them.
  if(battlefield == 1)
  {
    int byte = 0;

    for(x = 0; x < map_w; x++) for(y = 0; y < map_h; y++)
    {
      char c = *(((char *)data[field1_data].dat)+byte);
      byte++;

      if(c)
      {
        if(game_type == GT_2PINET && !is_server)
        {
          map_data[(map_w-1)-x][(map_h-1)-y] &= ~1;
          map_data[(map_w-1)-x][(map_h-1)-y] |= 8;
        }
        else
        {
          map_data[x][y] &= ~1;
          map_data[x][y] |= 8;
        }
      }
    }
  }

  for(x = 0; x < MAX_UNITS; x++)
    units[x].alive = FALSE;

  selected = moving = attacking = -1;
  draw_other_stats = leader_died = -1;
  curs_bmp = (BITMAP *)data[cursor].dat;

  //unit placement menus
  if(game_type == GT_CPU)
  {
    open_menu("Blue Unit Placement", 170, 70, 370, 240, 2);
    local_side = BLUE;
  }

  if(game_type == GT_2PINET)
  {
    unit_set[0] = unit_set[1] = FALSE;

    if(is_server)
    {
      local_side = BLUE;
      open_menu("Blue Unit Placement", 170, 70, 370, 240, 2);
      unit_set[0] = TRUE;
      if(unit_set[1])
        show_msg = "Sending unit positions..";

      //just in case someone quits before they are done setting units
      if(online)
      {
        net_packet.set("DUNT");
        net_packet.add_byte(local_side);
        net_packet.send_server();
      }
    }
    else
    {
      online = FALSE;
      flip_map(TRUE);
      online = TRUE;

      local_side = RED;
      open_menu("Red Unit Placement", 170, 70, 370, 240, 2);
      unit_set[0] = TRUE;
      if(unit_set[1])
        show_msg = "Sending unit positions..";

      //just in case someone quits before they are done setting units
      if(online)
      {
        net_packet.set("reDU");
        net_packet.add_byte(local_side);
        net_packet.send_client();
        waiting_response = TRUE;
      }

      while(waiting_response)
        net_processing();
    }
    dummy_state = TRUE;
    if(!unit_set[1])
      show_msg = "Waiting for other player to set up";
  }

  if(game_type == GT_2PLOCAL)
  {
    open_menu("Blue Unit Placement", 170, 70, 370, 240, 2);
    flip_map();
    while(mouse_b & 1) draw_screen();
    fps = fpscounter = 0;
    open_menu("Red Unit Placement", 170, 70, 370, 240, 2);
    flip_map();
  }
  else if(game_type == GT_CPU)
    ai_place_units();

  loop_go = TRUE;
  while(loop_go == TRUE)
  {
    input();
    processing();
    if(fpscounter >= fps)
      draw_screen();
    while(fpscounter > fps) ;
  }

  //deallocate battlefield bitmap and return status
  destroy_bitmap(battlefield_bmp);
  return loop_go;
}

//input()
//gather and process keyboard and mouse input
void input()
{
  int i, x, y;

  if(key[KEY_ESC])
  {
    //quickfix to bug introduced from allegro 4.0 port
    while(key[KEY_ESC]) ;

    if(game_input_box.enabled)
      game_input_box.enabled = FALSE;

    else
    {
      loop_go = 1;
      if(online)
      {
        net_packet.set("ENDG");

        if(is_server)
        {
          net_packet.send_server();
          shutdown_server();
        }
        else
        {
          net_packet.send_client();
          shutdown_client();
        }

        online = FALSE;
      }
    }
  }

  if(dummy_state || waiting_response)
    return;
  if(leader_died != -1 && (keypressed() || mouse_b))
  {
    e_fade_out(5);
    loop_go = 1;
  }

  if(!online || !game_input_box.enabled)
  {
    if(key[KEY_UP])
    {
      my -= 4;
      if(my < 0) my = 0;
    }
    if(key[KEY_DOWN])
    {
      my += 4;
      if(my > map_h*32-480) my = map_h*32-480;
    }

    if(key[KEY_F] && (moved_one) && (game_type != GT_2PINET || current_side == local_side))
    {
      selected = -1;
      flip_map();
      clear_keybuf();
    }

    //some debug keys
    if(debug)
    {
      if(key[KEY_X])
      {
        ai_favor += 0.1;
        cout << "Debug ai favor:  " << ai_favor << endl;
        clear_keybuf();
      }
      if(key[KEY_Z])
      {
        ai_favor -= 0.1;
        cout << "Debug ai favor:  " << ai_favor << endl;
        clear_keybuf();
      }
    }
  }

  if(keypressed())
  {
    int k = readkey();

    if(k >> 8 == KEY_TAB && ((game_type != GT_2PINET && current_side == units[i].side) || (game_type == GT_2PINET && units[i].side == local_side && current_side == local_side)))
    {
      int i, j;

      attacking = moving = -1;
      clear_map_highlights();
      for(j = (selected != -1) ? selected+1 : 0; j < MAX_UNITS*2; j++)
      {
        i = j % MAX_UNITS;

        if(units[i].alive && current_side == units[i].side && !units[i].frozen && !(units[i].turnflags & TF_MOVED))
        {
          selected = i;
          menu_a = 0;
          break;
        }
      }
      clear_keybuf();
    }
    else if(k >> 8 == KEY_T && online && !game_input_box.enabled)
    {
      game_input_box.set(100, 460, 440);
      clear_keybuf();
    }
    else if(game_input_box.enabled)
    {
      if(k >> 8 == KEY_ENTER)
      {
        game_input_box.send_chat();
        game_input_box.enabled = FALSE;
        clear_keybuf();
        console.show();
        console.set_disappear_timer(600);
      }

      game_input_box.type(k);
      clear_keybuf();
    }
  }

  if(mouse_b & 1 && !moving_one_unit)
  {
    if(!mouse_down)
    {
      char found = FALSE, diagonals[4] = { 0, 0, 0, 0 }, sides[4] = { 0, 0, 0, 0 };

      //little v button on info windows
      if(selected != -1 && mouse_x > vbutton_x && mouse_x < vbutton_x+12 && mouse_y > 10 && mouse_y < 22)
      {
        open_menu(units[selected].name, 5, 5, 200, 120, 3);
        mouse_down = TRUE;
        return;
      }

      //end turn button
      if(turn_type == TT_LONG && moved_one && selected != -1 && mouse_x > 5+units[selected].st_wt+5 && mouse_x < 5+units[selected].st_wt+29 && mouse_y > 10 && mouse_y < 34)
      {
        selected = -1;
        flip_map();
      }

      //moving to a square
      if(moving != -1)
      {
        int id = moving, vx = mouse_x/32, vy = (mouse_y+my)/32;
        char no = FALSE;

        if(!(map_data[vx][vy] & 2))
          no = TRUE;
        /*for(y = 0; y < 30; y++) for(x = 0; x < 20; x++) if(!(map_data[x][y] & 2))
          if(vx == x && vy == y) { no = TRUE; break; }*/

        if(!no)
        {
          const char view = 1;

          units[id].move(vx, vy);

          //remove surrounding shroud
          for(y = units[id].y-view; y <= units[id].y+view; y++) for(x = units[id].x-view; x <= units[id].x+view; x++)
          {
            if(x >= map_w || y >= map_h)
              continue;
            if(map_data[x][y] & 1)
              map_data[x][y] &= ~1;
          }
          moving = -1;
          for(y = 0; y < map_h; y++) for(x = 0; x < map_w; x++) if(map_data[x][y] & 2)
            map_data[x][y] &= ~2;
          selected = id;
          last_unit = selected;
          menu_a = 0;
          return;
        }
      }

      //attacking a unit
      if(attacking != -1)
      {
        int vx = mouse_x/32, vy = (mouse_y+my)/32,
            enemy = -1;
        char no = TRUE, usex = FALSE;

        for(i = 0; i < MAX_UNITS; i++) if(units[i].alive && i != attacking)
        {
          if(vx == units[i].x && vy == units[i].y)
            { no = FALSE; enemy = i; break; }
        }

        //magic attacks can hit anywhere
        if(no && (units[attacking].id == r_mage || units[attacking].id == b_mage || units[attacking].id == r_sorc || units[attacking].id == b_sorc || units[attacking].id == r_wmage || units[attacking].id == b_wmage))
        { no = FALSE; usex = TRUE; }

        //archers can't cheat with arrow shots..
        //add other players later...
        if(!no && (units[attacking].id == r_archer || units[attacking].id == b_archer) && map_data[vx][vy] & 1)
          no = TRUE;

        if(!no) for(y = 0; y < map_h; y++) for(x = 0; x < map_w; x++) if(!(map_data[x][y] & 4))
          if(vx == x && vy == y) { no = TRUE; break; }

        if(!no)
        {
          if(!usex) units[attacking].fight(enemy);
          else units[attacking].fight(-1, vx, vy);
        }
      }

      //menu
      if(menu_a)
      {
        short menu_y = units[selected].y*32-24;

        if(menu_y-my < 0) menu_y = 0;

        //move button
        if(!(units[selected].turnflags & TF_MOVED) && mouse_x > units[selected].x*32-12 && mouse_x < units[selected].x*32+12 &&
           mouse_y+my > menu_y && mouse_y+my < menu_y+24)
        {
          moving = selected;
          attacking = selected = -1;

          for(i = 0; i < MAX_UNITS; i++) if(i != moving && units[i].alive)
          {
            if(units[i].x == units[moving].x && units[i].y == units[moving].y-1)
              sides[0] = TRUE;
            if(units[i].x == units[moving].x+1 && units[i].y == units[moving].y)
              sides[1] = TRUE;
            if(units[i].x == units[moving].x && units[i].y == units[moving].y+1)
              sides[2] = TRUE;
            if(units[i].x == units[moving].x-1 && units[i].y == units[moving].y)
              sides[3] = TRUE;
          }
          if(sides[0] && sides[3])
            diagonals[0] = TRUE;
          if(sides[0] && sides[1])
            diagonals[1] = TRUE;
          if(sides[1] && sides[2])
            diagonals[2] = TRUE;
          if(sides[2] && sides[3])
            diagonals[3] = TRUE;

          int _x = -1, _y = 0;

          for(y = units[moving].y-2; y <= units[moving].y+2; y++) for(x = units[moving].x-2; x <= units[moving].x+2; x++)
          {
            char found = FALSE;

            _x++;
            if(_x > 4)
            {
              _x = 0;
              _y++;
            }
            if(x < 0 || y < 0 || x >= map_w || y >= map_h)
              continue;

            for(i = 0; i < MAX_UNITS; i++) if(i != moving && units[i].alive)
            {
              if(units[i].x == x && units[i].y == y)
                { found = TRUE; break; }
            }

            if(!found && units[moving].move_range[_x][_y])
            {
              if(x == units[moving].x && y < units[moving].y && sides[0])
                continue;
              if(y == units[moving].y && x > units[moving].x && sides[1])
                continue;
              if(x == units[moving].x && y > units[moving].y && sides[2])
                continue;
              if(y == units[moving].y && x < units[moving].x && sides[3])
                continue;
              if(x < units[moving].x && y < units[moving].y && diagonals[0])
                continue;
              if(x > units[moving].x && y < units[moving].y && diagonals[1])
                continue;
              if(x > units[moving].x && y > units[moving].y && diagonals[2])
                continue;
              if(x < units[moving].x && y > units[moving].y && diagonals[3])
                continue;
              if(map_data[x][y] & 8)
                continue;

              map_data[x][y] |= 2;
            }
          }
        }
        //attack button
        if(!(units[selected].turnflags & TF_ATTACKED) && selected != -1 && mouse_x > units[selected].x*32+12 && mouse_x < units[selected].x*32+36 &&
           mouse_y+my > menu_y && mouse_y+my < menu_y+24)
        {
          //doing magic?
          if(units[selected].id == r_mage || units[selected].id == b_mage)
          {
            units[selected].spelltype = open_menu("-Pick a Spell-", 240, 160, 180, 88, 0);

            if(units[selected].spelltype < 0) return;
          }
          if(units[selected].id == r_sorc || units[selected].id == b_sorc)
          {
            units[selected].spelltype = open_menu("-Pick a Spell-", 240, 160, 180, 88, 1);

            if(units[selected].spelltype < 0) return;
          }
          if(units[selected].id == r_wmage || units[selected].id == b_wmage)
          {
            units[selected].spelltype = open_menu("-Pick a Spell-", 240, 160, 190, 88, 4);

            if(units[selected].spelltype < 0) return;
          }

          attacking = selected;
          selected = moving = -1;

          int _x = -1, _y = 0;

          for(y = units[attacking].y-10; y <= units[attacking].y+10; y++) for(x = units[attacking].x-10; x <= units[attacking].x+10; x++)
          {
            _x++;
            if(_x > 20)
            {
              _x = 0;
              _y++;
            }
            if(x < 0 || y < 0 || x >= map_w || y >= map_h)
              continue;


            if(units[attacking].attack_range[_x][_y])
              map_data[x][y] |= 4;
          }
        }
      }

      //selecting a character
      if(moving == -1 && attacking == -1 && !no_selection && (selected == -1 || !units[selected].turnflags || turn_type == TT_LONG))
      {
        for(i = 0; i < MAX_UNITS; i++)
        {
          if(units[i].alive && (mouse_x/32) == units[i].x && ((mouse_y+my)/32) == units[i].y && ((game_type != GT_2PINET && current_side == units[i].side) || (game_type == GT_2PINET && units[i].side == local_side && current_side == local_side)) && !units[i].frozen)
          {
            selected = i;
            menu_a = 0;
            found = TRUE;
            break;
          }
        }
      }
      if(!found)
      {
        if(turn_type == TT_SHORT && selected != -1 && units[selected].turnflags & TF_MOVED)
          flip_map();
        selected = -1;
      }
      no_selection = FALSE;

      mouse_down = TRUE;
    }
  }
  else mouse_down = FALSE;

  if(mouse_b & 2 && (moving == -1 || !units[moving].moving))
  {
    if(turn_type == TT_SHORT)
    {
      if((selected != -1 && units[selected].turnflags & TF_MOVED) || (attacking != -1 && units[attacking].turnflags & TF_MOVED))
        flip_map();
    }

    selected = moving = attacking = -1;

    for(y = 0; y < map_h; y++) for(x = 0; x < map_w; x++)
    {
      if(map_data[x][y] & 2)
        map_data[x][y] &= ~2;
      if(map_data[x][y] & 4)
        map_data[x][y] &= ~4;
    }
  }
}

//processing()
//misc game loop processing (always called in all loops)
void processing()
{
  int i;

  fpscounter++;

  if(yield_os)
    yield_timeslice();

  if(selected != -1 && menu_a < 255)
  {
    menu_a += 7;
    if(menu_a > 255)
      menu_a = 255;
  }

  if(fading_in && screen_a < 255)
  {
    screen_a += 4;
    if(screen_a > 255)
    {
      screen_a = 255;
      fading_in = FALSE;
    }
  }

  for(i = 0; i < 10; i++) if(dmg[i].num != -1)
    dmg[i].processing();
  if(leader_died != -1)
  {
    ldied_scale += 0.01;
    ldied_ang += 5.12;
    if(ldied_scale >= 1.0)
    {
      ldied_scale = 1.0;
      ldied_ang = 0;
    }
  }

  //enable end turn if all men frozen
  if(loop_go == TRUE)
  {
    char all_frozen = TRUE, one_man = FALSE;

    for(i = 0; i < MAX_UNITS; i++) if(units[i].alive)
    {
      one_man = TRUE;
      if(units[i].side == current_side && !units[i].frozen)
      {
        all_frozen = FALSE;
        break;
      }
    }

    if(one_man && all_frozen)
      moved_one = TRUE;
  }

  //console
  console.processing();

  //online with multiplayer opponent
  if(online && game_type == GT_2PINET)
    net_processing();
}

//net_processing()
//multiplayer loop processing
void net_processing()
{
  if(is_server)
  {
    if(unit_set[0] && unit_set[1])
    {
      if(show_msg && strstr(show_msg, "Sending"))
      {
        char buf[128] = "";
        int i, j;

        net_packet.set("UPOS");

        for(i = 0; i < MAX_UNITS; i++) if(units[i].alive && units[i].side == local_side)
        {
          sprintf(buf, "%d %d %d %s\n", units[i].x, units[i].y, i, units[i].name);

          for(j = 0; buf[j]; j++)
            net_packet.add_byte(buf[j]);
        }
        net_packet.add_byte(0);
        net_packet.send_server();

        if(!received_other)
          show_msg = "Receiving unit positions..";
        else show_msg = NULL;
      }
    }

    net_packet.rec_server();

    if(net_packet.read("reEN"))
    {
      int side = net_packet.get_byte();

      flip_map();

      net_packet.set("ENDT");
      net_packet.add_byte(side);
      net_packet.send_server();
    }
    else if(net_packet.read("reDU"))
    {
      int side = net_packet.get_byte();

      unit_set[1] = TRUE;
      show_msg = "Sending unit positions..";

      net_packet.set("DUNT");
      net_packet.add_byte(side);
      net_packet.send_server();
    }
    else if(net_packet.read("reUP"))
    {
      char last_line = FALSE, line[128];

      while(!last_line)
      {
        int x, y, id, i, pos = 0;
        char name[32], string_empty;
        UNIT *type = NULL;

        while((line[pos]=net_packet.get_byte()) != '\n')
        {
          if(!line[pos])
          {
            last_line = TRUE;
            break;
          }

          pos++;
        }
        line[pos] = 0x20;
        pos++;
        line[pos] = 0;

        string_empty = TRUE;
        for(i = 0; line[i]; i++)
        {
          if(!isspace(line[i]))
          {
            string_empty = FALSE;
            break;
          }
        }

        if(string_empty)
          continue;

        if(sscanf(line, "%d %d %d %s", &x, &y, &id, name) < 4)
        {
          game_msg("Error receiving unit positions!");

          loop_go = FALSE;
          shutdown_server();

          online = FALSE;
          return;
        }

        for(i = 0; i < 9; i++)
        {
          if(strcmp(blue_type_list[i]->name, name) == 0)
          {
            type = (UNIT *)red_type_list[i];
            break;
          }
        }

        i = add_unit((map_w-1)-x, (map_h-1)-y, type, RED);
        if(i)
          units[i-1].remote_id = id;
      }

      show_msg = NULL;
      dummy_state = FALSE;
      received_other = TRUE;
      net_packet.set("OK..");
      net_packet.send_server();
    }
    else if(net_packet.read("reMO"))
    {
      int r_id, dx, dy, i;

      r_id = net_packet.get_byte();
      dx = net_packet.get_byte();
      dy = net_packet.get_byte();

      net_packet.set("OK..");
      net_packet.send_server();

      i = -1;
      for(i = 0; i < MAX_UNITS; i++) if(units[i].alive && units[i].side != local_side && r_id == units[i].remote_id)
        break;

      if(i != -1)
      {
        map_look(&units[i]);
        units[i].move(dx, dy);
      }
      else
        cerr << "Warning:  Move failed!\n";
    }
    else if(net_packet.read("reFI"))
    {
      int r_id, dx, dy, j, st, i;
      char person_there = FALSE;

      r_id = net_packet.get_byte();
      dx = net_packet.get_byte();
      dy = net_packet.get_byte();
      st = net_packet.get_byte();

      net_packet.set("OK..");
      net_packet.send_server();

      //search for unit that matches "remote id"
      i = -1;
      for(i = 0; i < MAX_UNITS; i++) if(units[i].alive && units[i].side != local_side && r_id == units[i].remote_id)
        break;

      for(j = 0; j < MAX_UNITS; j++) if(units[j].alive && units[j].x == dx && units[j].y == dy)
      { person_there = TRUE; break; }

      if(i != -1)
      {
        map_look(&units[i]);
        units[i].spelltype = st;

        if(units[i].long_range)
        {
          int x, y;

          map_data[units[i].x][units[i].y] = 0;
          map_look(&units[i]);
          for(y = units[i].y-1; y <= units[i].y+1; y++) for(x = units[i].x-1; x <= units[i].x+1; x++)
          {
            if(x >= 0 && x < map_w && y >= 0 && y < map_h && map_data[x][y] & 1)
              map_data[x][y] &= ~1;
          }
        }

        if(person_there)
          units[i].fight(&units[j]);
        else
          units[i].fight(-1, dx, dy);
      }
      else
        cerr << "Warning:  Attack failed!\n";
    }
    if(net_packet.read("reCH"))
    {
      char buf[PACKET_SIZE];
      int i = 0;

      while((buf[i]=net_packet.get_byte()))
        i++;

      console.print(buf);
      console.show();
      console.set_disappear_timer(600);

      net_packet.build_chat_string("CHAT", buf);
      net_packet.send_server();
    }
    else if(net_packet.read("ENDG"))
    {
      shutdown_server();
      online = FALSE;

      game_msg("Other player left the game!", TRUE);
    }
  }
  else
  {
    if(!waiting_response && unit_set[0] && unit_set[1])
    {
      if(show_msg && strstr(show_msg, "Sending"))
      {
        char buf[128] = "";
        int i, j;

        net_packet.set("reUP");

        for(i = 0; i < MAX_UNITS; i++) if(units[i].alive && units[i].side == local_side)
        {
          sprintf(buf, "%d %d %d %s\n", units[i].x, units[i].y, i, units[i].name);

          for(j = 0; buf[j]; j++)
            net_packet.add_byte(buf[j]);
        }
        net_packet.add_byte(0);
        net_packet.send_client();
        waiting_response = TRUE;

        if(!received_other)
          show_msg = "Receiving unit positions..";
        else
          show_msg = NULL;

        while(loop_go == TRUE && waiting_response)
          single_loop();
      }
    }

    net_packet.rec_client();

    if(net_packet.read("ENDT"))
    {
      int side = net_packet.get_byte();

      if(side == local_side)
        waiting_response = FALSE;
      else
        flip_map();
    }
    else if(net_packet.read("DUNT"))
    {
      int side = net_packet.get_byte();

      if(side == local_side)
        waiting_response = FALSE;
      else
      {
        unit_set[1] = TRUE;
        show_msg = "Sending unit positions..";
      }
    }
    else if(net_packet.read("UPOS"))
    {
      char last_line = FALSE, line[128];

      while(!last_line)
      {
        int x, y, id, i, pos = 0;
        char name[32], string_empty;
        UNIT *type = NULL;

        while((line[pos]=net_packet.get_byte()) != '\n')
        {
          if(!line[pos])
          {
            last_line = TRUE;
            break;
          }

          pos++;
        }
        line[pos] = 0x20;
        pos++;
        line[pos] = 0;

        string_empty = TRUE;
        for(i = 0; line[i]; i++)
        {
          if(!isspace(line[i]))
          {
            string_empty = FALSE;
            break;
          }
        }

        if(string_empty)
          continue;

        if(sscanf(line, "%d %d %d %s", &x, &y, &id, name) < 4)
        {
          game_msg("Error receiving unit positions!");

          loop_go = FALSE;
          shutdown_client();

          online = FALSE;
          return;
        }

        for(i = 0; i < 9; i++)
        {
          if(strcmp(blue_type_list[i]->name, name) == 0)
          {
            type = (UNIT *)blue_type_list[i];
            break;
          }
        }

        i = add_unit((map_w-1)-x, (map_h-1)-y, type, BLUE);
        if(i)
          units[i-1].remote_id = id;

      }

      show_msg = NULL;
      dummy_state = FALSE;
      current_side = !local_side;
      received_other = TRUE;
    }
    else if(net_packet.read("ENDG"))
    {
      shutdown_client();
      online = FALSE;

      game_msg("Other player left the game!", TRUE);
    }
    if(net_packet.read("CHAT"))
    {
      char buf[PACKET_SIZE];
      int i = 0;

      while((buf[i]=net_packet.get_byte()))
        i++;

      if(strstr(buf, "Player2"))
      {
        console.print(buf, makecol(75, 255, 255));
        waiting_response = FALSE;
        game_input_box.reset();
      }
      else
      {
        console.print(buf);
        console.show();
        console.set_disappear_timer(600);
      }
    }

    //Basic reply from server
    else if(net_packet.read("OK.."))
    {
      waiting_response = FALSE;
    }
  }

  //Same for both client and server
  if(net_packet.read("MOVE"))
  {
    int r_id, dx, dy, i;

    r_id = net_packet.get_byte();
    dx = net_packet.get_byte();
    dy = net_packet.get_byte();

    i = -1;
    for(i = 0; i < MAX_UNITS; i++) if(units[i].alive && units[i].side != local_side && r_id == units[i].remote_id)
      break;

    if(i != -1)
    {
      map_look(&units[i]);
      units[i].move(dx, dy);
    }
    else
      cerr << "Warning:  Move failed!\n";
  }
  else if(net_packet.read("FIGH"))
  {
    int r_id, dx, dy, j, st, i;
    char person_there = FALSE;

    r_id = net_packet.get_byte();
    dx = net_packet.get_byte();
    dy = net_packet.get_byte();
    st = net_packet.get_byte();

    //search for unit that matches "remote id"
    i = -1;
    for(i = 0; i < MAX_UNITS; i++) if(units[i].alive && units[i].side != local_side && r_id == units[i].remote_id)
      break;

    for(j = 0; j < MAX_UNITS; j++) if(units[j].alive && units[j].x == dx && units[j].y == dy)
    { person_there = TRUE; break; }

    if(i != -1)
    {
      map_look(&units[i]);
      units[i].spelltype = st;

      if(units[i].long_range)
      {
        int x, y;

        map_data[units[i].x][units[i].y] = 0;
        map_look(&units[i]);
        for(y = units[i].y-1; y <= units[i].y+1; y++) for(x = units[i].x-1; x <= units[i].x+1; x++)
        {
          if(x >= 0 && x < map_w && y >= 0 && y < map_h && map_data[x][y] & 1)
            map_data[x][y] &= ~1;
        }
      }

      if(person_there)
        units[i].fight(&units[j]);
      else
        units[i].fight(-1, dx, dy);
    }
    else
      cerr << "Warning:  Attack failed!\n";
  }
}

//draw_screen()
//render the screen
void draw_screen(char virt)
{
  int x, y;

  if(!virt)
    acquire_bitmap(buffer);

  blit(battlefield_bmp, buffer, 0, my, s_dx, s_dy, 640, 480);
  if(quake_id != -1)
    draw_sprite(buffer, (BITMAP *)data[quake_id].dat, s_dx+quake_x, s_dy+quake_y-my);

  for(y = 0; y < map_h; y++) for(x = 0; x < map_w; x++)
  {
    if(map_data[x][y] & 4)
      fblend_trans((BITMAP *)data[r_blank].dat, buffer, x*32, (y*32)-my, 128);
    if(map_data[x][y] & 2)
      fblend_trans((BITMAP *)data[b_blank].dat, buffer, x*32, (y*32)-my, 128);
    if(map_data[x][y] & 1)
      fblend_trans((BITMAP *)data[blank].dat, buffer, x*32, (y*32)-my, 128);
  }

  for(x = 0; x < MAX_UNITS; x++) if(units[x].alive)
  {
    if(attacking != x && !(map_data[units[x].x][units[x].y] & 1))
      units[x].draw();
  }

  for(x = 0; x < MAX_UNITS; x++) if(units[x].alive)
    if(attacking == x) units[x].draw();

  if(selected != -1)
  {
    int attack_sph = s_fight;
    short menu_y = units[selected].y*32-24;

    if(menu_y-my < 0) menu_y = 0;


    switch(units[selected].id)
    {
      case r_archer: 
      case b_archer: 
        attack_sph = s_arrow; 
      break;
      case r_mage:
      case b_mage:
      case r_sorc:
      case b_sorc:
      case r_wmage:
      case b_wmage:
        attack_sph = s_magic;
      break;
    }

    if(menu_a < 255)
    {
      if(!(units[selected].turnflags & TF_MOVED))
        fblend_trans((BITMAP *)data[s_move].dat, buffer, units[selected].x*32-12, menu_y-my, menu_a);
      if(!(units[selected].turnflags & TF_ATTACKED))
        fblend_trans((BITMAP *)data[attack_sph].dat, buffer, units[selected].x*32+12, menu_y-my, menu_a);
    }
    else
    {
      if(!(units[selected].turnflags & TF_MOVED))
        draw_sprite(buffer, (BITMAP *)data[s_move].dat, units[selected].x*32-12, menu_y-my);
      if(!(units[selected].turnflags & TF_ATTACKED))
        draw_sprite(buffer, (BITMAP *)data[attack_sph].dat, units[selected].x*32+12, menu_y-my);
    }
    units[selected].draw_stats();
  }

  if(moving != -1)
    units[moving].draw_stats();
  if(attacking != -1)
    units[attacking].draw_stats();
  if(draw_other_stats != -1)
    units[draw_other_stats].draw_stats(TRUE);
  if(game_type != GT_2PLOCAL && current_side != local_side)
  {
    window(520, 35, 115, 14, makecol(255, 0, 0));
    textout(buffer, font, "Enemy Turn..", 532, 45, 0xffff);
  }

  for(x = 0; x < 10; x++) if(dmg[x].num != -1)
  {
    if(dmg[x].a <= 255)
      fblend_trans(num(dmg[x].num), buffer, dmg[x].x, dmg[x].y-my, dmg[x].a);
    else
      draw_sprite(buffer, num(dmg[x].num), dmg[x].x, dmg[x].y-my);
  }
  if(leader_died != -1)
  {
    BITMAP *ptr = (leader_died == 0) ? (BITMAP *)data[redwins].dat : (BITMAP *)data[bluewins].dat;

    rotate_scaled_sprite(buffer, ptr, 320-(int)(ldied_scale*124.0), 240-(int)(ldied_scale*63.5), ftofix(ldied_ang), ftofix(ldied_scale));
  }

  if(dummy_state && show_msg)
  {
    const int w = text_length(font, show_msg)+10;

    window(320-w/2, 230, w+4, text_height(font)+4, makecol(0, 0, 255));
    textout_centre(buffer, font, show_msg, 320, 238, 0xffff);
  }

  if(game_input_box.enabled)
    game_input_box.draw();
  if(online && console.visible)
    console.draw(5, 100, TRUE);

  draw_sprite(buffer, curs_bmp, mouse_x, mouse_y);

  if(screen_a < 255)
    fblend_rect_trans(buffer, 0, 0, 640, 480, 0, 255-screen_a);

  if(!virt)
  {
    release_bitmap(buffer);
    blit(buffer, screen, 0, 0, 0, 0, 640, 480);
  }
}

//game_msg()
//cheap in-game notification (should loop later)
void game_msg(char *msg, char quit_out)
{
  clear_keybuf();

  acquire_bitmap(buffer);
  draw_screen(TRUE);
  fblend_rect_trans(buffer, 0, 0, 640, 480, 0, 128);
  textout_centre(buffer, font, msg, 321, 241, 0);
  textout_centre(buffer, font, msg, 320, 240, 0xffff);
  release_bitmap(buffer);
  blit(buffer, screen, 0, 0, 0, 0, 640, 480);

  clear_keybuf();

  rest(1000);
  while(!keypressed() && !mouse_b) ;
  fps = fpscounter = 0;

  if(quit_out)
    loop_go = 1;
}

//DAMAGE_NUM::DAMAGE_NUM()
//constructor
DAMAGE_NUM::DAMAGE_NUM()
{
  num = -1;
}

//DAMAGE_NUM::set()
//add dmg num to the game
void DAMAGE_NUM::set(int x, int y, int num)
{
  this->x = x;
  this->y = y;
  this->num = num;
  a = 320;
}

//DAMAGE_NUM::processing()
//misc dmg num processing
void DAMAGE_NUM::processing()
{
  if(a > 255)
    y -= 2;
  a -= 3;

  if(a <= 0)
  {
    num = -1;
    draw_other_stats = -1;
  }
}

