/*

*************************************************************************

effects.cpp - Iron Army special effects routines
Copyright (C) 2002 Mike Farrell (gccdragoonkain@yahoo.com)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***************************************************************************/

//Includes///////////////////////////////////////////////////////////////////
#include <allegro.h>
#include "loop.h"
#include "main.h"
#include "effects.h"

//e_fade_out()
//fade the screen out
void e_fade_out(char speed)
{
  int i;
  char keep_going = TRUE;

  selected = -1;

  //get rid of any extra animation first
  while(keep_going)
  {
    keep_going = FALSE;
    for(i = 0; i < 10; i++) if(dmg[i].num != -1)
      keep_going = TRUE;

    processing();
    if(fpscounter >= fps)
      draw_screen();
    while(fpscounter > fps) ;
  }

  for(screen_a = 255; screen_a > 0; screen_a -= speed)
  {
    processing();

    if(screen_a < 0)
      screen_a = 0;
    if(fpscounter >= fps)
      draw_screen();
    while(fpscounter > fps) ;
  }
}

//e_fade_in()
//fade the screen in
void e_fade_in(char speed)
{
  for(screen_a = 0; screen_a < 255; screen_a += speed)
  {
    processing();
    if(screen_a > 255)
      screen_a = 255;
    if(fpscounter >= fps)
      draw_screen();
    while(fpscounter > fps) ;
  }
}

//void rotate_scaled_sprite_trans()
//mix the draw_trans_sprite call and rotate_scaled_sprite call
//(could use some more efficiency)
void rotate_scaled_sprite_trans(BITMAP *dest, BITMAP *bmp, int x, int y, float ang, float scale)
{
  BITMAP *tmp;

  tmp = create_bitmap((int)(bmp->w*scale)+3, (int)(bmp->h*scale)+3);
  if(!tmp)
  {
    //if this keeps up, just return
    failure("Out of memory!");
  }
  clear_to_color(tmp, makecol(255, 0, 255));
  rotate_scaled_sprite(tmp, bmp, 0, 0, ftofix(ang), ftofix(scale));

  draw_trans_sprite(dest, tmp, x, y);

  destroy_bitmap(tmp);
}

