/* breakout for the 80x25 A.cc competition

   By James Stanley */

#include <allegro.h>

int main() {
  float ballx = 160, bally = 180;
  float xs = -0.5, ys = -0.5;
  int batx = 160;
  int batw = 100;
  int block[24];
  int i;
  int level = 1;
  int life = 3;
  BITMAP *canvas;
  float impactx;
  int colours[5];
  int done;
  
  allegro_init();
  install_keyboard();
  
  set_color_depth(16);
  set_gfx_mode(GFX_AUTODETECT_WINDOWED, 320, 200, 320, 200);
  
  canvas = create_bitmap(320, 200);
  
  for(i = 0; i < 5; i++) {
    colours[i] = makecol((125-(i*25))+100, level*40, 0);
  }
  
  for(i = 0; i < 24; i++) {
    block[i] = i/5;
  }
  
  while(!key[KEY_ESC]) {
    clear_to_color(canvas, 0);
    
    if(key[KEY_LEFT]) batx -= 2;
    if(key[KEY_RIGHT]) batx += 2;
    
    if((batx - (batw / 2)) < 0) batx = (batw / 2);
    if((batx + (batw / 2)) > 320) batx = 320 - (batw / 2);
    
    ballx += xs;
    bally += ys;
    
    if(ballx < 4) { ballx = 4; xs = -xs; }
    if(bally < 4) { bally = 4; ys = -ys; }
    if(ballx > 316) { ballx = 316; xs = -xs; }
    
    if(bally > 180) {
      if((ballx > (batx - (batw / 2))) && (ballx < (batx + (batw / 2)))) {
        ys = -ys;
        bally = 180;
        if(key[KEY_LEFT]) xs -= 0.1;
        if(key[KEY_RIGHT]) xs += 0.1;
      } else if(((ballx + 4) > (batx - (batw / 2))) && ((ballx - 4) < (batx + (batw / 2)))) {
        xs = -xs;
        ys = -ys;
        bally = 180;
        if(key[KEY_LEFT]) xs -= 0.2;
        if(key[KEY_RIGHT]) xs += 0.2;
      }
    }
    
    if(bally > 204) {
      life--;
      ballx = 160, bally = 180;
      xs = -0.5, ys = -0.5;
      batx = 160;
    }
    
    done = 0;
    for(i = 0; i < 24; i++) {
      if(block[i] < 5) {
        done = 1;
        if((ballx > (((i%4)*80)+5 + 70)) && ((ballx - 8) < (((i%4)*80)+5 + 70))) {//They may have collided with the right-hand-side
          if((bally < (((i/5)*20)+5 + 10)) && (bally > ((i/5)*20)+5)) {//They only collided with the right side
            xs = -xs;
            ballx = ((i%4)*80)+5 + 70 + 8;
            block[i]++;
          } else if(((bally + 8) > ((i/5)*20)+5) && (bally < ((i/5)*20)+5)) {//It collided with the bottom right corner
            impactx = xs;
            xs = ys;
            ys = impactx;
            block[i]++;
          } else if(((bally - 8) < (((i/5)*20)+5 + 10)) && (bally > (((i/5)*20)+5 + 10))) {//It collided with the top right corner
            impactx = xs;
            xs = -ys;
            ys = -impactx;
            block[i]++;
          }
        } else if((ballx < ((i%4)*80)+5) && ((ballx + 8) > ((i%4)*80)+5)) {//They may have collided with the left-hand-side
          if((bally < (((i/5)*20)+5 + 10)) && (bally > ((i/5)*20)+5)) {//They only collided with the left side
            xs = -xs;
            ballx = ((i%4)*80)+5 - 8;
            block[i]++;
          } else if(((bally + 8) > ((i/5)*20)+5) && (bally < ((i/5)*20)+5)) {//It collided with the bottom left corner
            impactx = xs;
            xs = -ys;
            ys = -impactx;
            block[i]++;
          } else if(((bally - 8) < (((i/5)*20)+5 + 10)) && (bally > (((i/5)*20)+5 + 10))) {//It collided with the top left corner
            impactx = xs;
            xs = ys;
            ys = impactx;
            block[i]++;
          }
        } else if(((bally + 8) > ((i/5)*20)+5) && (bally < ((i/5)*20)+5)) {//Could've collided with the bottom
          if((ballx > ((i%4)*80)+5) && (ballx < (((i%4)*80)+5 + 70))) {
            ys = -ys;
            bally = ((i/5)*20)+5 - 8;
            block[i]++;
          }
        }
        else if(((bally - 8) < (((i/5)*20)+5 + 10)) && (bally > (((i/5)*20)+5 + 10))) {//Could've collided with the top
          if((ballx > ((i%4)*80)+5) && (ballx < (((i%4)*80)+5 + 70))) {
            ys = -ys;
            bally = ((i/5)*20)+5 + 10 + 8;
            block[i]++;
          }
        }
        
        rectfill(canvas, ((i%4)*80)+5, ((i/5)*20)+5, ((i%4)*80)+75, ((i/5)*20)+15, colours[block[i]]);
      }
    }
    
    if(!done) {
      level++;
      for(i = 0; i < 5; i++) {
        colours[i] = makecol((i*25)+100, level*40, 0);
      }
      for(i = 0; i < 24; i++) {
        block[i] = i/5;
      }
      life++;
      ballx = 160, bally = 180;
      xs = -0.5, ys = -0.5;
      batx = 160;
      batw *= 0.8;
    }
    
    textprintf_ex(canvas, font, 4, 120, 0xf0a0f0a0, -1, "Lives: %d    Level: %d", life, level);
    rectfill(canvas, ballx - 4, bally - 4, ballx + 4, bally + 4, 0xff00ff00);
    rectfill(canvas, batx - (batw / 2), 184, batx + (batw / 2), 196, 0xffffffff);
    blit(canvas, screen, 0, 0, 0, 0, 320, 200);
    
    if(life < 0) {
      textout_centre_ex(canvas, font, "G A M E   O V E R", 160, 100, -1, -1);
      while(!key[KEY_ESC]) blit(canvas, screen, 0, 0, 0, 0, 320, 200);
      return 0;
    }
  }
} END_OF_MAIN()
