/***********************************************************
 *                                                         *
 *  screens.c                                              *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Secuencias en pantalla.                      *
 *                                                         *
 ***********************************************************/

// Incluimos librerias
#include "time.h"
#include "tanks.h"
#include "constants.h"
#include "config.h"
#include "grabber.h"
#include <alfont.h>
#include <allegro.h>
#include <fmod.h>


// Variables globales
extern stPlayerData *patCurrentPlayer[];

// Constantes
const int iKillPoints= 10;
const int aiPoints[NUM_PLAYERS_SCREEN]= {300, 200, 100, 0};


// Secuencia de la pantalla de VS
void vs_screen(void) {
   BITMAP *bmpVersus;
   ALFONT_FONT *fontUser;
   FSOUND_SAMPLE *sndScratch;

   // Cargamos los datos
   clear_clock();
   bmpVersus = load_png_from_dat("VS", SCREENS_FILE);
   fontUser  = load_font_from_dat("LOVE", FONTS_FILE, 40);
   sndScratch= load_sound_from_dat("SCRATCH", SOUND_FILE);

   // Ponemos los datos y la imagen en pantalla
   FSOUND_PlaySound(FSOUND_FREE, sndScratch);
   alfont_textout_aa(bmpVersus, fontUser, patCurrentPlayer[0]->szName,  24, 104, 0);
   alfont_textout_aa(bmpVersus, fontUser, patCurrentPlayer[0]->szName,  20, 100, patCurrentPlayer[0]->iColor);
   alfont_textout_aa(bmpVersus, fontUser, patCurrentPlayer[1]->szName, 544, 104, 0);
   alfont_textout_aa(bmpVersus, fontUser, patCurrentPlayer[1]->szName, 540, 100, patCurrentPlayer[1]->iColor);
   alfont_textout_aa(bmpVersus, fontUser, patCurrentPlayer[2]->szName, 544, 444, 0);
   alfont_textout_aa(bmpVersus, fontUser, patCurrentPlayer[2]->szName, 540, 440, patCurrentPlayer[2]->iColor);
   alfont_textout_aa(bmpVersus, fontUser, patCurrentPlayer[3]->szName,  24, 444, 0);
   alfont_textout_aa(bmpVersus, fontUser, patCurrentPlayer[3]->szName,  20, 440, patCurrentPlayer[3]->iColor);
   vsync();
   draw_sprite(screen, bmpVersus, 0, 0);

   // Nos esperamos
   wait_clock(3500, TRUE);

   // Destruimos datos
   destroy_bitmap(bmpVersus);
   alfont_destroy_font(fontUser);
}


// Obtenemos cuantos puntos tuvo cada quien
void get_score(void) {
   int i, j;
   int iStart;
   int iPoints;
   stPlayerData *ptTemp;

   // Obtenemos la diferencia de muertes e incrementamos totales
   for (i= 0; i< NUM_PLAYERS_SCREEN; ++i) {
      patCurrentPlayer[i]->iKills+= patCurrentPlayer[i]->iMatchKills;
      patCurrentPlayer[i]->iDeads+= patCurrentPlayer[i]->iMatchDeads;
      patCurrentPlayer[i]->iMatchDelta= 
         patCurrentPlayer[i]->iMatchKills -patCurrentPlayer[i]->iMatchDeads;
   }

   // Ordenamos de mayor a menor
   for (i= 0; i< NUM_PLAYERS_SCREEN; ++i) {
      for (j= i; j> 0; --j) {
         if (patCurrentPlayer[j]->iMatchDelta > patCurrentPlayer[j-1]->iMatchDelta) {
            ptTemp= patCurrentPlayer[j];
            patCurrentPlayer[j]= patCurrentPlayer[j-1];
            patCurrentPlayer[j-1]= ptTemp;
         }
      }
   }

   //Asignamos puntuacion
   for (i= 0; i< NUM_PLAYERS_SCREEN; ) {
      iStart= i;
      for (iPoints= 0; i< NUM_PLAYERS_SCREEN; ++i) {
         if (patCurrentPlayer[i]->iMatchDelta != patCurrentPlayer[iStart]->iMatchDelta) {
            break;
         }
         iPoints+= aiPoints[i];
      }
      iPoints/= (i -iStart);
      for (j= iStart; j< i; ++j) {
         patCurrentPlayer[j]->iMatchPoints= iPoints + iKillPoints*patCurrentPlayer[j]->iMatchKills;
         patCurrentPlayer[j]->iPoints+= patCurrentPlayer[j]->iMatchPoints;
      }
   }
}


// Secuencia de asignacion de puntos
void score_screen(void) {
   int i, j;
   int iFrame;
   int iWidth;
   int iHeight;
   int iStartX= 0;
   int iStartY= 0;
   BITMAP *bmpTile;
   BITMAP *bmpScoreBoard;
   const int iVelX= -5;
   const int iVelY= -5;
   const int iDelta= 100;
   const int iTotalFrames= 140;
   const int aiPosX[NUM_PLAYERS_SCREEN]= {132, 394, 394, 132};
   const int aiPosY[NUM_PLAYERS_SCREEN]= {192, 192, 340, 340};
   const int aiStartFrame[NUM_PLAYERS_SCREEN]= {10, 25, 40, 55};
   extern BITMAP *g_bmpBuffer;
   extern FSOUND_SAMPLE *sndShot;

   // Cargamos imagenes
   bmpTile = load_png_from_dat("TILE", SCREENS_FILE);
   bmpScoreBoard = load_png_from_dat("SCORE", SCREENS_FILE);
   iWidth = bmpTile->w + 130;
   iHeight= bmpTile->h +  50;

   // Obtenemos los puntajes
   get_score();
   int iX, iY;

   // Ponemos scores en pantalla
   clear_clock();
   for (iFrame= 0; iFrame< iTotalFrames; ++iFrame) {
      // Ponemos el fondo
      clear_to_color(g_bmpBuffer, makecol(255, 255, 255));
      i= 0;
      iX= iStartX; 
      iY= iStartY;
      iStartX+= iVelX;
      if (iStartX > iWidth) {
         iStartX-= iWidth;
      }
      iStartY+= iVelY;
      if (iStartY > iHeight) {
         iStartY-= iHeight;
      }
      while (iY < SCREEN_HEIGHT) {
         draw_sprite(g_bmpBuffer, bmpTile, iX, iY);
         iX+= iWidth;
         if (iX > SCREEN_WIDTH) {
            iX= iStartX - (++i)*iDelta;
            iY+= iHeight;
         }
      }
      draw_sprite(g_bmpBuffer, bmpScoreBoard, 0, 0);

      // Ponemos los datos
      for (i= 0; i< NUM_PLAYERS_SCREEN; ++i) {
         draw_sprite(g_bmpBuffer, patCurrentPlayer[i]->bmpTank, aiPosX[i], aiPosY[i]);
         textprintf_ex(g_bmpBuffer, font, aiPosX[i] + 100, aiPosY[i] + 10,
            patCurrentPlayer[i]->iColor, -1, "%s", patCurrentPlayer[i]->szName);
         if (iFrame< aiStartFrame[i]) {
            continue;
         } else if (iFrame == aiStartFrame[i]) {
            FSOUND_PlaySound(FSOUND_FREE, sndShot);
         }
         textprintf_ex(g_bmpBuffer, font, aiPosX[i] + 150,
            aiPosY[i] + 30, patCurrentPlayer[i]->iColor, -1, "%2d %3d", 
            patCurrentPlayer[i]->iMatchKills -patCurrentPlayer[i]->iMatchDeads,
            patCurrentPlayer[i]->iMatchPoints);
      }
      draw_sprite(screen, g_bmpBuffer, 0, 0);
      wait_clock(40, TRUE);
   }

   // Destruimos imagenes
   destroy_bitmap(bmpTile);
   destroy_bitmap(bmpScoreBoard);
}
