/***********************************************************
 *                                                         *
 *  memory.c                                               *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Funciones para manejar memoria.              *
 *                                                         *
 ***********************************************************/

// Librerias
#include "memory.h"
#include "error.h"
#include <stdlib.h>


// Coloca iSize bytes en memoria y los inicializa a 0
void *safe_malloc(size_t iSize) {
   void *pTemp;

   if ((pTemp= malloc(iSize))== NULL) {
      error_message("Error al crear memoria dinamica");
   }
   return (pTemp);
}


// Coloca iNumItems de iSize bytes en memoria y los inicializa a 0
void *safe_calloc(size_t iNumItems, size_t iSize) {
   void *pTemp;

   if ((pTemp= calloc(iNumItems, iSize))== NULL) {
      error_message("Error al crear memoria dinamica");
   }
   return (pTemp);
}


// Ajusta el tamao en bytes a iSize, moviendo el contenido a una nueva localidad en caso de que sea necesario
void *safe_realloc(void *Block, size_t iSize) {
   void *pTemp;

   if ((pTemp= realloc(Block, iSize))== NULL) {
      error_message("Error al crear memoria dinamica");
   }
   return (pTemp);
}


// Intercambia dos bloques de memoria de tamano iSize
void mem_swap(void *pData1, void *pData2, size_t iSize) {
   void *pTemp;

   pTemp= safe_malloc(iSize);
   memmove(pTemp , pData1, iSize);
   memmove(pData1, pData2, iSize);
   memmove(pData2, pTemp , iSize);
   safe_free(pTemp);
}


// Intercambia dos enteros
void int_swap(int *iData1, int *iData2) {
   int iTemp;

   iTemp= *iData1;
   *iData1= *iData2;
   *iData2= iTemp;
}
