/***********************************************************
 *                                                         *
 *  config.c                                               *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Funciones para inicializar, cerrar y         *
 *           configurar.                                   *
 *                                                         *
 ***********************************************************/

// Incluimos librerias
#include "config.h"
#include "constants.h"
#include "error.h"
#include "time.h"
#include "random.h"
#include "grabber.h"
#include <alfont.h>
#include <allegro.h>
#include <fmod.h>


// Variables globales
BITMAP *g_bmpBuffer;


// Inicializamos librerias
void libraries_init(void) {
   int i;
   int bScreenReady;
   const int iNumScreenRes= 4;
   const int aiScreenRes[iNumScreenRes]= {32, 24, 16, 15};

   // Inicializamos Allegro
   allegro_init();
   install_keyboard();

   // Inicializamos la librerias para fonts
   if (alfont_init() != ALFONT_OK) {
      error_message("Alfont no pudo ser inicializado.");
   }
   alfont_text_mode(-1);

   // Inicializamos la librerias para sonido
   if (!FSOUND_Init(MIX_RATE, CHANNELS, MUSIC_FLAGS)) {
      error_message("FMOD no pudo ser inicializado.");
   }

   // Inicializamos librerias propias
   timer_init();
   random_init();
   register_datafile_objects();

   // Seleccionamos el modo de video a emplear
   bScreenReady = FALSE;
   for (i = 0; i < iNumScreenRes; ++i) {
      set_color_depth (aiScreenRes[i]);
      //if (set_gfx_mode (GFX_AUTODETECT_WINDOWED, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 0) == 0) {
	   if (set_gfx_mode (GFX_AUTODETECT_FULLSCREEN, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 0) == 0) {
         bScreenReady = TRUE;
         break;
      }
   }
   if (!bScreenReady) {
      error_message ("El modo de video no pudo ser inicializado.");
   }
   
   // Creamos el buffer
   g_bmpBuffer = create_system_bitmap (SCREEN_WIDTH, SCREEN_HEIGHT);
   if (!g_bmpBuffer) {
      g_bmpBuffer = create_bitmap (SCREEN_WIDTH, SCREEN_HEIGHT);
   }
}


// Cerramos librerias
void libraries_exit(void) {
   destroy_bitmap(g_bmpBuffer);
   timer_exit();
   FSOUND_Close();
   alfont_exit();
   allegro_exit();
}
