/***********************************************************
 *                                                         *
 *  time.c                                                 *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Cuerpo para las funciones de manejo de       *
 *          tiempo.                                        *
 *                                                         *
 ***********************************************************/

// Librerias a incluir
#include "time.h"
#include "error.h"
#include <allegro.h>

// Variables Globales
static int iPause;
volatile int iClock;
volatile int iCount;
volatile int iFadeCount;


// Incrementa las variable de tiempo
void increase_clock(void) {
   if (!iPause) {
      ++iCount;
   }
   ++iClock;
   ++iFadeCount;
}
END_OF_FUNCTION(increase_clock);


// Reinicia el reloj
void clear_clock(void) {
   iClock= 0;
}


// Reinicia el contador
void clear_count(void) {
   iCount= 0;
}


// Reinicia el contador del fade
void clear_fade_count(void) {
   iFadeCount= 0;
}


// Detiene el contador
void pause_count(void) {
   iPause= 1;
}


// Reanuda el contador
void unpause_count(void) {
   iPause= 0;
}


// Inicializa funciones y variables
void timer_init(void) {
   if (install_timer() != 0) {
      error_message("Error al inicializar install_timer()");
   }
   LOCK_VARIABLE(iClock);
   LOCK_VARIABLE(iCount);
   LOCK_FUNCTION(increase_clock);
   install_int(increase_clock,1);
   clear_clock();
   clear_count();
   clear_fade_count();
   unpause_count();
}


// Espera a que pase el tiempo desde que se inicio el reloj
void wait_clock(int iTime, int bClear) {
   while (iClock<= iTime);
   if (bClear) {
      clear_clock();
   }
}


// Espera a que pase el tiempo desde que se inicio el reloj o a que presionen una tecla 
void wait_clock_or_key(int iTime, int bClear) {
   clear_keybuf();
   while (iClock<= iTime) {
      if (keypressed()) {
         break;
      }
   }
   if (bClear) {
      clear_clock();
   }
}

// Regresa cuanto tiempo paso desde que se inicio la cuenta
int return_clock(void) {
   return(iClock);
}


// Regresa cuanto tiempo paso desde que se inicio la cuenta
int return_count(void) {
   return(iCount);
}


// Regresa cuanto tiempo paso desde que se inicio la cuenta
int return_fade_count(void) {
   return(iFadeCount);
}


// Cierra libreria
void timer_exit(void) {
   remove_int(increase_clock);
   remove_timer();
}
