/***********************************************************
 *                                                         *
 *  random.c                                               *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Sustituto para "random()" y "randomize()",   *
 *          ya que no son ANSI C.                          *
 *                                                         *
 ***********************************************************/

// Librerias a incluir
#include "random.h"
#include "memory.h"
#include <time.h>
#include <stdlib.h>


// Inicializa el random con el reloj
void random_init(void) {
   time_t t;

   srand((unsigned) time(&t));
}


// Inicializa el random con una semilla
void random_init_seed (int iSeed) {
  srand (iSeed);
}


// Regresa un numero aleatorio entre 0 e iMod-1
int random_num(int iMod) {
   return (rand() % iMod);
}


// Regresa un numero aleatorio entre iMin e iMax
int random_range(int iMin, int iMax) {
   if (iMin > iMax) {
      return (0);
   } else {
      return ((rand() % (iMax -iMin +1)) + iMin);
   }
}


// Regresa un numero aleatorio entre 0 e iNum-1, donde el numero i tienen una probabilidad iWeight[i]
int weighted_random(int iNum, int aiWeight[]) {
   int i;
   int iTemp;
   int iTotal;
  
   for (i= 0, iTotal= 0; i< iNum; ++i) {
      iTotal+= aiWeight[i];
   }
   iTemp= random_num(iTotal);
   for (i= 0; iTemp> 0; i++) {
      iTemp-= aiWeight[i];
   }

   return (i-1);
}


// Hace una permutacion aleatoria de un arreglo
void randomize_array(int iNum, int aiArray[]) {
   int i;

   for (i= 0; i< iNum; ++i) {
      int_swap(&aiArray[i], &aiArray[random_num(iNum)]);
   }
}
