//USES
#include <mem.h>
#include <math.h>
#include <time.h>
#include <ctype.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <process.h>

//CONST
#define tope        7
#define total      16
#define turnos     60

const int puntos_inicio[4][2]= {{2,tope},{tope,tope-1},{tope-1,1},{1,2}};
const char giro[4]= {'E','S','O','N'};
const char instrucciones[6]= {'A','R','I','D','S','N'};

//VAR
struct datos {
   char programa[100],nombre[100];
   int  x,y,direccion,favor,contra,peleas;
   } persona[total+1];
int i, j, tiempo, turno[4], choque[tope+2][tope+2];
FILE *precal;

//FUNCTION
void Lee_concursantes    (void);
void Inicializacion      (void);
void Acomoda             (int equipo_m);
void Acciones            (int i,char ch);
void Intercambia_datos   (void);


//BEGIN
int main(int argc, char *argv[])
    {
    srand(time(NULL));
    Lee_concursantes();
    puts("Precalculando: ");
    precal = fopen("precal.dat", "wt");
    fprintf(precal,"%d %d\n",total,turnos);

    for (i=1; i<= 3*(total/4); i++)
        {
        printf("               %d de %d\n",i,3*(total/4));
        Inicializacion();
        for (j=0; j<4; j++)
            fprintf(precal,"%d %s ",turno[j]-1,persona[turno[j]].programa);
        fprintf(precal,"\n");
        for (j=0; j<turnos; j++)
            {
            Intercambia_datos();
            //printf(" %d",j);
            }
        }
    fclose(precal);
    puts("");
    puts("-->FIN<--");
    system("PAUSE");
    return 0;
    }


//
void Lee_concursantes(void)
     {
     int i;
     FILE *entrada = fopen("personas.txt", "rt");

     for (i=1; i<=total, !feof(entrada); i++)
         {
         fscanf(entrada,"%s",&persona[i].programa);
         fgets(persona[i].nombre,100,entrada);
         persona[i].peleas= 0;
         }
     fclose(entrada);
     }


//
void Inicializacion(void)
     {
     int i,m,t;

     m= total/4;
     for (i= 1; i<= 4; i++)
         {
         t= 4*(rand()%m) + i;
         while (persona[t].peleas==3)
               t= 4*(rand()%m) + i;
         turno[i-1]= t;
         persona[t].peleas++;
                                                   //writeln(i,' ',turno[i],' ',nombre,' ',programa)
         }

     memset(choque, 0, sizeof(choque));
     for (i=0; i<= tope+1; i++)
         {
         choque[0][i]= 255;
         choque[tope+1][i]= 255;
         choque[i][0]= 255;
         choque[i][tope+1]= 255;
         }
     for (i=0; i< 4; i++)
         {
         persona[turno[i]].favor= 0;
         persona[turno[i]].contra= 0;
         persona[turno[i]].x= puntos_inicio[i][0];
         persona[turno[i]].y= puntos_inicio[i][1];
         persona[turno[i]].direccion= i;
         choque[persona[turno[i]].x][persona[turno[i]].y]= i+1;
         }
     }


//
void Acomoda (int equipo_m)
     {
     int d,i,j,k,m,dmax,nuevo_x,nuevo_y,tablero[tope+2][tope+2];

     for (i=0; i<=tope+1; i++)
         for (j=0; j<=tope+1; j++)
             tablero[i][j]= 9;

     for (i=0; i< 4 ; i++)
         {
         if (i==equipo_m) continue;
         for (j= persona[turno[i]].x; j<= tope; j++)
             tablero[j][persona[turno[i]].y]= 1;
         for (j= persona[turno[i]].x; j>= 1; j--)
             tablero[j][persona[turno[i]].y]= 1;
         for (j= persona[turno[i]].y; j<= tope; j++)
             tablero[persona[turno[i]].x][j]= 1;
         for (j= persona[turno[i]].y; j>= 1; j--)
             tablero[persona[turno[i]].x][j]= 1;
         }

     for (k= 1; k<=tope; k++)
         for (i= 1; i<=tope; i++)
             for (j= 1; j<=tope; j++)
                 if (tablero[i][j]<=k) continue;
                    else {
                         tablero[i][j]= tablero[i+1][j];
                         if (tablero[i][j]> tablero[i-1][j]) tablero[i][j]= tablero[i-1][j];
                         if (tablero[i][j]> tablero[i][j+1]) tablero[i][j]= tablero[i][j+1];
                         if (tablero[i][j]> tablero[i][j-1]) tablero[i][j]= tablero[i][j-1];
                         tablero[i][j]++;
                         }

     dmax= 0; m= 0; nuevo_x= 0; nuevo_y= 0;
     for (i=1; i<= tope; i++)
         for (j=1; j<= tope; j++)
             if (tablero[i][j]>=m)                                 //Revisar
                {
                d= 0;
                for (k= 0; k<4; k++)
                    {
                    if (k== turno[equipo_m])
                     continue;
                    d+= abs(persona[turno[k]].x -i)+ abs(persona[turno[k]].y -j);
                    }
                if ((tablero[i][j] > m)||(d>dmax))
                   {
                   dmax= d;
                   m= tablero[i][j];
                   nuevo_x= i; nuevo_y= j;
                   }
                }
     choque[persona[turno[equipo_m]].x][persona[turno[equipo_m]].y]= 0;
     persona[turno[equipo_m]].x= nuevo_x;
     persona[turno[equipo_m]].y= nuevo_y;
     choque[persona[turno[equipo_m]].x][persona[turno[equipo_m]].y]= equipo_m+1;
     }


//
void Acciones(int i,char ch)
     {
     int j,x,y,dx,dy;  int a;

     dx= 0; dy= 0;
     x= persona[turno[i]].x;
     y= persona[turno[i]].y;
     switch (persona[turno[i]].direccion)
            {
            case 0: dx= 1; break;
            case 1: dy=-1; break;
            case 2: dx=-1; break;
            case 3: dy= 1; break;
            }
     switch (ch)
            {
            case 'A': if (choque[x+dx][y+dy]==0)
                         {
                         choque[x][y]= 0;
                         x+= dx; y+= dy;
                         choque[x][y]= i+1;
                         } break;
            case 'R': if (choque[x-dx][y-dy]==0)
                         {
                         choque[x][y]= 0;
                         x-= dx; y-= dy;
                         choque[x][y]= i+1;
                         } break;
            case 'I': persona[turno[i]].direccion= (4+persona[turno[i]].direccion-1) % 4;
                      break;
            case 'D': persona[turno[i]].direccion= (persona[turno[i]].direccion+1) % 4;
                      break;
            case 'S': for (j=1; j<=5; j++)
                          {
                          a= choque[x+j*dx][y+j*dy];
                          if (a == 255) break;
                          if (a != 0)
                             {
                             persona[turno[i]].favor ++;
                             persona[turno[a-1]].contra++ ;
                             Acomoda(choque[x+j*dx][y+j*dy]-1);
                             fprintf(precal,"%d %d %d\n",a-1,persona[turno[a-1]].x,persona[turno[a-1]].y);
                             }
                          }
                      fprintf(precal,"%d\n",-1);
                      break;
            }
     persona[turno[i]].x= x;
     persona[turno[i]].y= y;
     }


//
void Intercambia_datos(void)
     {
     int i,j,k;
     char s[100], *ptr;
     FILE *entrada, *salida;

     for (i=0; i< 4; i++)
         {
         salida  = fopen("datos.txt", "wt");
         fprintf(salida,"%d %d %d %c\n",persona[turno[i]].favor-persona[turno[i]].contra,
                 persona[turno[i]].x,persona[turno[i]].y,giro[persona[turno[i]].direccion]);
         for (j= 0; j< 4; j++)
             if (i!=j)
                fprintf(salida,"%d %d %d %c\n",persona[turno[j]].favor-persona[turno[j]].contra,
                        persona[turno[j]].x,persona[turno[j]].y,giro[persona[turno[j]].direccion]);
         fclose(salida);

         entrada  = fopen("salida.txt", "wt");
         fclose(entrada);
         if (spawnl(P_WAIT,persona[turno[i]].programa,NULL)== -1)
         //if (spawnl(P_NOWAIT,persona[turno[i]].programa,NULL)== -1)
	         printf("%s %s\n",persona[turno[i]].programa,sys_errlist[errno]);

         entrada  = fopen("salida.txt", "rt");
         fscanf(entrada,"%s",s);
         fclose(entrada);

         for (j= 0; j<5; j++)
             if (strchr(s,instrucciones[j])) break;
         if (instrucciones[j]=='N') j= rand()%5;
         fprintf(precal,"%c\n",instrucciones[j]);
         Acciones(i,instrucciones[j]);
         }
     }
