/***********************************************************
 *                                                         *
 *  memory.c                                               *
 *  Autor:  Pier Paolo Guillen Hernandez                   *
 *          Aguascalientes, Ags.                           *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Headers de las funciones para memoria.       *
 *                                                         *
 ***********************************************************/

#ifndef MEMORY_H
#define MEMORY_H

// Librerias a incluir
#include <string.h>

// Funciones por macro
#define safe_free(x)    {if (x) free(x); (x)= NULL;}     // Libera memoria colocada dinamicamente 

// Declaramos funciones
void *safe_malloc(size_t);                // Coloca iSize bytes en memoria y los inicializa a 0
void *safe_calloc(size_t, size_t);        // Coloca iNumItems de iSize bytes en memoria y los inicializa a 0
void *safe_realloc(void *, size_t);       // Ajusta el tamao en bytes a iSize, moviendo el contenido a una nueva localidad en caso de que sea necesario
void mem_swap(void *, void *, size_t);    // Intercambia dos bloques de memoria de tamano iSize
void int_swap(int *, int *);              // Intercambia dos enteros

#endif
