/***********************************************************
 *                                                         *
 *  grabber.c                                              *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Funciones para poder leer distintos datos    *
 *          desde un archivo .dat creado con el grabber.   *
 *                                                         *
 ***********************************************************/


#include "grabber.h"
#include "error.h"
#include "memory.h"
#include "constants.h"
#include "loadpng.h"
#include <alfont.h>
#include <allegro.h>
#include <png.h>
#include <fmod.h>


// Registramos las extensiones que vayamos a utilizat en los datafile
void register_datafile_objects (void) {
   register_png_datafile_object(DAT_PNG);
}


// Para cargar un font ttf con alfont desde un .dat de grabber
ALFONT_FONT *load_font_from_dat(const char *pszName, const char *pszDir, int iHeight) {
   char szError[STRING_SIZE];
   DATAFILE *datTemp;
   ALFONT_FONT *fontTemp;

   if ((datTemp= load_datafile_object(pszDir, pszName))== NULL) {
      sprintf(szError,"Error al cargar %s desde %s", pszName, pszDir);
      error_message(szError);
   }
   
   fontTemp= alfont_load_font_from_mem((char *) datTemp->dat, datTemp->size);
   alfont_set_font_size(fontTemp, iHeight);
   unload_datafile_object(datTemp);
   return (fontTemp);
}


// Para cargar una imagen bmp desde un .dat de grabber
BITMAP *load_bmp_from_dat(const char *pszName, const char *pszDir) {
   char szError[STRING_SIZE];
   BITMAP *bmpTemp;
   DATAFILE *datTemp;

   if ((datTemp= load_datafile_object(pszDir, pszName))== NULL) {
      sprintf(szError,"Error al cargar %s desde %s", pszName, pszDir);
      error_message(szError);
   }
   bmpTemp= create_bitmap(((BITMAP *)datTemp->dat)->w,((BITMAP *)datTemp->dat)->h);
   blit((BITMAP *)datTemp->dat, bmpTemp, 0, 0, 0, 0, bmpTemp->w, bmpTemp->h);
   unload_datafile_object(datTemp);
	return (bmpTemp);
}


// Para cargar una imagen rle desde un .dat de grabber
RLE_SPRITE *load_rle_from_dat(const char *pszName, const char *pszDir) {
   char szError[STRING_SIZE];
   BITMAP *bmpTemp;
   RLE_SPRITE *rleTemp;
   DATAFILE *datTemp;

   if ((datTemp= load_datafile_object(pszDir, pszName))== NULL) {
      sprintf(szError,"Error al cargar %s desde %s", pszName, pszDir);
      error_message(szError);
   }
   bmpTemp= create_bitmap(((RLE_SPRITE *)datTemp->dat)->w,((RLE_SPRITE *)datTemp->dat)->h);
   clear_to_color(bmpTemp, bitmap_mask_color(bmpTemp));
   draw_rle_sprite(bmpTemp, (RLE_SPRITE *)datTemp->dat, 0, 0);
   unload_datafile_object(datTemp);
   rleTemp= get_rle_sprite(bmpTemp);
   destroy_bitmap(bmpTemp);
   return (rleTemp);
}


// Para cargar una imagen bmp desde un .dat de grabber
BITMAP *load_png_from_dat(const char *pszName, const char *pszDir) {
   char szError[STRING_SIZE];
   BITMAP *bmpTemp;
   DATAFILE *datTemp;

   if ((datTemp= load_datafile_object(pszDir, pszName))== NULL) {
      sprintf(szError,"Error al cargar %s desde %s", pszName, pszDir);
      error_message(szError);
   }
   bmpTemp= create_bitmap(((BITMAP *)datTemp->dat)->w,((BITMAP *)datTemp->dat)->h);
   blit((BITMAP *)datTemp->dat, bmpTemp, 0, 0, 0, 0, bmpTemp->w, bmpTemp->h);
   unload_datafile_object(datTemp);
	return (bmpTemp);
}


// Para carga un archivo de texto desde un .dat de grabber
char *load_txt_from_dat(const char *pszName, const char *pszDir, int *piSize) {
   char *pszTemp;
   char szError[STRING_SIZE];
   DATAFILE *datTemp;

	if ((datTemp= load_datafile_object(pszDir, pszName))== NULL) {
      sprintf(szError,"Error al cargar %s desde %s", pszName, pszDir);
      error_message(szError);
   }
   *piSize= datTemp->size+1;
   pszTemp= (char *) safe_malloc(sizeof (char) * (*piSize));   
   memmove(pszTemp, (char *)(datTemp->dat), datTemp->size);
   pszTemp[datTemp->size] = '\0';
   unload_datafile_object(datTemp);
   return (pszTemp);
}


// Para carga un archivo de sonido desde un .dat de grabber
FSOUND_SAMPLE *load_sound_from_dat(const char *pszName, const char *pszDir) {
   char szError[STRING_SIZE];
   DATAFILE *datTemp;
   FSOUND_SAMPLE *sndTemp;

	if ((datTemp= load_datafile_object(pszDir, pszName))== NULL) {
      sprintf(szError,"Error al cargar %s desde %s", pszName, pszDir);
      error_message(szError);
   }
   sndTemp= FSOUND_Sample_Load(FSOUND_FREE, (char *)datTemp->dat, 
      FSOUND_LOADMEMORY | FSOUND_2D, 0, datTemp->size); 
   unload_datafile_object(datTemp);
   return (sndTemp);
}


// Para carga un archivo de musica como stream desde un .dat de grabber
FSOUND_STREAM *load_stream_from_dat(const char *pszName, const char *pszDir) {
   char szError[STRING_SIZE];
   DATAFILE *datTemp;
   FSOUND_STREAM *stmTemp;

	if ((datTemp= load_datafile_object(pszDir, pszName))== NULL) {
      sprintf(szError,"Error al cargar %s desde %s", pszName, pszDir);
      error_message(szError);
   }
   stmTemp= FSOUND_Stream_Open((char *)datTemp->dat, FSOUND_LOADMEMORY | FSOUND_2D, 0, datTemp->size);
   unload_datafile_object(datTemp);
   return (stmTemp);
}
