/***********************************************************
 *                                                         *
 *  fade.c                                                 *
 *  Autor: Pier Paolo Guillen Hernandez                    *
 *         Aguascalientes, Ags.                            *
 *  Fecha: Marzo 2004 - Abril 2008                         *
 *                                                         *
 *  Objetivo: Funciones para hacer fade-in y fade-out en   *
 *          pantalla.                                      * 
 *                                                         *
 ***********************************************************/

// Librerias a incluir
#include "fade.h"
#include "time.h"
#include "constants.h"
#include <allegro.h>
#include <fmod.h>


// Fade de entrada (de color a imagen)
void fade_from_color (BITMAP *bmpOriginal, int iTotalTime, int iX, int iY, int iColour) {
   int iAlpha = 0;
   int iCount = 0;

   set_trans_blender (getr (iColour), getg (iColour), getb (iColour), 0);
   clear_fade_count();
   for (iCount = 0; iCount < iTotalTime; iCount = return_fade_count() ) {
      iAlpha = MAX_TRANS_VALUE - (MAX_TRANS_VALUE * iCount) / iTotalTime;
      draw_lit_sprite (screen, bmpOriginal, iX, iY, iAlpha);
   }
   draw_sprite (screen, bmpOriginal, iX, iY);
}


// Fade de salida (de imagen a color)
void fade_to_color (BITMAP *bmpOriginal, int iTotalTime, int iX, int iY, int iColour) {
   int iAlpha;
   int iCount;

   set_trans_blender (getr (iColour), getg (iColour), getb (iColour), 0);
   clear_fade_count();
   for (iCount = 0; iCount < iTotalTime; iCount = return_fade_count() ) {
      iAlpha = (MAX_TRANS_VALUE * iCount) / iTotalTime;
      draw_lit_sprite (screen, bmpOriginal, iX, iY, iAlpha);
   }
   draw_lit_sprite (screen, bmpOriginal, iX, iY, 255);
}


// Entra la musica con fade
void fade_music_in(int iTotalTime) {
   int iCount;
   int iVolume;

   clear_fade_count();
   for (iCount= 0; iCount< iTotalTime; iCount= return_fade_count()) {
      iVolume= (MAX_VOLUME_VALUE*iCount)/iTotalTime;
      FSOUND_SetVolume(FSOUND_ALL, iVolume);
   }
   FSOUND_SetVolume(FSOUND_ALL, MAX_VOLUME_VALUE);
}


// Sale la musica con fade
void fade_music_out(int iTotalTime) {
   int iCount;
   int iVolume;

   clear_fade_count();
   for (iCount= 0; iCount< iTotalTime; iCount= return_fade_count()) {
      iVolume= MAX_VOLUME_VALUE -(MAX_TRANS_VALUE*iCount)/iTotalTime;
      FSOUND_SetVolume(FSOUND_ALL, iVolume);
   }
   FSOUND_SetVolume(FSOUND_ALL, 0);
}


// Entra la musica y la imagen con fade
void fade_media_in (BITMAP *bmpOriginal, int iTotalTime, int iX, int iY, int iColour) {
   int iCount;
   int iAlpha;
   int iVolume;

   set_trans_blender (getr (iColour), getg (iColour), getb (iColour), 0);
   clear_fade_count();
   for (iCount = 0; iCount < iTotalTime; iCount = return_fade_count() ) {
      // La parte de la imagen
      iAlpha = MAX_TRANS_VALUE - (MAX_TRANS_VALUE * iCount) / iTotalTime;
      draw_lit_sprite (screen, bmpOriginal, iX, iY, iAlpha);
      // La parte del sonido
      iVolume= (MAX_VOLUME_VALUE*iCount)/iTotalTime;
      FSOUND_SetVolume(FSOUND_ALL, iVolume);
   }
   draw_sprite (screen, bmpOriginal, iX, iY);
   FSOUND_SetVolume(FSOUND_ALL, MAX_VOLUME_VALUE);
}


// Sale la musica y la imagen con fade
void fade_media_out (BITMAP *bmpOriginal, int iTotalTime, int iX, int iY, int iColour) {
   int iAlpha;
   int iCount;
   int iVolume;

   set_trans_blender (getr (iColour), getg (iColour), getb (iColour), 0);
   clear_fade_count();
   for (iCount = 0; iCount < iTotalTime; iCount = return_fade_count() ) {
      // La parte de la imagen
      iAlpha = (MAX_TRANS_VALUE * iCount) / iTotalTime;
      draw_lit_sprite (screen, bmpOriginal, iX, iY, iAlpha);
      // La parte del sonido
      iVolume= MAX_VOLUME_VALUE -(MAX_TRANS_VALUE*iCount)/iTotalTime;
      FSOUND_SetVolume(FSOUND_ALL, iVolume);
   }
   //vsync();
   draw_lit_sprite (screen, bmpOriginal, iX, iY, 255);
   FSOUND_SetVolume(FSOUND_ALL, 0);
}

