#ifndef UTIL_H
#define UTIL_H
#include <allegro.h>
#include <string>
#include <sstream>
using namespace std;
namespace sd
{
class Util
{
public:
	// Helper function, from acc forums, Dustin Dettmer
	template<typename T>
	static string to_string(const T &value)
	{
		ostringstream ret;
		ret << value;
		return ret.str();
	}

	//256 for whole pallete , 1 for one colour etc
	static void copy_palette(RGB *palto, RGB *palfrom, int number)
	{
		int looper = 0;
		while(looper < number)
		{
		palto[looper] = palfrom[looper];
		looper++;
		}
	}

		//is gonna be slow as hell on slower comps
	static void fade_screen_hc(BITMAP *image)
	{
		BITMAP *speed_up;
		int index = 0;
		//See if screws up somehow
		if(!(speed_up =  create_bitmap(640,480)))
			return;

		blit(image,speed_up,0,0,0,0,640,480);
		blit(speed_up,screen,0,0,0,0,speed_up->w,speed_up->h);
		set_trans_blender(256/30,256/30,256/30,256/30);
		drawing_mode(DRAW_MODE_TRANS,NULL,NULL,NULL); //Sets draw_mode to trans
		while(index < 30)
		{
			  rectfill(speed_up,0,0,639,479,makecol(0,0,0));
			  blit(speed_up,screen,0,0,0,0,speed_up->w,speed_up->h);
			  index++;
			  rest(10);
		}
		destroy_bitmap(speed_up);
		set_trans_blender(128,128,128,128);
		return;
	}
	//Optmized a little, so wont lag on slower comps
	static void fade_in_hc(BITMAP *image)
	{
	BITMAP *speed_up;
	int index = 0;
	//See if screws up somehow
	if(!(speed_up =  create_bitmap(640,480)))
		return;
	index = 1;
	  while(index < 240)
	   {
				  blit(image,speed_up,0,0,0,0,speed_up->w,speed_up->h);
	//    set_trans_blender(255/index,255/index,255/index,255/index);
		  set_trans_blender(255- index,255 -index,255 - index,255 - index);
		  drawing_mode(DRAW_MODE_TRANS,NULL,NULL,NULL); //Sets draw_mode to trans
		  rectfill(speed_up,0,0,screen->w,screen->h,makecol(0,0,0));
		  blit(speed_up,screen,0,0,0,0,speed_up->w,speed_up->h);
		  index  +=4;
		  rest(20);
		
	   }
	destroy_bitmap(speed_up);
	set_trans_blender(128,128,128,128);
	return ;
	}
};
}
#endif
