#ifndef TILESET_H
#define TILESET_H
#include "TileRipper.h"
using namespace std;

namespace sd
{
class Tileset
{
private:
	bool bInit;
	vector<BITMAP *> tImage; // The tiles
	TileRipper *ripper;
	string imageName;
	//Width and height of tiles... currenty for this iteration of code
	//bound to one width and one height per tileset.
	int width;
	int height;
	//
	int numTiles; // Total number of tiles 
protected:
public:
	Tileset();
	Tileset(string filename, TileRipper* ripper);
	Tileset(TileRipper* ripper);
	~Tileset();
	TileRipper* getRipper();
	bool status();
	void setRipper(TileRipper* ripper);
	int getTileWidth();
	int getTileHeight();
	int getNumTiles();
	BITMAP * getTile(int index);
	bool loadTileset(string fileName);
};
}
#endif
