#include <allegro.h>
#include <string>
#include <map>
#include <vector>
#include "SpriteLoaderXML.h"
#include "GridTileRipper.h"

using namespace std;
using namespace sd;
bool SpriteLoaderXML::loadSprite(Sprite *sprite, string fileName) 
{
	
	bool status = false;
	//LoadXML Document
	TiXmlDocument doc(fileName);
	doc.LoadFile();
	//Get root
	TiXmlElement* root = doc.RootElement();
	if ( root )
	{
		/*
		if(!root->FirstChildElement("SpriteAnimation"))
		{
			return false;
		}*/
	
		//Now load sprite information
		//For now we require in same order
		//in future switch to xpath
		TiXmlElement *nSprite = root->FirstChildElement();
		TiXmlElement *animations = nSprite->NextSiblingElement();
		//Now load sprite information
		string tileRipperType = nSprite->Attribute("type");
		TileRipper *ripper = (TileRipper *)new GridTileRipper(atoi((nSprite->Attribute("width"))),atoi(nSprite->Attribute("height")),atoi(nSprite->Attribute("type_numx")),atoi(nSprite->Attribute("type_numy")));

		

		string imageName = nSprite->Attribute("fileName");
		Tileset *tileset = new Tileset(imageName,ripper);
		if(!tileset->status())
		{
			return false;
		}
		sprite->setTileset(tileset);
		TiXmlElement *anim = animations->FirstChildElement();
		while(anim!=NULL)
		{
			Animation *a = new Animation(anim->Attribute("name"),0);
			sprite->addAnimation(a);
			TiXmlElement* frame = anim->FirstChildElement();
			while(frame != NULL)
			{
				a->addFrame(new AnimFrame(atoi(frame->Attribute("num")),atoi(frame->Attribute("delay"))));
				frame = frame->NextSiblingElement();		
			}
			anim = anim->NextSiblingElement();
		}
	}
	status = true;

	return status;
	
}

