#include <string>
#include <vector>
#include <map>
#include <allegro.h>
#include "Sprite.h"
#include "SpriteLoaderXML.h"
using namespace std;
using namespace sd;


bool Sprite::initialized()
{
	return bInit;
}


Sprite::Sprite()
{
	init();
	
}

//Create a blank sprite
Sprite::Sprite(Tileset* tileset)
{
	init();
	setTileset(tileset);
}

Sprite::~Sprite()
{
	if(tileset != NULL)
		delete tileset;

	//Have to use iterators....
	 for (map<string,Animation*>::iterator it = animations.begin();
        it != animations.end(); ++it) 
	 {
		 delete it->second;
	 }

}


Sprite::Sprite(string path)
{
	init();
	loadSprite(path);
}

void Sprite::init()
{
	x = 0;
	y = 0;
	curAnim = NULL;
	tileset = NULL;
	bInit = false;
}

//Loads the xml here!
bool Sprite::loadSprite(string path)
{
	
	bInit = SpriteLoaderXML::loadSprite(this,path);
	return bInit;
	
}



void Sprite::setTileset(Tileset * tileset)
{
	if(tileset != NULL)
	{
		this->tileset = tileset;
		bInit = true;
	}
}

BITMAP* Sprite::getImage()
{
	
	if(bInit)
	{
		if(curAnim!=NULL)
		{
			curAnim->update(); //Update before attempting retrival
			if(curAnim->getFrame() >= 0 && curAnim->getFrame() < tileset->getNumTiles())
			{
				return tileset->getTile(curAnim->getFrame());
			}
		}
	}
	//If we did not escape earlier, error
	return NULL;
}

void Sprite::addAnimation(Animation *anim)
{
	//Can only add it if no same name exists...
	if(animations.find(anim->getName()) == animations.end())
	{
		animations[anim->getName()] = anim;
	}
}
int Sprite::numAnimations()
{
	return animations.size();
}


void Sprite::setAnimation(string name)
{
	if(animations.find(name) == animations.end())
	{
		curAnim = NULL;
	}
	else
	{
		curAnim = animations[name];
		curAnim->reset();
	}
	
}

int Sprite::getX()
{
	return x;
}
int Sprite::getY()
{
	return y;
}
void Sprite::setY(int y)
{
	this->y = y;
}
void Sprite::setX(int x)
{
	this->x = x;
}