#define _CRT_SECURE_NO_WARNINGS
#include <string>
#include <vector>
#include <string>
#include <stdio.h>
#include <allegro.h>
#include "GridTileRipper.h"
#include "Map.h"
using namespace sd;
using namespace std;

Map::Map(string mapName)
{
	camerax = 0;
	cameray = 0;
	bInit = false;
	tileset = NULL;
	map_data = NULL;
	loadMap(mapName);
}

Map::~Map()
{
	unloadMap();
}

void Map::unloadMap()
{
	if(tileset != NULL)
	{
		delete tileset;
		tileset= NULL;
	}
	if(map_data != NULL)
	{
		delete [] map_data;
		map_data = NULL;
	}
	bInit = false;
}

bool Map::loadMap(string mapName)
{
	FILE *fp;
	int looperx = 0;
	int loopery = 0;
	camerax = 0;
    cameray = 0;	
     //Loads File
	if((fp = fopen(mapName.c_str(),"rb")))
	{
		fgetc(fp);
		fgetc(fp);
		fgetc(fp);
		fgetc(fp);
		x = fgetc(fp);
        y = fgetc(fp);//fread(&(x),sizeof(char),1,fp);
		//fread(&(y),sizeof(char),1,fp);
		fread(&(image_name),sizeof(char),15,fp);
		map_data = new unsigned char[x*y];//malloc(sizeof(unsigned char)*x*y);
        for(loopery = 0;loopery< y;loopery++)
			for(looperx = 0;looperx <x;looperx++)
			{
				fread(&(map_data[looperx +loopery*x]),sizeof(unsigned char),1,fp);
			}
		//Loads Tile Characteristics
		
		tileset = new Tileset(image_name, (TileRipper *)new GridTileRipper(32,32,10,10));
		/*for(looperx =0; looperx< 100;looperx++)
			fread(&(tileset->tiles[looperx].data),sizeof(char),1,fp);*/	
		fclose(fp);
	}
	return bInit;
}

void Map::moveCamera(int x, int y)
{
	camerax = x;
	cameray = y;
}

void Map::drawMap(BITMAP *dest,int xoffset,int yoffset,int width, int height)
{
	int looperx;
	int loopery;
	for(looperx= -1;looperx<width/32+1;looperx++)
	{
		for(loopery=-1;loopery<height/32+1;loopery++)
		{	
			if(camerax/32 + looperx > -1 && camerax/32 + looperx < x && cameray/32+loopery <y && cameray/32+loopery > -1)
			{
				if(camerax/32+cameray/32*x +looperx + loopery *x < y*x && camerax/32+cameray/32*x +looperx + loopery *x >-1)
				{
					blit(tileset->getTile(map_data[camerax/32+cameray/32*x +looperx + loopery *x]),dest,0,0, xoffset-camerax %32+looperx*32,yoffset-cameray%32 +loopery*32,32,32);
				}
			}
		}//Endlooperx
	}//Endloopery

}

int Map::getHeight()
{
	return this->y*32;
}

int Map::getTile(int x,int y)
{
	return map_data[(y*this->x)+x];
}
