#include <allegro.h>
#include "GridTileRipper.h"
using namespace sd;
	
GridTileRipper::GridTileRipper(int tilew,int tileh,int numx,int numy)
{
	setUpRipper(tilew,tileh,numx,numy);
}

GridTileRipper::~GridTileRipper()
{
	clearImage();
}
void GridTileRipper::clearImage() 
{
	if(image != NULL)
		delete image;
	image = NULL;
	bInit = false;

}

int GridTileRipper::getNumTiles() 
{
	if(bInit == true)
	{
		return numTiles;
	}
	else
	{
		return -1;
	}
}

BITMAP * GridTileRipper::getTile(int tilenum) 
{
	if(bInit != true)
		return NULL;
	BITMAP * tImage = create_bitmap(tileWidth, tileHeight);
	blit(image,tImage,1+ (tilenum % numX) * (tileWidth+1),1 +(tilenum/numX)*(tileHeight+1),0,0,tileWidth,tileHeight);
	return tImage;
}

int GridTileRipper::getTileHeight() {
	
	if(bInit == true)
	{
		return tileHeight;
	}
	else
	{
		return -1;
	}
}

int GridTileRipper::getTileWidth() 
{
	if(bInit == true)
	{
		return tileWidth;
	}
	else
	{
		return -1;
	}
}

void GridTileRipper::setImage(BITMAP * image) 
{
	if(tileHeight == 0 || tileWidth == 0)
	{
		//throw new RuntimeException("Tile Width/Height not Set, Unable to set Image!");
		return;
	}
	
	/*//This means we have to calculate Num Tiles on our won
	if(numX == 0 || numY == 0)
	{
		if(image.getHeight() == -1 || image.getWidth()== -1)
		{
			//throw new RuntimeException("Image not loaded Properly!");
		}
		else if( (image.getHeight() % (tileHeight + 1)) != 1 && (image.getWidth() % (tileWidth + 1))!= 1)
		{
			throw new RuntimeException("Unable to auto detect number of tiles! (Grid)");
			
		}
		
			numY = (image.getHeight()-1)/ (tileHeight+1);
			numX = (image.getWidth()-1) / (tileWidth+1);
			
	}*/
		numTiles = numX * numY;
		this->image = image;
		bInit = true;
	
}

bool GridTileRipper::setUpRipper(int tilew, int tileh, int numx, int numy) 
{
	if(!setUpRipper(tilew,tileh))
		return false;
	this->numX = numx;
	this->numY = numy;
	return true;
}

bool GridTileRipper::setUpRipper(int tilew, int tileh) 
{
		//Make sure valid dimensions
		if(tilew > 0 && tilew <= 256 && tileh > 0 && tileh<=256)
		{
			tileWidth = tilew;
			tileHeight = tileh;
			//Make so its blank for now...
			numX = 0;
			numY = 0;
			return true;
		}
		return false;
}
