#ifndef GAMETIMER_H
#define GAMETIMER_H

namespace sd
{
	class GameTimer
	{
		private:
			//Static members
			static volatile unsigned long counter;
			static void increment_counter(void);
			static bool installed_counter;
			
			
			//Non static
			unsigned long time_counter;
			unsigned long diff;
			bool paused;

			unsigned long fps_counter;
			unsigned long fps_count;
			unsigned long last_fps_count;

			

		public:
			static bool installed_counter_status();
			static bool install_counter();
			
			GameTimer(){}
			~GameTimer(){}
			void reset();
			void pause();
			void unPause();
			bool logic();
			void doLogic();
			
			//FOR FPS
			void updateFPS(int increment = 1);
			int lastFPS();
			
			

	};
}
#endif
