//Base Class
#include <allegro.h>
#include "GameTimer.h"

using namespace sd;
//Intialize some values
////////////////////////////////////

volatile unsigned long GameTimer::counter = 0;
bool GameTimer::installed_counter = false;

//Static members
////////////////////////////////////
//Increments Speed Counter By One
void sd::GameTimer::increment_counter(void)
{
	counter++;
}
END_OF_FUNCTION(GameTimer::increment_counter()); //Tell Allegro at end of function

//Installs counter if not already done so
bool GameTimer::install_counter()
{
	//TODO: Fix hardcode
	int speed = 60;

	//Counter Stuff
	LOCK_VARIABLE(speed_counter);
	LOCK_FUNCTION(increment_speed_counter);

	installed_counter = true;

	//Error checking
	if(install_int_ex(GameTimer::increment_counter,BPS_TO_TIMER(speed)))
		installed_counter = false;

    return installed_counter;
}

bool GameTimer::installed_counter_status()
{
	return installed_counter;
}


//Public members
////////////////////////////////////
void GameTimer::reset()
{
	time_counter = counter;
	fps_counter = counter;
}
void GameTimer::pause()
{
	if(!paused)
	{
		paused = true;
		diff = counter - time_counter;
	}
}
void GameTimer::unPause()
{
	if(paused)
	{
		paused = false;
		time_counter = counter - diff;
	}
}

bool GameTimer::logic()
{
	if(time_counter < counter)
	{
		return true;
	}
	return false;
}

void GameTimer::doLogic()
{
	time_counter++;
}

int GameTimer::lastFPS()
{
	updateFPS(0);
	return last_fps_count;
}

void GameTimer::updateFPS(int increment)
{
	if(counter - fps_counter < 60)
	{
		fps_count+=increment;
	}
	else
	{
		fps_count+=increment;
		last_fps_count = fps_count;
		fps_counter = counter;
		fps_count = 0;
	}
}

