#include <vector>
#include <string>
#include <allegro.h>
#include "Animation.h"
using namespace std;
using namespace sd;
	

//FPS
STimer *Animation::timer =  NULL; //TODO:Fix memory leak here!
int Animation::fps  = 60; //60 By default
long Animation::fpsTime =  1;


void Animation::setTimer(STimer *st)
{
	timer = st;
}
int Animation::getFPS()
{
	return fps;
}

bool Animation::setFPS(int fps)
{
	//FPS must be between 1 and 100
	if(fps > 0 && fps < 101)
	{
		Animation::fps = fps;
		Animation::fpsTime = 1000000000 / fps;
		return false;
	}
	return true;
}




vector<AnimFrame*> * Animation::getAnimFrames()
{
	return &frames;
}


int Animation::getDelayType()
{
	return delayUnit;
}

Animation::Animation(string name, int delayUnit)
{
	//frames = new vector<AnimFrame>();
	curFrame = NULL;
	this->name = name;
	this->delayUnit = delayUnit;
	totalDelay = 0;
	reset();
}

Animation::~Animation()
{
	for(unsigned int i = 0; i < frames.size();i++)
	{
		delete frames[i];
	}
}

int Animation::getNumFrames()
{
	return frames.size();
}

void Animation::setName(string name)
{
	this->name = name;
}
string Animation::getName()
{
	return name;
}
//Adds to rear...
void Animation::addFrame(AnimFrame *frame)
{
	frames.push_back(frame);
	totalDelay += frame->getDelay();
}

//Inserts in certain position
//Have to use iterators
/*void Animation::addFrame(AnimFrame *frame, int index)
{
	frames.insert(index, frame);
	totalDelay+=frame->getDelay();
}*/

/*void Animation::removeFrame(int index)
{
	totalDelay-= frames[index]->getDelay();
	frames.erase(index);
}*/


void Animation::setAnimFrameDelay(int index, long delay)
{
	totalDelay -= frames[index]->getDelay();
	frames[index]->setDelay(delay);
	totalDelay += frames[index]->getDelay();
}



void Animation::reset()
{
	if(delayUnit == DELAY_FPS)
	{
		timer->reset();
		//delayOffset= timer.getTime(totalDelay, STimer.TIME_NS);
	}
	/*else if(delayUnit == DELAY_MS)
	{
		timer.reset();
		//delayOffset = timer.getTime(totalDelay, STimer.TIME_MS);
	}
	else if(delayUnit == DELAY_NS)
	{
		timer.reset();
		//delayOffset = timer.getTime(totalDelay, STimer.TIME_NS);
	}*/
	
		update(); //For now we will update internally...
				  //May be a good idea to move outside
	
}

//This function is called everytime the animation needs to be updated...
void Animation::update()
{
	curDelay = timer->getTime(totalDelay*fpsTime, 0)/fpsTime;
	setFrame();
}

long Animation::getFrameDelay()
{
	if(curFrame == NULL)
	{
		return -1;
	}
	return curFrame->getDelay();
}

long Animation::getFrameDelay(int index)
{
	return frames[index]->getDelay();
}

AnimFrame* Animation::getAnimFrame(int index)
{
	return frames[index];
}

int Animation::getFrame()
{
	if(curFrame == NULL)
	{
		return -1;
	}
	return curFrame->getImageIndex();
}

int Animation::getFrame(int index)
{
	return frames[index]->getImageIndex();
}
void Animation::setFrame()
{
	//ListIterator<AnimFrame> itr = frames.listIterator();
	//itr.
	curFrame = NULL;
	long delay = 0;
	for(unsigned int i = 0; i < frames.size();i++)
	{
		delay+=frames[i]->getDelay();
		if(delay > curDelay)
		{
			curFrame = frames[i];
			break;
		}
			
	}
}

