#include <allegro.h>
#include <vector>
#include <string>
#include "Tileset.h"
using namespace sd;
using namespace std;

//The Constructors
Tileset::Tileset()
{
	bInit = false;
}


Tileset::Tileset(TileRipper *ripper)
{
	setRipper(ripper);
}

Tileset::~Tileset()
{
	if(ripper != NULL)
	{
		delete ripper;
	}
	for(unsigned int i = 0; i < tImage.size(); i++)
	{
		destroy_bitmap(tImage[i]);
	}
}

Tileset::Tileset(string filename, TileRipper *ripper)
{
	
	setRipper(ripper);
	loadTileset(filename);
}

TileRipper* Tileset::getRipper()
{
	return ripper;
}

bool Tileset::status()
{
	return bInit;
}

//This is to set the tile ripper, creates the tiles for the tileset
//Only really kicks in when loadTileset is called
void Tileset::setRipper(TileRipper* ripper)
{
	if(ripper != NULL)
		this->ripper = ripper;
}


int Tileset::getTileWidth()
{
	if(bInit)
	{
		return width;
	}
	else
	{
		return -1;
	}
}
int Tileset::getTileHeight()
{

	if(bInit)
	{
		return height;
	}
	else
	{
		return -1;
	}
}

int Tileset::getNumTiles()
{
	if(bInit)
	{
		return numTiles;
	}
	else
	{
		return -1;
	}	
}

BITMAP * Tileset::getTile(int index)
{
	if(index >= 0 && index < numTiles)
	{
		return tImage[index];
	}
	else
	{
		return NULL;
	}
}

//Generic Load tileset, takes xml info and loads image set.
bool Tileset::loadTileset(string fileName)
{
	//When loadTileset is called, the old tileset is removed......
	bInit = false;
	//Quick Error Checking
	if(ripper == NULL)
		return bInit;
	
	//So that we have same colour as the desktop, will need to move around code later to ensure works for fullscreen
	//GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
	BITMAP * tilesetImage;
	tilesetImage = load_bitmap(fileName.c_str(),NULL);
	if(! tilesetImage)
	{
		return bInit;
	}
	ripper->setImage(tilesetImage);
	this->imageName = fileName;
	this->numTiles = ripper->getNumTiles();
	this->width = ripper->getTileWidth();
	this->height = ripper->getTileHeight();
		
	//Populate tiles
	for(int looper = 0; looper < this->numTiles;looper++)
	{
		tImage.push_back(ripper->getTile(looper));
	}
	
	bInit = true;
	return bInit;

}





