#ifndef SPRITE_H
#define SPRITE_H
#include "Animation.h"
#include "Tileset.h"
using namespace std;

namespace sd
{
class Sprite
{
private:
	//int standardDelayUnit;
	bool bInit;
	void init();
	int x;
	int y;
	
protected:
	map <string,Animation *> animations;
	Tileset *tileset; //Contains all images for sprite...
	Animation *curAnim;

public:
	bool initialized();
	Sprite();
	Sprite(Tileset* tileset);
	Sprite(string path);
	~Sprite();
	bool loadSprite(string path);
	void setTileset(Tileset* tileset);
	BITMAP* getImage();
	void addAnimation(Animation *anim);
	int numAnimations();
	///void setAnimation(usigint index);
	void setAnimation(string name);
	void setX(int x);
	void setY(int y);
	int getX();
	int getY();
};
}
#endif
