#ifndef GRID_TILE_RIPPER_H
#define GRID_TILE_RIPPER_H
#include "TileRipper.h"
namespace sd
{

//This is the ripper class, it will automatically extract tiles from a tileset
class GridTileRipper : TileRipper
{
private:
	BITMAP* image;
	int tileWidth;
	int tileHeight;
	int numX;
	int numY;
	int numTiles;
	bool bInit;

public:
	GridTileRipper(int tilew,int tileh);
	GridTileRipper(int tilew,int tileh,int numx,int numy);
	~GridTileRipper();
	bool setUpRipper(int tilew, int tileh, int numx, int numy);
	bool setUpRipper(int tilew, int tileh);
	void setImage(BITMAP * image);
	
	//Free up
	void clearImage();
	
	//Usefull functions
	BITMAP * getTile(int tilenum);
	int getTileWidth();
	int getTileHeight();
	int getNumTiles();
	//virtual String getName();
	
	//extra functions
//	public int getNumX();
//	public int getNumY();
	
	//for identfication
	//perhaps in future dynamically detect and store class name?
	
	
	
};
}
#endif
