#include <list>
#include <vector>
#include <map>
#include <string>
#include <allegro.h>
#include "Game.h"
#include "FireParticle.h"
using namespace std;
using namespace sd;

Game::Game():m("test.map"),player("player.xml")//,f(64,64,0,255)
{
	gt.install_counter();
	buffer = create_bitmap(640,480);
	player.setAnimation("Down");
	player.setX((640-16)/2);
	player.setY(32*8);
	cx = 0;
	cy = 0;
	curDir = 0;
	collision_timer =0;
	life = 10;
	rotation = 0;
	crash = load_sample("crash.wav");
	f = load_font("tinsfont.pcx",NULL,NULL);
}




void Game::drawGame()
{
		m.drawMap(buffer,0,0,640,480);
		
		//f.draw_fire(buffer,200,200);
		pm.draw(buffer);
		if(player.getImage() != NULL)
		{
			if(rotation)
			{
				rotate_sprite(buffer,player.getImage(),player.getX(),player.getY(),itofix(rotation));
			}
			else
			{
					draw_sprite(buffer,player.getImage(),player.getX(),player.getY());
			}
		}
		textprintf_ex(buffer,f,0,0,makecol(255,255,255),-1,"Health: %d%%",life*10);
		textprintf_ex(buffer, f, buffer->w-150, 0, makecol(255, 255, 255),
			-1, "FPS: %d",gt.lastFPS() );
		

		blit(buffer,screen,0,0,0,0,buffer->w,buffer->h);
}

void Game::updateGame()
{

	
	if(key[KEY_RIGHT])
	{
		if(curDir != 1)
		{
			player.setAnimation("Right");	
			curDir = 1;
		}
		player.setX(player.getX()+ 8);
		if(player.getX() >= 640-32*5)
		{
			player.setX(640-32*5);
		}
		
		
	}
	else if(key[KEY_LEFT])
	{
		if(curDir != 2)
		{
			player.setAnimation("Left");
			curDir = 2;
		}
		player.setX(player.getX()- 8);
		if(player.getX() <= 32*4)
		{
			player.setX(32*4);
		}
		
	}
	else 
	{
		if(curDir != 0)
		{
			player.setAnimation("Down");
			curDir = 0;
		}
		
	}
	pm.addParticle(new Particle(player.getX()+8,player.getY()));
	m.moveCamera(cx,cy);
	//f.update_fire();

	//Really Shit Collision Detection here, later I'll actually think this out...
	if(collision_timer == 0)
	{
		if((player.getX()) %32) // 4 tiles to check
		{
			if( m.getTile( player.getX()/32,(player.getY()+cy)/32) > 94 || m.getTile(player.getX()/32,(player.getY()+cy)/32 +1) > 94)
			{
				collision_timer = 32;
				life--;
				pm.addParticle((Particle *)new FireParticle(player.getX()-16,player.getY()));
				play_sample(crash,255,0,1000,0);
			}
			else if(m.getTile(player.getX()/32 +1,(player.getY()+cy)/32) > 94 ||m.getTile(player.getX()/32 +1,(player.getY()+cy)/32 +1) > 94)
			{
				collision_timer = 32;
				life--;
				pm.addParticle((Particle *)new FireParticle(player.getX()-16,player.getY()));
				play_sample(crash,255,0,1000,0);
			}
		}
		else//two tiles to check
		{
			if(m.getTile(player.getX()/32,(player.getY()+cy)/32) > 94 ||m.getTile(player.getX()/32,(player.getY()+cy)/32 +1) > 94)
			{
				collision_timer = 32;
				life--;
				pm.addParticle((Particle *)new FireParticle(player.getX()-16,player.getY()));
				play_sample(crash,255,0,1000,0);
			}
		}
	}

	if(collision_timer)
	{
		collision_timer--;
		rotation+=8;
		if(collision_timer ==0)
		{
			rotation = 0;
		}
	}

}
void Game::startGame()
{
	
	
	gt.reset();
	while(!key[KEY_ESC])
	{
		if(gt.logic())
		{
			updateGame();
			gt.doLogic();
			pm.update();
			cy+=4;
			if(cy >= m.getHeight() - 480)//Game Won
			{
				cy = m.getHeight()-481;
				 textout_centre_ex(screen, f, "YOU WIN!",
                        SCREEN_W / 2, SCREEN_H / 2,
                        makecol(255, 0, 0), -1);
				  rest(2000);
				break;
			}
			else if(life == 0)//Game Over
			{
				textout_centre_ex(screen, f, "YOU LOSE!",
                        SCREEN_W / 2, SCREEN_H / 2,
                        makecol(255, 255, 255), -1);
				rest(2000);								
				break;
			}
		}
		else
		{
			drawGame();
			gt.updateFPS();
			
		}
			
	}

	/*rest(10);
	for(int i = 0; i < 10;i++)
	{
		for(int j = 0; j<10; j++)
		{
			//allegro_message("%d",i*10+j);
			draw_sprite(screen,t.getTile(i*10+j),j*32,i*32);
		}
	}
	rest(2000);
	return 0;	*/
}

Game::~Game()
{
	destroy_bitmap(buffer);
	destroy_sample(crash);
	destroy_font(f);
}
