#include <allegro.h>
#include "Fire.h"
#include "Util.h"
using namespace sd;

Fire::Fire(int width,int height, int colorstart,int colorend,RGB*p)
{
	create_fire(width,height, colorstart, colorend,p);
}

void Fire::create_fire(int width,int height, int colorstart,int colorend,RGB *p)
{
	if(p!=NULL)
	{
		Util::copy_palette(this->pal,p,256);
	}
	else
	{
		for(int index=0;index<64;index++)
		{
			pal[index].r = index;
			pal[index].g= 0;
			pal[index].b = 0;
			
			pal[index+64].r = 63;
			pal[index+64].g = index;
			pal[index+64].b = 0;
			
			pal[index+128].r = 63;
			pal[index+128].g = 63;
			pal[index+128].b = index;
			
			pal[index+192].r = 63;
			pal[index+192].g = 63;
			pal[index+192].b = 63;
			
		 }
	}
	this->width = width;
	this->height = height;
	//The Colour Choices Allows Us to have restricted Colors :)
	this->color_start = colorstart;
	this->color_end = colorend;
	this->num_colors = (colorend - colorstart) + 1;
	this->x_increase = this->width /10;
	this->color_bright = ((this->num_colors) / 1.7f);
	this->color_speed = (float)this->num_colors / (float)height;
	//Now Let Us Allocate Memory 
	this->bitmap = create_bitmap_ex(8,width,height+1);
	clear_bitmap(bitmap);
	//Error Checking
	if(!this->bitmap)
	{
		allegro_message("wtf");
		//return NULL;
	}
	this->fire_disp = create_sub_bitmap(this->bitmap,0,0,width,height);
	if(!this->fire_disp)
	{
	//	return NULL;
	}
}

Fire::~Fire()
{
	destroy_fire();
}

void Fire::destroy_fire()
{
 destroy_bitmap(this->fire_disp); //Destroy Sub-bitmap
 destroy_bitmap(this->bitmap);    //Destroy Actual Image
}

//blits the fire
void Fire::draw_fire(BITMAP *bmp,int x, int y)
{
	//Will Modify later to allow for more options
	select_palette(this->pal);
	draw_sprite(bmp,fire_disp,x,y);
}

void Fire::update_fire()
{

int x;  //Current x co-ordinate
int y;  //Current y co-ordinate
int col;//Current Colour
drawing_mode(DRAW_MODE_SOLID,NULL,NULL,NULL); //Sets draw_mode to trans 
x = x_increase;
    do
    {
    x = x + rand() %(x_increase)+1;
     if(x  > width - 1)
        x = (width - 1); //'Check we don't go off the edge
        putpixel(bitmap,x, height - 1, rand()%(color_end-color_bright)+color_start + color_bright);//   'Set pixel with a random colour
        }while(x < (width - 1));
		//}while(x < (width - x_increase));
     for(x=0; x<width;x++)
     {
//To Change most of the effects, change end y = - varibale
//-2 sucks, -1 is perfect, and 0 is a cool effect
      for(y=0; y<(height-1);y++)
        {
            if(x > 0 && x < width)
                {
                col = getpixel(bitmap,x-1,y+1); //     'Average out the pixels
                col = col + getpixel(bitmap,x,y+1);//F(X, Y + 1)
                col = col + getpixel(bitmap,x+1,y+1);//F(X + 1, Y + 1)
                col = col + getpixel(bitmap,x,y+2);//F(X, Y + 2)
                col = (col / 4);
            //Is the sprite smaller than the number of colors?
                if(color_speed > 1)
                col = col - (int)color_speed;
//Modify This to support variable sizes   col = (col / 4) - 1;
                }
            if(x == 0)
              col = getpixel(bitmap,x+1,y)/2;

            if(x == width)
              col = getpixel(bitmap,x-1,y)/2;

            if(col < 0)
             col = 0;

            putpixel(bitmap,x,y,col);
      }//End X loop
     }//End y loop
}