#ifndef ANIMATION_H
#define ANIMATION_H
#include "AnimFrame.h"
#include "AllegroTimer.h"
using namespace std;
namespace sd
{
	class Animation
	{
	private:
		static  STimer *timer;
		static int fps;
		static long fpsTime;
		

		string name;
		AnimFrame *curFrame;	
		long delayOffset;
		int delayUnit;
		long curDelay;

		//void convertDelay(int delayUnit);
		void setFrame();
		

	protected:
		vector <AnimFrame*> frames;
		long totalDelay;
	
	public:
		//Possible values for DelayUnit
		//Perhaps later replace these with matching arrays
		//And have classes added in 3rd array to handle timing
		//To be yet even more generic
		//As hardcoding this is rather ugly
		static const int DELAY_FPS = 0; // Only FPS supported for now
		static int getFPS();
		static bool setFPS(int fps);
		static void setTimer(STimer *st);
		//static public final int DELAY_MS = 1;
		//static public final int DELAY_NS = 2;
		//static public const char sDelayFPS = "Delay FPS";
		//static public String sDelayMS = "Delay Millisecond";
		//static public String sDelayNS = "Delay Nanosecond";
		//public static int getDelayType(String type)
		//public static String getDelayType(int type)
		vector <AnimFrame*>* getAnimFrames();
		int getNumFrames();
		int getDelayType();
		void setName(string name);
		string getName();
		void addFrame(AnimFrame *frame);
		//void addFrame(AnimFrame *frame, int index);
		//void removeFrame(int index);
		//void setDelayUnit(int delayUnit);
		void setAnimFrameDelay(int index, long delay);
		void reset();
		void update();
		long getFrameDelay();
		long getFrameDelay(int index);
		AnimFrame* getAnimFrame(int index);
		int getFrame();
		int getFrame(int index);
		Animation(string name, int delayUnit);
		~Animation();
	};
}
#endif
