#ifndef ALLEGROTIMER_H
#define ALLEGROTIMER_H

//Base Class
#include "STimer.h"

namespace sd
{
	class AllegroTimer : public STimer
	{
		private:
			//Static members
			static volatile unsigned long counter;
			static void increment_counter(void);
			static bool installed_counter;
			static bool install_counter(void);
			
			//Non static
			unsigned long time_counter;
			unsigned long diff;
			bool paused;

		public:
			//static const TIME_BPS_60 = 0x01;

			static bool installed_counter_status();
			
			AllegroTimer()
			{
				if(!installed_counter)
				{
					install_counter();
				}
				time_counter = counter;
			}
			~AllegroTimer(){}
			void reset();
			void pause();
			void unPause();
			long getTime(long timeMax,int unit);
			long timeSince(int unit);
			
			

	};
}
#endif
