//Base Class
#include <allegro.h>
#include "AllegroTimer.h"

//Intialize some values
////////////////////////////////////
volatile unsigned long sd::AllegroTimer::counter = 0;
bool sd::AllegroTimer::installed_counter = false;

//Static members
////////////////////////////////////
//Increments Speed Counter By One
void sd::AllegroTimer::increment_counter(void)
{
	counter++;
}
END_OF_FUNCTION(sd::AllegroTimer::increment_counter()); //Tell Allegro at end of function

//Installs counter if not already done so
bool sd::AllegroTimer::install_counter()
{
	//TODO: Fix hardcode
	int speed = 60;

	//Counter Stuff
	LOCK_VARIABLE(speed_counter);
	LOCK_FUNCTION(increment_speed_counter);

	installed_counter = true;

	//Error checking
	if(install_int_ex(sd::AllegroTimer::increment_counter,BPS_TO_TIMER(speed)))
		installed_counter = false;

    return installed_counter;
}

bool sd::AllegroTimer::installed_counter_status()
{
	return installed_counter;
}


//Public members
////////////////////////////////////
void sd::AllegroTimer::reset()
{
	time_counter = counter;
}
void sd::AllegroTimer::pause()
{
	if(!paused)
	{
		paused = true;
		diff = counter - time_counter;
	}
}
void sd::AllegroTimer::unPause()
{
	if(paused)
	{
		paused = false;
		time_counter = counter - diff;
	}
}
//Time up until max
long sd::AllegroTimer::getTime(long timeMax,int unit)
{
	if(timeMax ==0 )
	{
			return 0;
	}	
	return (counter - time_counter) % timeMax;

}
//Returns time since last call
long sd::AllegroTimer::timeSince(int unit)
{
		unsigned long calcTime =  (counter - time_counter);
		time_counter = counter; //Update clock for next update.....
		return calcTime;
}
			
