#define         alleg_mouse_unused       1
//         alleg_timer_unused
//         alleg_keyboard_unused
#define         alleg_joystick_unused     1
//         alleg_gfx_driver_unused
//         alleg_palette_unused
//         alleg_graphics_unused
//         alleg_vidmem_unused
//         alleg_flic_unused
#define         alleg_sound_unused        1
#define         alleg_file_unused           1
#define         alleg_datafile_unused      1
//         alleg_math_unused
#define         alleg_gui_unused          1

#include <time.h>
#include <random.h>
#include <string.h>
#include <allegro.h>

#define COS(A)  fixtof(fcos(itofix(A)))
#define SIN(A)  fixtof(fsin(itofix(A)))

#define N_TANKS 2
#define N_SHOTS 10

#define WHEEL_SIZE 4
#define WHEEL_COLOR 8

#define CANNON_L 34
#define CANNON_W 6
#define CANNON_C 28

#define MAX_LOAD 30

#define LIGHTGREEN 10
#define RED 4
#define BLUE 1

#define GRAVITY 0.1



#define GROUND_START 390



#define r_s(A,B,C,D,E) rotate_sprite(A,B,C-(int)(B->w/2),D-(int)(B->h/2),itofix(E))
#define d_s(A,B,C,D) draw_sprite(A,B,C-(int)(B->w/2),D-(int)(B->h/2))



//globals
BITMAP *background;
BITMAP *buffer;
BITMAP *cannon;
int quit;

#include "GROUND.CC"

GROUND ground;

#include "SHOT.CC"

SHOT sh[N_SHOTS];

int findshot()
{
int i;
for (i=0;i<N_SHOTS;i++) if (!sh[i].exist) return i;

return(-1);
}

#include "KEYCFG.CC"
#include "TANK.CC"

TANK ta[N_TANKS];




void main()
{
int i;

srand((int)time(0));
set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);
buffer=create_bitmap(640,480);
background=create_bitmap(640,480);
clear(background);

cannon=create_bitmap(CANNON_L*2,CANNON_W);
clear(cannon);

rectfill(cannon,0,0,CANNON_L,CANNON_W,CANNON_C);

ta[0].init(100,100, 100,15,10,LIGHTGREEN);
ta[1].init(540,100, 30,15,10,BLUE);
ta[0].k.init(KEY_C,KEY_B,KEY_Q,KEY_W,KEY_E);
ta[1].k.init(KEY_LEFT,KEY_RIGHT,KEY_I,KEY_O,KEY_P);


ground.draw(background,12);

install_keyboard();

while(!key[KEY_ESC])
{

//clear(buffer);
ground.fall();

blit(background,buffer,0,0,0,0,640,480);

for (i=0;i<N_TANKS;i++) if (ta[i].exist)
{
    ta[i].fall(buffer);

    ta[i].handleinput();
    ta[i].handle();
    ta[i].checkforshots();
    ta[i].draw(buffer);
    
}

ta[0].illustrateloading(buffer,0,0,"LEFT:",ta[0].color);
ta[1].illustrateloading(buffer,500,0,"RIGHT:",ta[1].color);


for (i=0;i<N_SHOTS;i++) if (sh[i].exist)
{
    sh[i].fall();
    sh[i].draw(buffer);
}

blit(buffer,screen,0,0,0,0,640,480);

}

set_gfx_mode(GFX_TEXT,80,25,0,0);

printf("Made by Nils ster 1999\n");

}


