/*
 * Shoot 'em All!
 * main.h
 * Tekij: Kalle Hytnen IST1SC
 * 20.12.2001
 */

#ifndef MAIN_H
#define MAIN_H

#include <vector>
#include <allegro.h>

#include "menu.h"

using namespace std;

#define TITLE "Shoot 'em All! by Kalle Hytonen"

#define VERSION_MAJOR	1
#define VERSION_MINOR	0


#define RESOLUTION_X	640
#define RESOLUTION_Y	480


#define	RANDOM_X	(rand() % RESOLUTION_X)
#define	RANDOM_Y	(rand() % RESOLUTION_Y)


#define GAME_TIME	120	// seconds
#define FPS_LIMIT	70

// weapons
#define MAX_WEAPONS		1
#define WEAPON_LASER	0
//#define WEAPON_SHOTGUN	1

// objects
#define NUM_OBJECT_1	25
#define NUM_OBJECT_2	20
#define NUM_OBJECT_3	15

#define OBJECT1_VALUE	1
#define OBJECT2_VALUE	2
#define OBJECT3_VALUE	3

struct WEAPON
{
	char	name[25];
	int		ammo;
	int		max_ammo;
	int		damage;

	void	Init(char*, int, int, int);
};

struct EXPLOSION
{
	BITMAP *frame[50];
	int		color;
	float	x, y;
	int		sx, sy;

	float	animTimer;
	float	delay;

	int		frames;
	int		current_frame;

	int		is_alive; // ollaanko elossa?

	void Init(char*, int, int, int, int);
//	void Move();
	void Animate(BITMAP*);
};

struct OBJECT
{
	BITMAP *frame[50];
	int		color;
	float	x, y, vx, vy;
	int		sx, sy;

	//test
	int		value;

	float	animTimer;
	float	delay;

	int		frames;
	int		current_frame;

	int		is_alive; // ollaanko elossa?

	EXPLOSION	explo;

	void Init(char*, int, int, float, int, int, int);
	void Move();
	void Animate(BITMAP*);

};

struct PLAYER
{
	
	char	name[25];
	int		score;
	int		time;
	float	hits;
	//int	hits_in_a_row;
	float	shots;

	float	accuracy;

	void	Init(char*);

	// Weapons
	WEAPON	weapon[MAX_WEAPONS];
	int		current_weapon;	
	int		is_firing;
	int		fire_button_pressed;

	void	HandleWeapons(OBJECT*, BITMAP *bmp);
};

struct PANEL
{
	BITMAP *image;

	int		x, y;
	int		sx, sy;

	void	Init(char*, int x_, int y_, int sx_, int sy_);
	void	Draw(BITMAP*);
};

struct MY_CURSOR
{
	BITMAP *frame[11];
	int		sx, sy;

	float	animTimer;
	float	delay;

	int		total_frames;
	int		current_frame;

	vector<BITMAP*> frame_list;

	void Init(char*, int, int, float);
	void Animate(BITMAP*);
};

struct STAR
{
	float	x, y, vx, vy;
	int		color;
};

struct STARFIELD
{
	STAR	star[255];
	int		stars; // how many stars
	
	void	Init(int, float);
	void	Move(BITMAP*);
};

struct ENGINE
{
	BITMAP *buffer;
	int	sx, sy;
	int	bpp;

	OBJECT			*obj;
	vector<OBJECT*> obj_list;
	int				num_objects;

	MY_CURSOR	cursor;
	PANEL		panel[3];
	PLAYER		player;
	
	STARFIELD	starfield[3];

	EXPLOSION	explosion;

	void Init();
	void Render();
	void ShowInfo();
	void ShowScore();
};

#endif