/*
 * Shoot 'em All!
 * engine.cpp
 * Tekij: Kalle Hytnen IST1SC
 * 20.12.2001
 */

#include "main.h"

// montako objektia nkynyt ruudulla...
int num_objects_shown = NULL;

// asetuksia (config.cfg)
int	objects_1 = NUM_OBJECT_1;
int	objects_2 = NUM_OBJECT_2;
int	objects_3 = NUM_OBJECT_3;
int objects_1_value = OBJECT1_VALUE;
int objects_2_value = OBJECT2_VALUE;
int objects_3_value = OBJECT3_VALUE;

// peliaika
int gtime = GAME_TIME;
// frames per second rajoitus
int	fps_limit = FPS_LIMIT;

/*Ruudunkaappaus - poissa kytst!
 */
/*
void TakeScreenShot()
{
	BITMAP *bmp;
	PALETTE pal;

	get_palette(pal);
	bmp = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
	save_bitmap("dump.pcx", bmp, pal);
	destroy_bitmap(bmp);
}
*/

// FPSTimer
int fps, current_fps;

void FPSTimer(void)
{
	fps = current_fps;
	current_fps = 0;
}
END_OF_FUNCTION(FPSTimer);

// muuttujat ruudunpivityksen rajoittamiseen
long int giActualFrame = 0;
volatile long int giTargetFrame = 0;

void TimerTick(void)
{
    giTargetFrame++;
} 
END_OF_FUNCTION(TimerTick);

// peliaika
int gametime = GAME_TIME;

void GametimeCounter(void)
{
	if(gametime > 0) gametime--;
}
END_OF_FUNCTION(GametimeCounter);

void WEAPON::Init(char *name_, int ammo_, int max_ammo_, int damage_)
{
	strcpy(name, name_);
	ammo = ammo_;
	max_ammo = max_ammo_;
	damage = damage_;
}

void PLAYER::HandleWeapons(OBJECT *obj, BITMAP *bmp)
{

	if((mouse_x+(64/2) > obj->x) && (mouse_x+(64/2) < obj->x+(*(obj)).sx) && 
	   (mouse_y+(64/2) > obj->y) && (mouse_y+(64/2) < obj->y+(*(obj)).sy))
	{
		if(obj->is_alive) {
			//obj->value += 10;
			obj->is_alive = FALSE;
			hits++;
			//hits_in_a_row++;
			//if(hits_in_a_row == 2) {
			//	hits_in_a_row = 0;
			//	weapon[current_weapon].ammo += 5;
			//}
			score += obj->value;
			//textprintf(screen, font, 100, 100, makecol16(255, 255, 255), "JEEJEE");
		
			(*(obj)).explo.x = (*(obj)).x-((*(obj)).explo.sx-(*(obj)).sx)/2;
			(*(obj)).explo.y = (*(obj)).y-((*(obj)).explo.sy-(*(obj)).sy)/2;
			(*(obj)).explo.is_alive = TRUE;		
		}
	}
	//else hits_in_a_row = 0;
}

void PLAYER::Init(char *name_)
{
	strcpy(name, name_);
	score = 0;
	hits = 0;
	shots = 0;
	time = 0; // no timebonus
	accuracy = 0;
	current_weapon = WEAPON_LASER;

	is_firing = FALSE;
	fire_button_pressed = FALSE;

}

void PANEL::Init(char *img, int x_, int y_, int sx_, int sy_)
{
	
	x = x_;
	y = y_;

	sx = sx_;
	sy = sy_;

	image = load_bitmap(img, NULL);	
}

void PANEL::Draw(BITMAP *bmp)
{
	masked_blit(image, bmp, 0, 0, x, y, sx, sy);
}

void MY_CURSOR::Animate(BITMAP *bmp)
{

	if(animTimer >= 1)
	{
		animTimer = 0;
		if(current_frame < 4) current_frame++;
			else current_frame = 0;
	}
	
	animTimer += delay;

	masked_blit(frame[current_frame], bmp, 0, 0, mouse_x, mouse_y, sx, sy);
}

void MY_CURSOR::Init(char *img, int sx_, int sy_, float speed)
{

	sx = sx_;
	sy = sy_;

	total_frames = 5;
	animTimer = 0;
	delay = .3;
	current_frame = 0;
	

	BITMAP *temp = load_bitmap(img, NULL);

	for(int i=0; i<total_frames; i++) {
		frame[i] = create_bitmap(sx, sy);	
		clear(frame[i]);
		
		blit(temp, frame[i], i*sx, 0, 0, 0, sx, sy);
	}

	destroy_bitmap(temp);
}

void EXPLOSION::Animate(BITMAP *bmp)
{

	if(animTimer >= 1)
	{
		animTimer = 0;
		if(current_frame < frames-1) {
			
			current_frame++;
		}
		else {
			current_frame = 0;
			is_alive = FALSE;
		}
			//current_frame = 0;
	}
	
	animTimer += delay;
	
	if((y+sy > 0) && (y < SCREEN_H)) {
		masked_blit(frame[current_frame], bmp, 0, 0, x, y, sx, sy);
	}
}

void EXPLOSION::Init(char *img, int sx_, int sy_, int frames_, int in_row)
{
	sx = sx_; // koko pikselein x-suunnassa
	sy = sy_; // koko pikselein y-suunnassa
	x = NULL;
	y = NULL;
	color = makecol16(0, 0, 0);
	
	is_alive = FALSE; // onko objekti tuhottu vai ei

	frames = frames_; // montako kuvaa animaatiossa
	animTimer = 0; // ajastin animaatiota varten

	delay = .3; // delay animaatiossa
	
	current_frame = 0; //rand() % frames; // aloitetaan animaatio arvotusta framesta

	BITMAP *temp = load_bitmap(img, NULL);

	for(int i=0; i<frames; i++) {
		frame[i] = create_bitmap(sx, sy);	
		clear_to_color(frame[i], color);
		
		// blitataan yhdest isosta kuvasta animaation kuvat
		blit(temp, 
			 frame[i], 
			 i * sx, 
			 (i / in_row) * sy,
			 0, 
			 0, 
			 sx, sy);
	
	}

	destroy_bitmap(temp); // tuhotaan vliaikainen kuvapointteri
}

void OBJECT::Animate(BITMAP *bmp)
{

	if(animTimer >= 1)
	{
		animTimer = 0;
		if(current_frame < frames-1) current_frame++;
			else current_frame = 0;
	}
	
	animTimer += delay;
	
	if((y+sy > 0) && (y < SCREEN_H)) {
		masked_blit(frame[current_frame], bmp, 0, 0, x, y, sx, sy);
	}
	if(key[KEY_V])
	{
		text_mode(-1);
		textprintf(bmp, font, x, y, makecol16(255, 255, 255), "%2d", value);
		text_mode(1);
	}
}

void OBJECT::Move()
{
	x += vx;
	y += vy;

	if(y > SCREEN_H)
	{
		is_alive = TRUE;
		num_objects_shown++;
		x = RANDOM_X;
		y = -sy;
	}
}

void OBJECT::Init(char *img, int sx_, int sy_, float speed, int frames_, int value_, int in_row)
{
	sx = sx_; // koko pikselein x-suunnassa
	sy = sy_; // koko pikselein y-suunnassa
	x = RANDOM_X;
	y = -3*SCREEN_H+rand() % 480;
	vx = 0; // nopeus x-suunnassa
	vy = speed; // nopeus y-suunnassa
	color = makecol16(0, 0, 0);
	
	value = value_; // objektin arvo (score)
	is_alive = TRUE; // onko objekti tuhottu vai ei

	frames = frames_; // montako kuvaa animaatiossa
	animTimer = 0; // ajastin animaatiota varten
	
	int seed = rand() % 5; // random delay animaatiolle
	
	switch(seed)
	{
		case 0 : delay = .1; break;
		case 1 : delay = .2; break;
		case 2 : delay = .3; break;
		case 3 : delay = .4; break;
		case 4 : delay = .5; break;
	}

	current_frame = rand() % frames; // aloitetaan animaatio arvotusta framesta

	BITMAP *temp = load_bitmap(img, NULL);

	for(int i=0; i<frames; i++) {
		frame[i] = create_bitmap(sx, sy);	
		clear_to_color(frame[i], color);
		
		// blitataan yhdest isosta kuvasta animaation kuvat
		blit(temp, 
			 frame[i], 
			 i * sx, 
			 (i / in_row) * sy,
			 0, 
			 0, 
			 sx, sy);
	
	}

	destroy_bitmap(temp); // tuhotaan vliaikainen kuvapointteri
}

void STARFIELD::Move(BITMAP *bmp)
{

	for(int i=0; i<stars; i++)
	{	
		if(star[i].y < SCREEN_H) star[i].y += star[i].vy;
		else {
			star[i].y = 0;
			star[i].x = rand() % SCREEN_W;
		}

		putpixel(bmp, star[i].x, star[i].y, star[i].color);
	}
}

void STARFIELD::Init(int num_stars, float speed)
{

	stars = num_stars;
		
	for(int i=0; i<stars; i++)
	{
		star[i].color = makecol16(200 + rand() % 55, 200 + rand() % 55, 200 + rand() % 55);
		star[i].x = rand() % SCREEN_W;
		star[i].y = rand() % SCREEN_H;
		star[i].vx = 0;
		star[i].vy = speed;
	}

};


void ENGINE::ShowInfo()
{
	text_mode(-1);
	textprintf(buffer, font, panel[0].x+30, 10, makecol16(255, 255, 255), "Player: %s", player.name);
	textprintf(buffer, font, panel[0].x+30+200, 10, makecol16(0, 255, 0), "Hits: %.0f", player.hits);
	textprintf(buffer, font, panel[0].x+30+300, 10, makecol16(255, 255, 255), "Score: %2d", player.score);
	textprintf(buffer, font, panel[0].x+30+420, 10, makecol16(255, 0, 0), "Time: %2d", gametime+player.time); //player.time);

	//textprintf(buffer, font, 30, SCREEN_H-18, makecol16(255, 255, 255), "Accuracy: %.02f %%", player.accuracy);

	if(key[KEY_I]) {
		textprintf_centre(buffer, font, SCREEN_W/2, SCREEN_H/2, makecol16(255, 255, 255), "Objects: %2d", num_objects);
		textprintf_centre(buffer, font, SCREEN_W/2, SCREEN_H/2+20, makecol16(255, 255, 255), "Shown objects: %3d", num_objects_shown);
	}
	
	textprintf(buffer, font, panel[1].x+50, SCREEN_H-18, makecol16(255, 255, 0), "Weapon: %s", player.weapon[player.current_weapon].name);
	textprintf_centre(buffer, font, panel[1].x+400, SCREEN_H-18, makecol16(255, 255, 255), "%s - v%d.%d", TITLE, VERSION_MAJOR, VERSION_MINOR);	
	//textprintf(buffer, font, 30+450, SCREEN_H-18, makecol16(255, 255, 255), "Ammo: %3d/%3d", player.weapon[player.current_weapon].ammo, player.weapon[player.current_weapon].max_ammo);
	//textprintf(buffer, font, 30+450, SCREEN_H-18, makecol16(255, 255, 255), "Missed: %.2f", player.pos);

	textprintf(buffer, font, panel[0].x+panel[0].sx-100, 10, makecol16(255, 255, 255), "FPS: %2d", fps);
	text_mode(1);
}

void ENGINE::ShowScore()
{

	int	temp_score;
	char temp_name[25];

	temp_score = player.score;
	strcpy(temp_name, player.name);
	
	BITMAP *temp = create_bitmap(300, 400);
	//clear_to_color(temp, makecol16(0, 200, 0));
	clear(temp);
	temp = load_bitmap("gfx/panels/panel3.bmp", NULL);

	char info[7][50] = { "Thank you for playing.",
						 "Coding, design & gfx by",
						 "Kalle Hytonen.",
						 "This game was made using",
						 "Allegro library",
						 "by Shawn Hargreaves and others.",
						 "http://sunsite.dk/allegro/" };

	while(!key[KEY_ESC]) {

		clear(buffer);		
					
		starfield[0].Move(buffer);
		starfield[1].Move(buffer);
		starfield[2].Move(buffer);

		draw_trans_sprite(buffer, temp, SCREEN_W/2-150, SCREEN_H/2-200);
			
		text_mode(-1);
		textprintf_centre(buffer, font, SCREEN_W/2, SCREEN_H/2-120, makecol16(255, 0, 0), "G A M E   O V E R");
		textprintf_centre(buffer, font, SCREEN_W/2, SCREEN_H/2-100, makecol16(255, 255, 255), "Your score: %d", player.score);
		textprintf_centre(buffer, font, SCREEN_W/2, SCREEN_H/2-80, makecol16(255, 255, 255), "Your hits: %.0f", player.hits);

		for(int i=0; i<7; i++)
		textprintf_centre(buffer, font, SCREEN_W/2, SCREEN_H/2-30+i*30, makecol16(255, 255, 0+i*40), "%s", info[i]);

		textprintf_centre(buffer, font, SCREEN_W/2, SCREEN_H-20, makecol16(255, 255, 0), "Press ESC to Quit.");
		textprintf_centre(buffer, font, SCREEN_W/2+120, SCREEN_H-55, makecol16(0, 0, 0), "v%d.%d", VERSION_MAJOR, VERSION_MINOR);
		text_mode(-1);

		//cursor.Animate(buffer);

		blit(buffer, screen, 0, 0, 0, 0, sx, sy);

	}

	destroy_bitmap(temp);

	set_config_int("OPTIONS", "ResolutionX", sx);
	set_config_int("OPTIONS", "ResolutionY", sy);

	set_config_int("OPTIONS", "Objects1", objects_1);
	set_config_int("OPTIONS", "Objects2", objects_2);
	set_config_int("OPTIONS", "Objects3", objects_3);

	set_config_int("OPTIONS", "ValueObjects1", objects_1_value);
	set_config_int("OPTIONS", "ValueObjects2", objects_2_value);
	set_config_int("OPTIONS", "ValueObjects3", objects_3_value);

	set_config_int("OPTIONS", "GameTime", gtime);
	set_config_int("OPTIONS", "FPSLimit", fps_limit);

	set_gfx_mode(GFX_TEXT, 320, 240, 0, 0);
	allegro_message("Thank you for playing!\nE-mail: kalle.hytonen.ist@jypoly.fi\nHomepage: http://batman.jypoly.fi/~93680/");

}

void ENGINE::Render()
{
	
	bool game_over = FALSE; // peli kynniss?

	while(!game_over)
	{

		// lopetetaan peli kun peliaika loppuu
		if(gametime <= 0)
			game_over = TRUE;

		while( giActualFrame <= giTargetFrame )
        {
			clear(buffer);		
		
			// FPS counter
			current_fps++;		

			starfield[0].Move(buffer);
			starfield[1].Move(buffer);
			starfield[2].Move(buffer);

			num_objects = obj_list.size();
				
			if((!(mouse_b & 1))) player.fire_button_pressed = FALSE;

			// Pivitetn kaikkia listan objekteja
			for(int i=0; i<num_objects; i++) {
				
				obj_list.at(i)->Move();
				if(obj_list.at(i)->is_alive == TRUE) {
					obj_list.at(i)->Animate(buffer);

				}

				if(obj_list.at(i)->explo.is_alive) { 
					obj_list.at(i)->explo.Animate(buffer);
				}
				
			}

			// jos ammutaan, katsotaan mink objektin kohdalla ollaan...
			if((mouse_b & 1) && (!player.fire_button_pressed)) 
			{
				player.fire_button_pressed = TRUE;
				player.is_firing = TRUE;
				//player.weapon[player.current_weapon].ammo -= 1;
				player.shots++;
		
					for(int i=0; i<num_objects; i++) {
					
						player.HandleWeapons(obj_list.at(i), buffer);			
		
					}		
				//player.accuracy = (player.hits/player.shots)*100;								
			}

			// piirretn paneelit
			panel[0].Draw(buffer);
			panel[1].Draw(buffer);

			// nytetn tietoja
			ShowInfo();
		
			// animoidaan kursori
			cursor.Animate(buffer);

			// nytetn puskurin sislt
			blit(buffer, screen, 0, 0, 0, 0, sx, sy);

			giActualFrame++;

		}
	
		// lopetetaan peli
		if(key[KEY_ESC]) break;
	}

	while(!key[KEY_SPACE]) {
		
		text_mode(-1);
		textprintf_centre(buffer, font, SCREEN_W/2, SCREEN_H/2, makecol16(255, 255, 255), "G A M E   O V E R");
		textprintf_centre(buffer, font, SCREEN_W/2, SCREEN_H/2+25, makecol16(255, 255, 255), "Press SPACE to continue.");
		text_mode(1);
		blit(buffer, screen, 0, 0, 0, 0, sx, sy);
	}
	
	ShowScore();

}

void ENGINE::Init()
{
	allegro_init();
	install_keyboard();
	install_timer();
	install_mouse();

	sx = RESOLUTION_X;
	sy = RESOLUTION_Y;
	bpp = 16;
	
	// Config-tiedosto
	set_config_file("config.cfg");

	sx = get_config_int("OPTIONS", "ResolutionX", 640);
	sy = get_config_int("OPTIONS", "ResolutionY", 480);

	objects_1 = get_config_int("OPTIONS", "Objects1", 25);
	objects_2 = get_config_int("OPTIONS", "Objects2", 20);
	objects_3 = get_config_int("OPTIONS", "Objects3", 15);

	objects_1_value = get_config_int("OPTIONS", "ValueObjects1", 1);
	objects_2_value = get_config_int("OPTIONS", "ValueObjects2", 2);
	objects_3_value = get_config_int("OPTIONS", "ValueObjects3", 3);

	gtime = get_config_int("OPTIONS", "GameTime", 60);
	fps_limit = get_config_int("OPTIONS", "FPSLimit", 75);
/*
	FILE *file = fopen("config.cfg", "rt");
	if(!file) {
		
		FILE *file = fopen("config.cfg", "wt");
		fseek(file, 0, SEEK_SET);
		fwrite(&sx, 1, sizeof(int), file);
		fwrite(&sy, 1, sizeof(int), file);
	
		fseek(file, 0, SEEK_SET);
		fread(&sx, 1, sizeof(int), file);
		fread(&sy, 1, sizeof(int), file);		

		fclose(file);
		
	}
	else
	{
		fseek(file, 0, SEEK_SET);
		fread(&sx, 1, sizeof(int), file);
		fread(&sy, 1, sizeof(int), file);

		fclose(file);
	}
*/
	set_window_title("Shoot 'em all! by Kalle Hytonen 2001"); 

	set_color_depth(bpp);
	if(set_gfx_mode(GFX_AUTODETECT, sx, sy, 0, 0) != 0) // GFX_AUTODETECT_FULLSCREEN
	{
		set_gfx_mode(GFX_TEXT, 320, 240, 0, 0);
		allegro_message("Error setting video mode!\nPlease edit config file.");
		exit(-1);
	}

	// luodaan puskuri (double buffer)
	buffer = create_bitmap(sx, sy);
	clear(buffer);

	srand(time(0));
	set_trans_blender(255, 255, 255, 90);

	// FPSTimer
	LOCK_VARIABLE(fps);
	LOCK_VARIABLE(current_fps);
	LOCK_FUNCTION(FPSTimer);
	// kynnistetn timer (FPS)
	install_int(FPSTimer, 1000);

	// Game Tick Timer
    LOCK_VARIABLE(giTargetFrame);
    LOCK_FUNCTION(TimerTick);
    install_int_ex(TimerTick, BPS_TO_TIMER(fps_limit));

	// Time counter
	LOCK_VARIABLE(gametime);
	LOCK_FUNCTION(GametimeCounter);

	//MY_CURSOR cursor;
	cursor.Init("gfx/cursor/cur02.bmp", 64, 64, .8);

	num_objects = 0;

	for(int i=0; i<objects_1; i++)
	{
		obj = new OBJECT;
		obj->Init("gfx/objects/obj01.bmp", 70, 70, 2.0, 10, OBJECT1_VALUE, 10);
		obj_list.push_back(obj);
		obj->explo.Init("gfx/expl/expl01.bmp", 100, 100, 10, 10);
	}

	for(i=0; i<objects_2; i++)
	{
		obj = new OBJECT;
		obj->Init("gfx/objects/obj02.bmp", 70, 70, 3.0, 10, OBJECT2_VALUE, 10);
		obj_list.push_back(obj);
		obj->explo.Init("gfx/expl/expl01.bmp", 100, 100, 10, 10);
	}

	for(i=0; i<objects_3; i++)
	{
		obj = new OBJECT;
		obj->Init("gfx/objects/obj03.bmp", 70, 70, 4.5, 10, OBJECT3_VALUE, 10);
		obj_list.push_back(obj);
		obj->explo.Init("gfx/expl/expl01.bmp", 100, 100, 10, 10);
	}
	
	// Panels
	panel[0].Init("gfx/panels/panel1.bmp", SCREEN_W/2-640/2, 0, 640, 30);
	panel[1].Init("gfx/panels/panel2.bmp", SCREEN_W/2-640/2, SCREEN_H-30, 640, 30);

	player.Init("Player 1");

	// Weapons
	player.weapon[WEAPON_LASER].Init("Laser Cannon", 100, 100, 1);

	// Starfields
	starfield[0].Init(50, .5);
	starfield[1].Init(80, .8);
	starfield[2].Init(100, 1.2);

	gametime = gtime;
	install_int(GametimeCounter, 1000); // Kynnistetn aikalaskuri

}
// END
