##     ______   ___    ___
##    /\  _  \ /\_ \  /\_ \
##    \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___
##     \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
##      \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
##       \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
##        \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
##                                       /\____/
##                                       \_/__/
##
##     This is the Allegro Simple MakeFile.
##     


######## Default build ######
.PHONY: all
all : shared-rel


#############################################################
################ Plattform specific info ####################
#############################################################


ifdef MINGDIR #################### MinGW ##################
ALLIBO$  = -lalleg
ALLIBI$  = -lalleg
LIBP$    = $(LIB-MGW)
ALODIR$  = $(OBJDIR)obj/mgw/
MKDIR$   = md
DIRSEP$  = \\
ALDLINK$ = $(DEBUG-MGW)
else
ifdef DJDIR  ################ DJGPP #################
ALLIBO$ = -lalleg
ALLIBI$ = -lalleg
LIBP$   = $(LIB-DJGPP)
ALODIR$ = $(OBJDIR)obj/djgpp/
MKDIR$  = md
DIRSEP$ = \\
ALDLINK$ = $(DEBUG-DJGPP)
else         ########### Unix compatible ############
ALLIBO$ = `allegro-config --libs`
ALLIBI$ = `allegro-config --static`
LIBP$   = $(LIB-UNIX)
ALODIR$ = $(OBJDIR)obj/unix/
MKDIR$  = mkdir
DIRSEP$ = /
ALDLINK$ = $(DEBUG-UNIX)
endif
endif



######################################################
################ Compress targets ####################
######################################################

ifneq ($(wildcard $(DJDIR)/bin/upx.exe),)
 ALCOMP$ = $(DJDIR)/bin/upx.exe --best
else
 ifneq ($(wildcard $(DJDIR)/bin/djp.exe),)
  ALCOMP$ = $(DJDIR)/bin/djp.exe -s
 endif
endif


.PHONY: compress
	ALCOMP$ $(EXEN)
	@echo -------------------------------
	@echo Build has been compressed



######################################################
################# Object targets #####################
######################################################

CC$ = gcc

CFLAGSA$ = -Wall

CFLAGSN$ = -ffast-math
LFLAGSN$ = 

ALRELOBJ$   = $(addprefix $(ALODIR)rel/,$(OBJ))
ALDEBUGOBJ$ = $(addprefix $(ALODIR)debug/,$(OBJ))

#### Release compilation
$(addprefix $(ALODIR)rel/,%.o) :: %.c $(HEAD) $(OBJDIR)obj
	$(CC) -c $< $(CFLAGSA) $(CFLAGSN) -s -o $@

#### Debug compilation
$(addprefix $(ALODIR)debug/,%.o) :: %.c $(HEAD) $(OBJDIR)obj
	$(CC) -c $< $(CFLAGSA) $(CFLAGSN) -g -o $@


######################################################
################### Link targets #####################
######################################################

### Shared linking for release
.PHONY: shared-rel
shared-rel : $(ALRELOBJ)
	$(CC) $(ALRELOBJ) $(LFLAGSN) $(EXTRAC) -o $(EXEN) $(LIBO) $(LIBP) $(ALLIBO)
	@echo -------------------------------
	@echo Shared release build complete

### Shared linking for debug
.PHONY: shared-debug
shared-debug : $(ALDEBUGOBJ)
	$(CC) $(ALDEBUGOBJ) $(LFLAGSN) $(EXTRAC) -o $(EXEN) $(LIBO) $(LIBP) $(ALLIBO) $(ALDLINK)
	@echo -------------------------------
	@echo Shared debug build complete


### Static linking for release
.PHONY: static-rel
static-rel : $(ALRELOBJ)
	$(CC) $(ALRELOBJ) $(LFLAGSN) $(EXTRAC) -o $(EXEN) $(LIBI) $(LIBP) $(ALLIBI)
	@echo -------------------------------
	@echo Static release build complete

### Static linking for debug
.PHONY: static-debug
static-debug : $(ALDEBUGOBJ)
	$(CC) $(ALDEBUGOBJ) $(LFLAGSN) $(EXTRAC) -o $(EXEN) $(LIBI) $(LIBP) $(ALLIBI) $(ALDLINK)
	@echo -------------------------------
	@echo Static debug build complete


######################################################
################### FS targets #######################
######################################################

.PHONY: fs
fs : $(OBJDIR)obj
	@echo -------------------------------------
	@echo Filestructure has been prepared
	

$(OBJDIR)obj :
	$(MKDIR) $(subst /,$(DIRSEP),$(OBJDIR)obj)
	$(MKDIR) $(subst /,$(DIRSEP),$(OBJDIR)obj/djgpp)
	$(MKDIR) $(subst /,$(DIRSEP),$(OBJDIR)obj/djgpp/debug)
	$(MKDIR) $(subst /,$(DIRSEP),$(OBJDIR)obj/djgpp/rel)
	$(MKDIR) $(subst /,$(DIRSEP),$(OBJDIR)obj/mgw)
	$(MKDIR) $(subst /,$(DIRSEP),$(OBJDIR)obj/mgw/debug)
	$(MKDIR) $(subst /,$(DIRSEP),$(OBJDIR)obj/mgw/rel)
	$(MKDIR) $(subst /,$(DIRSEP),$(OBJDIR)obj/unix)
	$(MKDIR) $(subst /,$(DIRSEP),$(OBJDIR)obj/unix/debug)
	$(MKDIR) $(subst /,$(DIRSEP),$(OBJDIR)obj/unix/rel)


######################################################
################### Clean targets ####################
######################################################

.PHONY: removeob
removeob :
	$(RM) $(ALRELOBJ)
	$(RM) $(ALDEBUGOBJ)
.PHONY: removeex
removeex :
	$(RM) $(EXEN)
	


.PHONY: clean
clean : removeob removeex
	@echo --------------------------------------------------
	@echo Objects and executable has been removed

	
.PHONY: mostlyclean
mostlyclean : removeob
	@echo --------------------------------------------------
	@echo Objects has been removed

	

