//The best game programming library
#include <allegro.h>
#include <stdio.h>
#include <math.h>

//The upper blocks you must break
#include "blocks.h"

//All of the paddle code
#include "rectangle.h"

//The bouncing ball code
#include "ball.h"


BITMAP *dblbuffer;
SAMPLE *explosion;
SAMPLE *bonk;
MIDI *bg;

int game_over;

volatile float game_time, score;
volatile int last_fps, frame_counter, end_game;

//for paddle coordinates
extern int x1_paddle, x2_paddle, y1_paddle, y2_paddle, x, y, going_up, going_left;
char buf[50];

float blocks_broke;

void get_user_input()
{
                if(key[KEY_RIGHT])
                {
                  move_paddle_right();
                }


                if(key[KEY_LEFT])
                {
                 move_paddle_left();
                }

                if(key[KEY_ESC])
                {
                 end_game = 1;
                }
				game_time++;
}
END_OF_FUNCTION(get_user_input);

void count_frames()
{
    last_fps = frame_counter;
    frame_counter = 0;
}
END_OF_FUNCTION(count_frames);

void move_ball()
{
    update_ball();
}
END_OF_FUNCTION(count_frames);

int number_range( int from, int to )
{
    int power;
    int number;
    if (from == 0 && to == 0) return 0;
    if( (to = to - from + 1) <= 1 )	return from;
    for(power = 2; power < to; power <<= 1);
    while( ( number = rand() & (power -1 ) ) >= to );
    return from + number;
}



int main(void)
{
        srand( (unsigned)time(NULL) );

        allegro_init();

        install_timer();

        install_keyboard();

	install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);

        set_gfx_mode(GFX_AUTODETECT, 800, 600, 0, 0);

        end_game = 0;
		
		last_fps = frame_counter = 0;

		game_over = 0;

		game_time = 1;

        dblbuffer = create_bitmap(800, 600);

		blocks_broke = 1;
		game_time = 1;

        clear(dblbuffer);

		explosion = load_sample("explosion.wav");
		bonk = load_sample("bonk.wav");
		bg = load_midi("song.mid");

		play_midi (bg, 1);

        //this sets all of the blocks coordinates and sets them all to alive
                 init_blocks();

        //beginning paddle location
                x1_paddle = 450;
                x2_paddle = 500;
                y1_paddle = 400;
                y2_paddle = 503;

        //ball init values
                x = 400;
                y = 125;
                going_up = number_range(0, 1);
                going_left = number_range(0, 1);

        //being running timer
         LOCK_FUNCTION(get_user_input);
         install_int(get_user_input, 10);
	     LOCK_VARIABLE(last_fps);
		 LOCK_VARIABLE(frame_counter);
	     LOCK_FUNCTION(count_frames);
		 install_int_ex(count_frames, BPS_TO_TIMER(1));
		 rest(2000);
		 LOCK_FUNCTION(move_ball);
		 install_int(move_ball, 20);
		

        //main game loop
        drawing_loop:
            draw_blocks();
            rectangle();
            draw_ball();
			
			score = (blocks_broke * 100) - (game_time / 100);
			sprintf(buf, "Your score is: %fl", score);
			textout_centre(dblbuffer, font, buf, 110, 10, 10);

			sprintf(buf, "FPS: %d", last_fps);
			textout_centre(dblbuffer, font, buf, 730, 10, 10);
			frame_counter++;

            rect(dblbuffer, 1, 0, 790, 590, 1);
     	    vsync();
            blit(dblbuffer, screen, 0, 0, 0, 0, 800, 600);
			if (game_over == 1) { goto lost_game; }
			if (blocks_broke == 54) { goto won_game; }
            if (end_game == 1) { goto exit_game; }
            clear(dblbuffer);
        goto drawing_loop;

 remove_int(get_user_input);

destroy_bitmap(dblbuffer);

lost_game:
	//text_mode(1);
	textout_centre(screen, font, "You have been defeated by the machine", 400, 300, 4);
	textout_centre(screen, font, "Better luck next time, loser!", 400, 350, 4);
	goto rest_game;

won_game:
	//text_mode(3);
	textout_centre(screen, font, "Congratulations!!!", 400, 300, 1);
	textout_centre(screen, font, "You have won!", 400, 350, 1);

rest_game:

rest(3000);

readkey();

exit_game:

return 0;


}
END_OF_MAIN()
