//GOL's Game engine
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <allegro.h>

#define PI 3.14159265

static int end_game;
extern FONT* font;

//Game Vars
static int P1_y, //Center position of Player 1
	P2_y, //Center position of Player 2
	ball_x, ball_y, //Center position of ball
	score_P1, score_P2;
static float ball_hspeed,
	ball_vspeed;

//Game Options
static int paddle_size,
	paddle_width,
	paddle_speed,
	ball_speed;
static float speed;

//Colors
#define C_WHITE makecol(255,255,255)
#define C_BLACK makecol(0,0,0)

void config(int, int);
void init_gfx(int, int);
void start();
void input();
void game_loop();
void output();
void finish();

//Initialization Functions
void init(int argc, char** argv)
{
	allegro_init();
	
	char x;
	int width = 640,
		height = 480;
	
	speed = 1.0;
	paddle_size = 64;
	paddle_width = 4;
	paddle_speed = 4;
	ball_speed = 4;
	
	while((x = getopt(argc,argv,"w:h:s:p:")) != -1)
	{
		switch(x)
		{
			case 'w': //grid width
				sscanf(optarg,"%d",&width);
				break;
			case 'h': //grid height
				sscanf(optarg,"%d",&height);
				break;
			case 's': //game speed
				sscanf(optarg,"%f",&speed);
				break;
			case 'p': //paddle size
				sscanf(optarg,"%d", &paddle_size);
			default:
				printf("Not a valid option: -%c",x);
		}
	}
	
	end_game = 0;
	
	//initialize game components	
	config(width, height);
	
	start();
}

//Game Configuration
//Based upon comandline expressions
void config(int w, int h)
{
	//Timer
	/*Timed functions:
		Game Loop: 60 rps
	*/
	install_timer();
	install_int(game_loop, 1000/60 * speed);
	
	//Keyboard
	//No key repeating: only key presses!
	install_keyboard();
		
	init_gfx(w, h);
}

//Initialize graphics
void init_gfx(int w, int h)
{
	set_color_depth(24);
	if (set_gfx_mode(GFX_AUTODETECT, w, h, 640, 480) != 0)
		printf("Error setting graphic mode\n");
}

//Start the game
//For future plans: menu
void start()
{
	P1_y = P2_y = ball_y = SCREEN_H/2;
	score_P1 = score_P2 = 0;
	ball_x = SCREEN_W/2;
	srand(time(NULL));
	ball_hspeed = (rand()%500 + 500)/1000.0;
	ball_vspeed = sin(acos(ball_hspeed));
}

//Game Loop Functions

//User input
void input()
{
	if (keypressed())	
	{
		readkey();
		
		//Quit on Q
		if (key[KEY_Q])
		{
			end_game = 1;
			return;
		}
	}
	
	//P1 Controls
	if (key[KEY_UP] && P1_y >= paddle_size/2)
	{
		P1_y -= paddle_speed;
	}
	if (key[KEY_DOWN] && P1_y <= (SCREEN_H-paddle_size/2))
	{
		P1_y += paddle_speed;
	}
}

//Game output
void output()
{
	//Clear screen from previous tick
	clear_bitmap(screen);
	
	//Draw field
	int i;
	for (i=8; i<SCREEN_H; i+=64)
	{
		rectfill(screen, SCREEN_W/2 - 1, i, SCREEN_W/2 + 1, i+32, C_WHITE);
	}
	
	//Draw Paddles
	rectfill(screen, 31, P1_y - paddle_size/2, 31+(paddle_width-1), P1_y + paddle_size/2, C_WHITE);
	rectfill(screen, SCREEN_W - 31, P2_y - paddle_size/2, SCREEN_W - 31 - (paddle_width-1), P2_y + paddle_size/2, C_WHITE);
	
	//Draw Ball
	circlefill(screen, ball_x, ball_y, 2, C_WHITE);
	
	//Draw Score
	textprintf_ex(screen,font, 64, 4,C_WHITE, -1, "%d", score_P1);
	textprintf_ex(screen,font, SCREEN_W-64, 4,C_WHITE, -1, "%d", score_P2);
	
	//Debugger
	//textprintf_ex(screen, font, 4, 4, C_WHITE, -1, "Ball Speed: %f, %f", ball_hspeed, ball_vspeed);
}

//Game loop processing
void game_loop()
{
	input();
	
	//check for "restart" and "end" signals
	if (end_game) return;
		
	//Check collision with walls
	if (ball_y <= 4 || ball_y >= SCREEN_H - 4)
	{
		ball_vspeed = -ball_vspeed;
		ball_y = (ball_y >= SCREEN_H-4? SCREEN_H-8: 8);
	}
	
	//collision with paddles
	if (ball_x <= (31+paddle_width*2-1) && ball_x >= 31 && ball_y >= P1_y - paddle_size/2 && ball_y <= P1_y + paddle_size/2)
	{
		ball_hspeed = -ball_hspeed;
		ball_vspeed = ball_vspeed*(1+(float)(P1_y - ball_y)/paddle_size/2);
		ball_x += ball_hspeed*8.0;
	}
	
	if (ball_x >= SCREEN_W-(31+paddle_width*2-1) && ball_x <= SCREEN_W-31 && ball_y >= P2_y - paddle_size/2 && ball_y <= P2_y + paddle_size/2)
	{
		ball_hspeed = -ball_hspeed;
		ball_vspeed = ball_vspeed*(1+(float)(P2_y - ball_y)/paddle_size/2);
		ball_x += ball_hspeed*8.0;
	}
	
	//point marking!
	if (ball_x <= 0)
	{
		score_P2++;
		ball_x = SCREEN_W/2;
		ball_y = SCREEN_H/2;
	}
	
	if (ball_x >= SCREEN_W - 4)
	{
		score_P1++;
		ball_x = SCREEN_W/2;
		ball_y = SCREEN_H/2;
	}
	
	//AI... not so smart, kay?
	if (ball_hspeed > 0 && ball_x >= SCREEN_W/2)
	{
		if (ball_y > (P2_y + paddle_size/2) && ball_vspeed >= 0 && P2_y < (SCREEN_H - paddle_size/2))
			P2_y += paddle_speed;
		else if (ball_y < (P2_y - paddle_size/2) && ball_vspeed <= 0 && P2_y > paddle_size/2)
			P2_y -= paddle_speed;
	}
	
	//Move ball	
	ball_x += ball_hspeed*(float)ball_speed;
	ball_y += ball_vspeed*(float)ball_speed;
		
	output();
}

//Game End Functions
void finish()
{
	remove_keyboard();
	remove_timer();
}
