#include <allegro.h>
#include <string.h>
#include "paddle.h"
#include "blocks.h"
#include "powerups.h"



extern int x1_paddle, x2_paddle, y1_paddle, y2_paddle;
BITMAP *powerup, *dblbuffer;

void change_message(char *newmsg) {

	free(Powerup_Name);
	Powerup_Name = malloc(sizeof(char) * (strlen(newmsg) + 1) );
	
	strcpy(Powerup_Name, newmsg);
	//Powerup_Name[strlen(newmsg)] = '\0';

	pmsgset = 1;

}

void powerup_check_collision(int b){


	if (blocks[b].x1 >= x1_paddle - powerups[1]->w && blocks[b].x1 <= x2_paddle + powerups[1]->w && blocks[b].y1 >= y1_paddle - powerups[1]->h && blocks[b].y1 <= y2_paddle + powerups[1]->h ) {

		if (blocks[b].ptype == POWERUP_LENGTHEN){ //Makes paddle larger
			x1_paddle -= 10;
			x2_paddle += 10;
			change_message("Lengthener!");
		}		

		else if(blocks[b].ptype == POWERUP_SHORTEN){ //Makes paddle smaller
			x1_paddle += 5;
			x2_paddle -= 5;
			change_message("Shortener!");
		}
		else if(blocks[b].ptype == POWERUP_FASTER){ //Makes paddle faster
			augment_paddle_speed(2);
			change_message("Speed Boost!");
		}
		else if(blocks[b].ptype == POWERUP_SLOWER){ //Makes paddle slower
			augment_paddle_speed(-2);
			change_message("Lagger!");
		}

		blocks[b].ptype = 0;
		blocks[b].alive = 0;
		blocks[b].powerup = 0;
	
	}		
}


void draw_powerup(){
	int b = 0, num = 0;

	while(b < BLOCKS){
		if( blocks[b].powerup == 1 && blocks[b].alive == 0){
			num = blocks[b].ptype - 1;
			masked_blit(powerups[num], dblbuffer, 0, 0, blocks[b].x1, blocks[b].y1, powerups[1]->w, powerups[1]->h);
			
		}
	b++;
	}

}

void update_powerup(){
	int b = 0;	

	while(b < BLOCKS){

		if( !blocks[b].alive && blocks[b].powerup){ 
			blocks[b].y1 += 3;
			powerup_check_collision(b);
			
		}

		b++;
	}

}



	

