//The best game programming library
#include <allegro.h>
#include <stdio.h>
#include <math.h>

//The upper blocks you must break
#include "blocks.h"

//All of the paddle code
#include "paddle.h"

//The bouncing ball code
#include "ball.h"

//The powerup code
#include "powerups.h"


BITMAP *dblbuffer;
SAMPLE *explosion;
SAMPLE *bonk;
MIDI *bg;
PALETTE palette;

int game_over = 0;

volatile float game_time = 1;
volatile int last_fps = 0, frame_counter = 0, end_game = 0, score, speed_counter = 0, cheat_mode = 0;

//for paddle coordinates
extern int x1_paddle, x2_paddle, y1_paddle, y2_paddle, x, y, going_up, going_left;
char buf[50];

float blocks_broke;

void GetControls()
{
	if(key[KEY_RIGHT])
		move_paddle_right();
	else if (key[KEY_LEFT])
		move_paddle_left();

	if(key[KEY_C]) {

		while (key[KEY_C]) {}

		if (cheat_mode)
			cheat_mode = 0;
		else
			cheat_mode = 1;
	}


	if(key[KEY_ESC])
		end_game = 1;

	game_time++;
}

void increment_speed_counter()
{
	speed_counter++;
}END_OF_FUNCTION(increment_speed_counter);

void fps_timer()
{
	last_fps = frame_counter;
	frame_counter = 0;
}
END_OF_FUNCTION(fps_timer);



void Restart_Round() {

	game_over = 0;
	blocks_broke = 0;

	//this sets all of the blocks coordinates and sets them all to alive
	init_blocks();
	init_paddle();

	init_ball();

	augment_paddle_speed(0); /*restart speed*/

}

void Replay(int state) {

	text_mode(-1);

	if (state == 0) {
		textout_centre(screen, font, "You have been defeated by the machine", 400, 300, makecol(192,0,0));
		textout_centre(screen, font, "Better luck next time, loser! R to play again any key to quit", 400, 350, makecol(192,0,0));

	}
	else if (state == 1) {
		textout_centre(screen, font, "Congratulations!!!", 400, 300, makecol(0,0,192));
		textout_centre(screen, font, "You have won!", 400, 350, makecol(0,0,192));

	}

	textout_centre(screen, font, "Q to quit or any key to play again...", 400, 400, makecol(255,255,255));

	rest(800);
	clear_keybuf();

	while (!keypressed()) { }

	if (key[KEY_ESC])
		end_game = 1;
	else
		Restart_Round();

}

void Render_Screen() {
	char pmsg[100];
	draw_blocks();
	rectangle();
	draw_ball();
	draw_powerup();

	if (cheat_mode)
		DrawCheatLine();
				
	score = (blocks_broke * 100) - (game_time / 100);
	sprintf(buf, "Your score is: %d", score);
	textout_centre(dblbuffer, font, buf, 110, 10, 10);

	sprintf(buf, "FPS: %d", last_fps);
	textout_centre(dblbuffer, font, buf, 730, 10, 10);

	if(pmsgset)
		textout_centre(dblbuffer, font, Powerup_Name, 400, 10, makecol(255,255,255));

	rect(dblbuffer, 1, 0, 790, 590, 1);
	//vsync();
	blit(dblbuffer, screen, 0, 0, 0, 0, 800, 600);
	clear(dblbuffer);
}

int main(void)
{

	allegro_init();

	install_timer();

	install_keyboard();

	install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);

	set_gfx_mode(GFX_GDI, 800, 600, 0, 0);

	set_color_depth(8);

	dblbuffer = create_bitmap(800, 600);

	powerups[0] = load_bitmap("graphics/lengthener.bmp", palette);
	powerups[1] = load_bitmap("graphics/shortener.bmp", palette);
	powerups[2] = load_bitmap("graphics/speedboost.bmp", palette);
	powerups[3] = load_bitmap("graphics/lagger.bmp", palette);

	//set_palette_range(palette, 0, 255, 1);
	//set_palette(palette);

	srand( (unsigned)time(NULL) );

	clear(dblbuffer);

	explosion = load_sample("music/explosion.wav");
	bonk = load_sample("music/bonk.wav");
	bg = load_midi("music/song.mid");

	play_midi (bg, 1);

	Restart_Round();
	Render_Screen();

	textout_centre(screen, font, "PRESS ANY KEY WHEN READY TO PLAY", 400, 300, makecol(255,255,255));
	while(!keypressed()) {}

	//being running timer
	LOCK_FUNCTION(fps_timer);
	install_int(fps_timer, 1000);

	LOCK_VARIABLE(speed_counter);
	LOCK_FUNCTION(increment_speed_counter);
	install_int_ex(increment_speed_counter, BPS_TO_TIMER(60));

	//main game loop
	while (!end_game) 
	{
		while (speed_counter > 0) 
		{
			GetControls();
			update_ball();
			update_powerup();
			
			if (game_over || blocks_broke == 54) {

				remove_int(increment_speed_counter);

				if (game_over == 1)
					Replay(0);
				else
					Replay(1);

				install_int_ex(increment_speed_counter, BPS_TO_TIMER(60));
			}

			speed_counter--;
		}
			frame_counter++;
			
			Render_Screen();;

	}


	destroy_bitmap(dblbuffer);
	destroy_bitmap(powerups[1]);
	destroy_bitmap(powerups[2]);
	destroy_bitmap(powerups[3]);
	destroy_bitmap(powerups[4]);

	return 0;

}
END_OF_MAIN()
