#include <allegro.h>
#include <math.h>
#include "ball.h"
#include "blocks.h"
#include "powerups.h"

#define BALL_RADIUS 5

extern SAMPLE *explosion;
extern SAMPLE *bonk;
extern SAMPLE *powerup;
extern BITMAP *dblbuffer;
extern int game_over, x1_paddle, x2_paddle, y1_paddle, y2_paddle;
extern float blocks_broke;
int x,y,going_up, going_left;

void DrawCheatLine() {

	int x2, y2, DistanceX, DistanceY, DistanceH;

	DistanceX = abs(x - x1_paddle);
	DistanceY = abs(y - y1_paddle);

	//DistanceH = sqrt( pow(DistanceX, 2) + pow(DistanceY, 2) );
	DistanceH = 1000;

	if (going_left)
		DistanceH *= -1;

	x2 = x + DistanceH;
	y2 = y + abs(DistanceH);

	if (going_up)
		line(dblbuffer, x, y, x2, y2, makecol(192,192,0));
}

void init_ball() {

	//ball init values
	x = 400;
	y = 125;
	going_up = number_range(0, 1);
	going_left = number_range(0, 1);

}

void update_ball() {

	int b;

	if(going_left == 0)
	{

		x = x + 3;

		if (going_up == 1) {

			if (y>580) {
				going_up = 0;
			}
			else { y = y + 4; }


		}
		else {

			if (y<10) {
				going_up = 1;
			}
			else { y = y - 4; }

			}

			circlefill(dblbuffer, x, y, 5, 6);

		if (x>785) {
			going_left = 1;
		}


	}
	else {

	x = x - 3;

	if (going_up == 1) {

	if (y>590) {
	going_up = 0;
	}
	else { y = y + 4; }


	}
	else {

	if (y<20) {
	going_up = 1;
	}
	else { y = y - 4; }

	}


	circlefill(dblbuffer, x, y, 5, 6);

	}

	if (x<10) {
	going_left = 0;
	}



	//check to see if ball is on paddle
	if (x >= x1_paddle - BALL_RADIUS && x <= x2_paddle + BALL_RADIUS && y >= y1_paddle - BALL_RADIUS && y <= y2_paddle + BALL_RADIUS ) {
		going_up = 0;
		play_sample (bonk, 200, 205, 1000, 0);
	}
	else if ( y > y2_paddle + 50) { 
		game_over = 1;
	}


	//check to see if ball is breaking blocks

	for (b = 0; b < BLOCKS; b++) {
				
		if (blocks[b].alive) {
			if (x >= blocks[b].x1 - BALL_RADIUS && x <= blocks[b].x2 + BALL_RADIUS && y >= blocks[b].y1 - BALL_RADIUS && y <= blocks[b].y2 + BALL_RADIUS ) {
				blocks[b].alive = 0;

				play_sample (explosion, 200, 50, 1000, 0);

				blocks_broke++;
					
				if (!going_up)
					going_up = 1;
				else
					going_up = 0;
			}
		}

	}


}
void draw_ball() {

    circlefill(dblbuffer, x, y, BALL_RADIUS, 6);

}



