#include "commonheaders.h"
#include "cls-menu.h"
#include "cls-window.h"
#include "initialization.h"
#include "winfunctions.h"
#include "window.h"

void OpenRoomDialog(void) {
    OpenWindow(RWin("New Room"));
    Windows[RWin("New Room")]->Set_Pos(main_width / 2 - 88, main_height / 2 - 40);
    Windows[RWin("New Room")]->TextBoxes[0]->StartInput();
    dialogmode = true;
    dialogwindow = RWin("New Room");
}
void ExitDialog(void) {
    destroy_bitmap(frozenbuf);
    frozenbuf = NULL;
    CloseWindow(dialogwindow);
    dialogmode = false;
    dialogwindow = 0;
}
void AppendRoom(char *stringy) {
    if(stringy[0] != '\0' && stringy[0] != ' ') {
        if(Windows[RWin("Map Editor")]->ListBoxes[0]->AddItem(stringy)) {
            Windows[RWin("Room Editor")]->ScrollBoxes[0]->AddItem(stringy);
            roomamount++;
            selectedroom = roomamount - 1;
        }
    	roomTiles = (ROOM *)realloc(roomTiles, sizeof(ROOM) * roomamount);
    	//printf("R%i  &%i  MEM%i\n", roomamount, roomTiles[roomamount], sizeof(ROOM) * roomamount);
    	if(roomTiles == NULL) {
			allegro_message("Memory Error:\n    Memory for the room could not be allocated\n\nAborting Program");
			exit(1);
		}
    	roomTiles[roomamount - 1].xSize = 0;
    	roomTiles[roomamount - 1].ySize = 0;
    	roomTiles[roomamount - 1].tiles = NULL;
    	/*roomTiles[roomamount - 1].clips = NULL;
    	roomTiles[roomamount - 1].spcls = NULL;*/
    }

    destroy_bitmap(frozenbuf);
    frozenbuf = NULL;
    CloseWindow(dialogwindow);
    dialogmode = false;
    dialogwindow = 0;
}
void AppendRoomButton(void) {
    char *tempstr;
    tempstr = (char *)malloc(sizeof(char) * Windows[RWin("New Room")]->TextBoxes[0]->GetString(NULL));
    Windows[RWin("New Room")]->TextBoxes[0]->GetString(tempstr);
    Windows[RWin("New Room")]->TextBoxes[0]->CancelInput();
    if(tempstr[0] != '\0' && tempstr[0] != ' ') {
        if(Windows[RWin("Map Editor")]->ListBoxes[0]->AddItem(tempstr)) {
            Windows[RWin("Room Editor")]->ScrollBoxes[0]->AddItem(tempstr);
            roomamount ++;
            selectedroom = roomamount - 1;
        }
    	roomTiles = (ROOM *)realloc(roomTiles, sizeof(ROOM) * roomamount);
        if(roomTiles == NULL) {
			allegro_message("Memory Error:\n    Memory for the room could not be allocated\n\nAborting Program");
			exit(1);
		}
		roomTiles[roomamount - 1].xSize = 0;
    	roomTiles[roomamount - 1].ySize = 0;
    	roomTiles[roomamount - 1].tiles = NULL;
    	/*roomTiles[roomamount - 1].clips = NULL;
    	roomTiles[roomamount - 1].spcls = NULL;*/
    }
    
    free(tempstr);
    destroy_bitmap(frozenbuf);
    frozenbuf = NULL;
    CloseWindow(dialogwindow);
    dialogmode = false;
    dialogwindow = 0;
    //Windows[WinMapEdit]->ScrollBoxes[0]->ModInt(0, roomamount, 1);
}

void ImportRoom(char *stringy) { 
    Import_Level(stringy); }
void ImportRoomButton(void) { 
    char *tempstr;
    tempstr = (char *)malloc(sizeof(char) * Windows[RWin("Import Room")]->TextBoxes[0]->GetString(NULL));
    Windows[RWin("Import Room")]->TextBoxes[0]->GetString(tempstr);
    Windows[RWin("Import Room")]->TextBoxes[0]->CancelInput();
    Import_Level(tempstr);
    free(tempstr);
}

void ExportRoom(char *stringy) { 
    Export_Level(stringy); }
void ExportRoomButton(void) { 
    char *tempstr;
    tempstr = (char *)malloc(sizeof(char) * Windows[RWin("Export Room")]->TextBoxes[0]->GetString(NULL));
    Windows[RWin("Export Room")]->TextBoxes[0]->GetString(tempstr);
    Windows[RWin("Export Room")]->TextBoxes[0]->CancelInput();
    Export_Level(tempstr);
    free(tempstr);
}
void DeleteRoom(void) {
    for(short y = 0; y < MapYSize; y ++) {
        for(short x = 0; x < MapXSize; x ++) {
            if(MapGrid[y][x] == selectedroom + 1) {
                MapGrid[y][x] = 0;
                MapSpec[y][x] = 0;
            }
        }
    }
    Windows[RWin("Room Editor")]->ScrollBoxes[0]->EraseItem(selectedroom);
    Windows[RWin("Map Editor")]->ListBoxes[0]->EraseItem(selectedroom);
    Windows[RWin("Map Editor")]->Viewports[0]->Refresh();
    /*for(short i = 0; i < roomamount - 1; i++) {
        if(i >= selectedroom) {
            for(short j = 0; j < roomTiles[i].ySize; j++;
            unsigned short * tempsht;
            
        }
    }*/
    roomamount --;
    if(roomTiles != NULL) {
    	roomTiles = (ROOM *)qualloc(roomTiles, sizeof(ROOM) * roomamount);
    	if(roomamount == 0) roomTiles = NULL;
	}
}
void ClearRoom(void) {
    for(short y = 0; y < MapYSize; y ++) {
        for(short x = 0; x < MapXSize; x ++) {
            if(MapGrid[y][x] == selectedroom + 1) {
                MapGrid[y][x] = 0;
                MapSpec[y][x] = 0;
            }
        }
    }
}
void ClearAll(void) {
    for(short y = 0; y < MapYSize; y ++) {
        for(short x = 0; x < MapXSize; x ++) {
            MapGrid[y][x] = 0;
            MapSpec[y][x] = 0;
        }
    }
}
void EditRoom(void) {
	if(roomamount > 0) {
    clear_keybuf();
    short ystart = -1, yend = -1;
    short xstart = -1, xend = -1;
    for(short y = 0; y < MapYSize; y ++) {
        for(short x = 0; x < MapXSize; x ++) {
            if(MapGrid[y][x] == selectedroom + 1) {
                if(ystart == -1) {
                    ystart = y;
                    yend = y;
                } else if(y < ystart) {
                    ystart = y;
                }
                if(y > yend) {
                    yend = y;
                }
                if(xstart == -1) {
                    xstart = x;
                    xend = x;
                } else if(x < xstart) {
                    xstart = x;
                }
                if(x > xend) {
                    xend = x;
                }
            }
        }
    }
    yend ++;
    xend ++;
    if(ystart > -1 && xstart > -1) {
        printf("Allocating Room %i...\nRoom Size: ", selectedroom);
        printf("%ix%i\n", (xend - xstart) * 64, (yend - ystart) * 48);
        printf("Memory Needed:%i\n", (xend - xstart) * 16 * sizeof(unsigned short *)*  (yend - ystart) * 12 * sizeof(unsigned short *));
    	//printf("R%i  &%i\n ", roomamount, roomTiles[roomamount - 1]);
        
        printf("Element Satus: ");
		printf("%s\n", roomTiles[selectedroom].tiles);
        
        if(roomTiles[selectedroom].tiles == NULL) {
            roomTiles[selectedroom].tiles = (struct tile **)realloc(roomTiles[selectedroom].tiles, sizeof(struct tile *) * (yend - ystart) * 12);
            memset(roomTiles[selectedroom].tiles, 0, sizeof(unsigned short *) * (yend - ystart) * 12);
        } else  {
            roomTiles[selectedroom].tiles = (struct tile **)realloc(roomTiles[selectedroom].tiles, sizeof(struct tile *) * (yend - ystart) * 12);
            if((yend - ystart) * 12 > roomTiles[selectedroom].ySize) {
                for(short i = roomTiles[selectedroom].ySize; i < (yend - ystart) * 12; i ++) {
                    roomTiles[selectedroom].tiles[i] = NULL;
                }
            }
        }/*
        if(roomTiles[selectedroom].clips == NULL) {
            roomTiles[selectedroom].clips = (unsigned short **)realloc(roomTiles[selectedroom].clips, sizeof(unsigned short *) * (yend - ystart) * 12);
            memset(roomTiles[selectedroom].clips, 0, sizeof(unsigned short *) * (yend - ystart) * 12);
        } else {
            roomTiles[selectedroom].clips = (unsigned short **)realloc(roomTiles[selectedroom].clips, sizeof(unsigned short *) * (yend - ystart) * 12);
            if((yend - ystart) * 12 > roomTiles[selectedroom].ySize) {
                for(short i = roomTiles[selectedroom].ySize; i < (yend - ystart) * 12; i ++) {
                    roomTiles[selectedroom].clips[i] = NULL;
                }
            }
        }
        if(roomTiles[selectedroom].spcls == NULL) {
            roomTiles[selectedroom].spcls = (unsigned short **)realloc(roomTiles[selectedroom].spcls, sizeof(unsigned short *) * (yend - ystart) * 12);
            memset(roomTiles[selectedroom].spcls, 0, sizeof(unsigned short *) * (yend - ystart) * 12);
        } else {
            roomTiles[selectedroom].spcls = (unsigned short **)realloc(roomTiles[selectedroom].spcls, sizeof(unsigned short *) * roomTiles[selectedroom].ySize);
            if((yend - ystart) * 12 > roomTiles[selectedroom].ySize) {
                for(short i = roomTiles[selectedroom].ySize; i < (yend - ystart) * 12; i ++) {
                    roomTiles[selectedroom].spcls[i] = NULL;
                }
            }
        }*/
        
        roomTiles[selectedroom].ySize = (yend - ystart) * 12;
        
        printf("Allocating Rows...\n");
        for(short i = 0; i < roomTiles[selectedroom].ySize; i ++)
        {
            if(i == 0) printf("Row Number: %i", i);
            else       printf(", %i ", i);
            //PrintLoc();
            if(roomTiles[selectedroom].tiles[i] == NULL)
            {
                roomTiles[selectedroom].tiles[i] = (struct tile *)realloc(roomTiles[selectedroom].tiles[i], sizeof(struct tile) * (xend - xstart) * 16);
                memset(roomTiles[selectedroom].tiles[i], 0, sizeof(struct tile *) * (xend - xstart) * 16);
            }
            else 
            {
                roomTiles[selectedroom].tiles[i] = (struct tile *)realloc(roomTiles[selectedroom].tiles[i], sizeof(struct tile) * (xend - xstart) * 16);
                if((xend - xstart) * 16 > roomTiles[selectedroom].xSize) {
                    for(short j = roomTiles[selectedroom].xSize; j < (xend - xstart) * 16; j ++) {
                        roomTiles[selectedroom].tiles[i][j].tileval = 0;
                    }
                    
                }
            }/*
            if(roomTiles[selectedroom].clips[i] == NULL)
            {
                roomTiles[selectedroom].clips[i] = (unsigned short *)realloc(roomTiles[selectedroom].clips[i], sizeof(unsigned short) * (xend - xstart) * 16);
                memset(roomTiles[selectedroom].clips[i], 0, sizeof(unsigned short) * (xend - xstart) * 16);
            }
            else
            {
                roomTiles[selectedroom].clips[i] = (unsigned short *)realloc(roomTiles[selectedroom].clips[i], sizeof(unsigned short) * (xend - xstart) * 16);
            }
            if(roomTiles[selectedroom].spcls[i] == NULL)
            {
                roomTiles[selectedroom].spcls[i] = (unsigned short *)realloc(roomTiles[selectedroom].spcls[i], sizeof(unsigned short) * (xend - xstart) * 16);
                memset(roomTiles[selectedroom].spcls[i], 0, sizeof(unsigned short) * (xend - xstart) * 16);
            }
            else
            {
                roomTiles[selectedroom].spcls[i] = (unsigned short *)realloc(roomTiles[selectedroom].spcls[i], sizeof(unsigned short) * (xend - xstart) * 16);
            }*/
            
        }
        roomTiles[selectedroom].xSize = (xend - xstart) * 16;
        printf("\nRoom Allocation Complete.\n", (xend - xstart) * 16, (yend - ystart) * 12);
        Windows[RWin("Room Editor")]->Viewports[0]->ResizeIn(roomTiles[selectedroom].xSize, roomTiles[selectedroom].ySize);
        if(Window_is_open(RWin("Map Editor"))) {
            printf("open");
            if(Window_is_open(RWin("Map Editor"))) {
                CloseWindow(RWin("Map Editor"));
                winMapEdit = false;
            }
            if(!Window_is_open(RWin("Room Editor"))) {
                OpenWindow(RWin("Room Editor"));
                winRoomEdit = true;
            }
            if(!Window_is_open(RWin("Tiles"))) {
                OpenWindow(RWin("Tiles"));
                winTiles = true;
            }
        }
        printf("Changed Viewport\n");
    } else {
        Windows[RWin("Room Editor")]->Viewports[0]->ResizeIn(0, 0);
        if(Window_is_open(RWin("Map Editor"))) {
            if(Window_is_open(RWin("Map Editor"))) {
                CloseWindow(RWin("Map Editor"));
                winMapEdit = false;
            }
            if(!Window_is_open(RWin("Room Editor"))) {
                OpenWindow(RWin("Room Editor"));
                winRoomEdit = true;
            }
            if(!Window_is_open(RWin("Tiles"))) {
                OpenWindow(RWin("Tiles"));
                winTiles = true;
            }
        }
    }
	}
}
void ExitRoomEdit(void) {
    if(!Window_is_open(RWin("Map Editor"))) {
        OpenWindow(RWin("Map Editor"));
        winMapEdit = true;
    }
    if(Window_is_open(RWin("Room Editor"))) {
        CloseWindow(RWin("Room Editor"));
        winRoomEdit = false;
    }
    if(Window_is_open(RWin("Tiles"))) {
        CloseWindow(RWin("Tiles"));
    winTiles = false;
    }
}
void UpRoom(void) {
    Windows[RWin("Room Editor")]->ScrollBoxes[0]->ItemUp(selectedroom);
    Windows[RWin("Map Editor")]->ListBoxes[0]->ItemUp(selectedroom);
    Windows[RWin("Map Editor")]->Viewports[0]->Refresh();
}
void DnRoom(void) {
    Windows[RWin("Room Editor")]->ScrollBoxes[0]->ItemDn(selectedroom);
    Windows[RWin("Map Editor")]->ListBoxes[0]->ItemDn(selectedroom);
    Windows[RWin("Map Editor")]->Viewports[0]->Refresh();
}
void SaveRoomName(bool save) {
    if(save == true) {
        Windows[RWin("New Room")]->TextBoxes[0]->SetRefmode(2);
    } else {
        Windows[RWin("New Room")]->TextBoxes[0]->SetRefmode(1);
    }
}
void SaveImportName(bool save) {
    if(save == true) {
        Windows[RWin("Import Room")]->TextBoxes[0]->SetRefmode(2);
    } else {
        Windows[RWin("Import Room")]->TextBoxes[0]->SetRefmode(1);
    }
}
void SaveExportName(bool save) {
    if(save == true) {
        Windows[RWin("Export Room")]->TextBoxes[0]->SetRefmode(2);
    } else {
        Windows[RWin("Export Room")]->TextBoxes[0]->SetRefmode(1);
    }
}

void Set_Screen(void) {
    if(main_size == 0) {
        main_width = 512;
        main_height = 384;
    } else if(main_size == 1) {
        main_width = 640;
        main_height = 400;
    } else if(main_size == 2) {
        main_width = 640;
        main_height = 480;
    } else if(main_size == 3) {
        main_width = 800;
        main_height = 600;
    } else if(main_size == 4) {
        main_width = 848;
        main_height = 480;
    } else if(main_size == 5) {
        main_width = 960;
        main_height = 600;
    } else if(main_size == 6) {
        main_width = 1024;
        main_height = 768;
    }
    for(short i = 0; i < WindowAmount; i ++) {
        Windows[i]->In_Screen();
    }
    short msx = mouse_x;
    short msy = mouse_y;
    if(fullscreen)
        set_gfx_mode(GFX_DIRECTX_ACCEL, main_width, main_height, 0, 0);  //Set the screen resolution
    else
        set_gfx_mode(GFX_DIRECTX_WIN, main_width, main_height, 0, 0);  //Set the screen resolution
    if((buffer = create_bitmap(main_width, main_height)) == NULL) {
        allegro_message("Image Error:\n    The screen buffer could not be created.\n\nAborting Program");
        exit(1);
    }
    clear_to_color(buffer, BLACK);
    mouse_x = msx;
    mouse_y = msy;
}
